/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryArithmetic;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Subtract$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.MathUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns `expr1`-`expr2`.", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 1;\n       1\n  ", since="1.0.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0013&\u0001JB\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005\u0005\"Aa\t\u0001BK\u0002\u0013\u0005\u0011\t\u0003\u0005H\u0001\tE\t\u0015!\u0003C\u0011!A\u0005A!f\u0001\n\u0003I\u0005\u0002C'\u0001\u0005#\u0005\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000b9\u0003A\u0011\u0001+\t\u000b]\u0003A\u0011\t-\t\u000b}\u0003A\u0011\t1\t\u000b1\u0004A\u0011\t1\t\u000b5\u0004A\u0011\t1\t\u00119\u0004\u0001R1A\u0005\n=DQ\u0001 \u0001\u0005RuDq!!\u0002\u0001\t\u0003\n9\u0001C\u0004\u0002\u0010\u0001!\t&!\u0005\t\u0013\u0005m\u0001!!A\u0005\u0002\u0005u\u0001\"CA\u0013\u0001E\u0005I\u0011AA\u0014\u0011%\ti\u0004AI\u0001\n\u0003\t9\u0003C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003/\u0002\u0011\u0011!C\u0001\u00033B\u0011\"!\u0019\u0001\u0003\u0003%\t!a\u0019\t\u0013\u0005%\u0004!!A\u0005B\u0005-\u0004\"CA=\u0001\u0005\u0005I\u0011AA>\u0011%\ty\bAA\u0001\n\u0003\n\tiB\u0005\u0002&\u0016\n\t\u0011#\u0001\u0002(\u001aAA%JA\u0001\u0012\u0003\tI\u000b\u0003\u0004O9\u0011\u0005\u0011q\u0017\u0005\n\u0003sc\u0012\u0011!C#\u0003wC\u0011\"!0\u001d\u0003\u0003%\t)a0\t\u0013\u0005\u001dG$%A\u0005\u0002\u0005\u0005\u0003\"CAe9\u0005\u0005I\u0011QAf\u0011%\tI\u000eHI\u0001\n\u0003\t\t\u0005C\u0005\u0002\\r\t\t\u0011\"\u0003\u0002^\nA1+\u001e2ue\u0006\u001cGO\u0003\u0002'O\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tA\u0013&\u0001\u0005dCR\fG._:u\u0015\tQ3&A\u0002tc2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0011\u00011gN\u001f\u0011\u0005Q*T\"A\u0013\n\u0005Y*#\u0001\u0005\"j]\u0006\u0014\u00180\u0011:ji\"lW\r^5d!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000f \n\u0005}J$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012A\u0011\t\u0003i\rK!\u0001R\u0013\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\fM\u0006LGn\u00148FeJ|'/F\u0001K!\tA4*\u0003\u0002Ms\t9!i\\8mK\u0006t\u0017\u0001\u00044bS2|e.\u0012:s_J\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Q#J\u001b\u0006C\u0001\u001b\u0001\u0011\u0015\u0001u\u00011\u0001C\u0011\u00151u\u00011\u0001C\u0011\u001dAu\u0001%AA\u0002)#2\u0001U+W\u0011\u0015\u0001\u0005\u00021\u0001C\u0011\u00151\u0005\u00021\u0001C\u0003%Ig\u000e];u)f\u0004X-F\u0001Z!\tQV,D\u0001\\\u0015\ta\u0016&A\u0003usB,7/\u0003\u0002_7\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\u0007gfl'm\u001c7\u0016\u0003\u0005\u0004\"AY5\u000f\u0005\r<\u0007C\u00013:\u001b\u0005)'B\u000142\u0003\u0019a$o\\8u}%\u0011\u0001.O\u0001\u0007!J,G-\u001a4\n\u0005)\\'AB*ue&twM\u0003\u0002is\u0005iA-Z2j[\u0006dW*\u001a;i_\u0012\facY1mK:$\u0017M]%oi\u0016\u0014h/\u00197NKRDw\u000eZ\u0001\b]VlWM]5d+\u0005\u0001\bcA9ws:\u0011!\u000f\u001e\b\u0003INL\u0011AO\u0005\u0003kf\nq\u0001]1dW\u0006<W-\u0003\u0002xq\n9a*^7fe&\u001c'BA;:!\tA$0\u0003\u0002|s\t\u0019\u0011I\\=\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tet\u0018\u0011\u0001\u0005\u0006\u007f:\u0001\r!_\u0001\u0007S:\u0004X\u000f^\u0019\t\r\u0005\ra\u00021\u0001z\u0003\u0019Ig\u000e];ue\u0005yQ\r_1di6\u000bG\u000f['fi\"|G-\u0006\u0002\u0002\nA!\u0001(a\u0003b\u0013\r\ti!\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dG#\u0002)\u0002\u0014\u0005]\u0001BBA\u000b!\u0001\u0007!)A\u0004oK^dUM\u001a;\t\r\u0005e\u0001\u00031\u0001C\u0003!qWm\u001e*jO\"$\u0018\u0001B2paf$r\u0001UA\u0010\u0003C\t\u0019\u0003C\u0004A#A\u0005\t\u0019\u0001\"\t\u000f\u0019\u000b\u0002\u0013!a\u0001\u0005\"9\u0001*\u0005I\u0001\u0002\u0004Q\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SQ3AQA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cs\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t\u0019EK\u0002K\u0003W\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\nA\u0001\\1oO*\u0011\u00111K\u0001\u0005U\u00064\u0018-C\u0002k\u0003\u001b\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0017\u0011\u0007a\ni&C\u0002\u0002`e\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!_A3\u0011%\t9gFA\u0001\u0002\u0004\tY&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003[\u0002R!a\u001c\u0002vel!!!\u001d\u000b\u0007\u0005M\u0014(\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002r\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rQ\u0015Q\u0010\u0005\t\u0003OJ\u0012\u0011!a\u0001s\u00061Q-];bYN$2ASAB\u0011!\t9GGA\u0001\u0002\u0004I\bf\u0005\u0001\u0002\b\u00065\u0015qRAJ\u0003+\u000bI*a'\u0002 \u0006\u0005\u0006c\u0001\u001b\u0002\n&\u0019\u00111R\u0013\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011S\u0001.Kb\u0004(/\r\u0011`\rVs5i\u0018\u0011fqB\u0014(\u0007I\u0017!%\u0016$XO\u001d8tA\u0001,\u0007\u0010\u001d:2A6\u0002W\r\u001f9se\u0001t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005]\u0015!\u000e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!e\u0001zf)\u0016(D?\u0002\n4H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019\u000bA\u0001\nQa]5oG\u0016\f#!!(\u0002\u000bEr\u0003G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\r\u0016AC7bi\"|f-\u001e8dg\u0006A1+\u001e2ue\u0006\u001cG\u000f\u0005\u000259M!A$a+>!!\ti+a-C\u0005*\u0003VBAAX\u0015\r\t\t,O\u0001\beVtG/[7f\u0013\u0011\t),a,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0006\u0002\u0002(\u0006AAo\\*ue&tw\r\u0006\u0002\u0002J\u0005)\u0011\r\u001d9msR9\u0001+!1\u0002D\u0006\u0015\u0007\"\u0002! \u0001\u0004\u0011\u0005\"\u0002$ \u0001\u0004\u0011\u0005b\u0002% !\u0003\u0005\rAS\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003BAg\u0003+\u0004R\u0001OA\u0006\u0003\u001f\u0004b\u0001OAi\u0005\nS\u0015bAAjs\t1A+\u001e9mKNB\u0001\"a6\"\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z:pYZ,GCAAp!\u0011\tY%!9\n\t\u0005\r\u0018Q\n\u0002\u0007\u001f\nTWm\u0019;")
public class Subtract
extends BinaryArithmetic {
    private Numeric<Object> numeric;
    private final Expression left;
    private final Expression right;
    private final boolean failOnError;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$3() {
        return Subtract$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Object>> unapply(Subtract subtract) {
        return Subtract$.MODULE$.unapply(subtract);
    }

    public static boolean apply$default$3() {
        return Subtract$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Object>, Subtract> tupled() {
        return Subtract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Object, Subtract>>> curried() {
        return Subtract$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public AbstractDataType inputType() {
        return TypeCollection$.MODULE$.NumericAndInterval();
    }

    @Override
    public String symbol() {
        return "-";
    }

    @Override
    public String decimalMethod() {
        return "$minus";
    }

    @Override
    public String calendarIntervalMethod() {
        return this.failOnError() ? "subtractExact" : "subtract";
    }

    private Numeric<Object> numeric$lzycompute() {
        Subtract subtract = this;
        synchronized (subtract) {
            if (!this.bitmap$0) {
                this.numeric = TypeUtils$.MODULE$.getNumeric(this.dataType(), this.failOnError());
                this.bitmap$0 = true;
            }
        }
        return this.numeric;
    }

    private Numeric<Object> numeric() {
        return !this.bitmap$0 ? this.numeric$lzycompute() : this.numeric;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        void var3_13;
        boolean bl = false;
        DataType dataType = null;
        DataType dataType2 = this.dataType();
        if (CalendarIntervalType$.MODULE$.equals(dataType2)) {
            bl = true;
            dataType = dataType2;
            if (this.failOnError()) {
                CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtractExact((CalendarInterval)input1, (CalendarInterval)input2);
                return var3_13;
            }
        }
        if (bl) {
            CalendarInterval calendarInterval = IntervalUtils$.MODULE$.subtract((CalendarInterval)input1, (CalendarInterval)input2);
            return var3_13;
        }
        if (dataType2 instanceof DayTimeIntervalType) {
            Long l = BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2)));
            return var3_13;
        }
        if (dataType2 instanceof YearMonthIntervalType) {
            Integer n = BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2)));
            return var3_13;
        }
        if (dataType2 instanceof IntegerType && this.failOnError()) {
            Integer n = BoxesRunTime.boxToInteger((int)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToInt((Object)input1), BoxesRunTime.unboxToInt((Object)input2), this.queryContext()));
            return var3_13;
        }
        if (dataType2 instanceof LongType && this.failOnError()) {
            Long l = BoxesRunTime.boxToLong((long)MathUtils$.MODULE$.subtractExact(BoxesRunTime.unboxToLong((Object)input1), BoxesRunTime.unboxToLong((Object)input2), this.queryContext()));
            return var3_13;
        }
        Object object = this.numeric().minus(input1, input2);
        return var3_13;
    }

    @Override
    public Option<String> exactMathMethod() {
        return new Some((Object)"subtractExact");
    }

    @Override
    public Subtract withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public Subtract copy(Expression left, Expression right, boolean failOnError) {
        return new Subtract(left, right, failOnError);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public boolean copy$default$3() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Subtract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.left();
                break;
            }
            case 1: {
                object = this.right();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Subtract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Subtract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Subtract subtract = (Subtract)x$1;
        Expression expression = this.left();
        Expression expression2 = subtract.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = subtract.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (this.failOnError() != subtract.failOnError()) return false;
        if (!subtract.canEqual(this)) return false;
        return true;
    }

    public Subtract(Expression left, Expression right, boolean failOnError) {
        this.left = left;
        this.right = right;
        this.failOnError = failOnError;
    }

    public Subtract(Expression left, Expression right) {
        this(left, right, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

