/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.kafka;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.kafka.HBaseKafkaEvent;
import org.apache.hadoop.hbase.kafka.TopicRoutingRules;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KafkaTableForBridge
implements Table {
    private Logger LOG = LoggerFactory.getLogger(KafkaTableForBridge.class);
    private final Configuration conf;
    private final TableName tableName;
    private byte[] tableAsBytes;
    private Producer<byte[], byte[]> producer;
    private TopicRoutingRules routingRules;
    private DatumWriter<HBaseKafkaEvent> avroWriter;

    public RegionLocator getRegionLocator() throws IOException {
        throw new UnsupportedOperationException();
    }

    public KafkaTableForBridge(TableName tableName, Configuration conf, TopicRoutingRules routingRules, Producer<byte[], byte[]> producer, DatumWriter<HBaseKafkaEvent> avroWriter) {
        this.conf = conf;
        this.tableName = tableName;
        this.tableAsBytes = this.tableName.toBytes();
        this.routingRules = routingRules;
        this.producer = producer;
        this.avroWriter = avroWriter;
    }

    private List<Pair<String, HBaseKafkaEvent>> processMutation(CheckMutation check, boolean isDelete) {
        HBaseKafkaEvent event = new HBaseKafkaEvent();
        event.setKey(ByteBuffer.wrap(check.cell.getRowArray(), check.cell.getRowOffset(), check.cell.getRowLength()));
        event.setTable(ByteBuffer.wrap(this.tableAsBytes));
        event.setDelete(Boolean.valueOf(isDelete));
        event.setTimestamp(Long.valueOf(check.cell.getTimestamp()));
        event.setFamily(ByteBuffer.wrap(check.family));
        event.setQualifier(ByteBuffer.wrap(check.qualifier));
        event.setValue(ByteBuffer.wrap(check.cell.getValueArray(), check.cell.getValueOffset(), check.cell.getValueLength()));
        return check.topics.stream().map(topic -> new Pair(topic, (Object)event)).collect(Collectors.toList());
    }

    private boolean keep(CheckMutation ret) {
        return !this.routingRules.isExclude(this.tableName, ret.family, ret.qualifier);
    }

    private CheckMutation addTopics(CheckMutation ret) {
        ret.topics = this.routingRules.getTopics(this.tableName, ret.family, ret.qualifier);
        return ret;
    }

    private ProducerRecord<byte[], byte[]> toByteArray(ByteArrayOutputStream bout, Pair<String, HBaseKafkaEvent> event, BinaryEncoder encoder) {
        try {
            bout.reset();
            BinaryEncoder encoderUse = EncoderFactory.get().binaryEncoder((OutputStream)bout, encoder);
            this.avroWriter.write(event.getSecond(), (Encoder)encoderUse);
            encoder.flush();
            return new ProducerRecord((String)event.getFirst(), (Object)((HBaseKafkaEvent)event.getSecond()).getKey().array(), (Object)bout.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void batch(List<? extends Row> actions, Object[] results) throws IOException, InterruptedException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        BinaryEncoder encoderUse = EncoderFactory.get().binaryEncoder((OutputStream)bout, null);
        this.LOG.debug("got {} inputs ", (Object)actions.size());
        ArrayList sends = new ArrayList();
        actions.stream().filter(row -> row instanceof Mutation).map(row -> (Mutation)row).flatMap(row -> {
            Mutation mut = row;
            boolean isDelete = mut instanceof Delete;
            return mut.getFamilyCellMap().keySet().stream().flatMap(family -> ((List)mut.getFamilyCellMap().get(family)).stream()).map(cell -> {
                CheckMutation ret = new CheckMutation();
                ret.family = CellUtil.cloneFamily((Cell)cell);
                ret.qualifier = CellUtil.cloneQualifier((Cell)cell);
                ret.cell = cell;
                return ret;
            }).filter(check -> this.keep((CheckMutation)check)).map(check -> this.addTopics((CheckMutation)check)).filter(check -> !CollectionUtils.isEmpty(check.topics)).flatMap(check -> this.processMutation((CheckMutation)check, isDelete).stream());
        }).map(event -> this.toByteArray(bout, (Pair<String, HBaseKafkaEvent>)event, encoderUse)).forEach(item -> sends.add(this.producer.send(item)));
        sends.stream().forEach(sendResult -> {
            try {
                sendResult.get();
            }
            catch (Exception e) {
                this.LOG.error("Exception caught when getting result", (Throwable)e);
                throw new RuntimeException(e);
            }
        });
        this.producer.flush();
    }

    public void close() {
        this.producer.flush();
    }

    public TableName getName() {
        return this.tableName;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public HTableDescriptor getTableDescriptor() throws IOException {
        return null;
    }

    public TableDescriptor getDescriptor() throws IOException {
        return null;
    }

    private static final class CheckMutation {
        byte[] qualifier;
        byte[] family;
        Cell cell;
        List<String> topics = new ArrayList<String>();

        private CheckMutation() {
        }
    }
}

