/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class AuthenticationTokenIdentifier
extends TokenIdentifier {
    public static final Text AUTH_TOKEN_TYPE = new Text("HBASE_AUTH_TOKEN");
    protected String username;
    protected int keyId;
    protected long issueDate;
    protected long expirationDate;
    protected long sequenceNumber;

    public AuthenticationTokenIdentifier() {
    }

    public AuthenticationTokenIdentifier(String username) {
        this.username = username;
    }

    public AuthenticationTokenIdentifier(String username, int keyId, long issueDate, long expirationDate) {
        this.username = username;
        this.keyId = keyId;
        this.issueDate = issueDate;
        this.expirationDate = expirationDate;
    }

    @Override
    public Text getKind() {
        return AUTH_TOKEN_TYPE;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.username == null || "".equals(this.username)) {
            return null;
        }
        return UserGroupInformation.createRemoteUser(this.username);
    }

    public String getUsername() {
        return this.username;
    }

    void setUsername(String name) {
        this.username = name;
    }

    public int getKeyId() {
        return this.keyId;
    }

    void setKeyId(int id) {
        this.keyId = id;
    }

    public long getIssueDate() {
        return this.issueDate;
    }

    void setIssueDate(long timestamp) {
        this.issueDate = timestamp;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    void setExpirationDate(long timestamp) {
        this.expirationDate = timestamp;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    void setSequenceNumber(long seq) {
        this.sequenceNumber = seq;
    }

    public byte[] toBytes() {
        AuthenticationProtos.TokenIdentifier.Builder builder = AuthenticationProtos.TokenIdentifier.newBuilder();
        builder.setKind(AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN);
        if (this.username != null) {
            builder.setUsername(ByteString.copyFromUtf8(this.username));
        }
        builder.setIssueDate(this.issueDate).setExpirationDate(this.expirationDate).setKeyId(this.keyId).setSequenceNumber(this.sequenceNumber);
        return builder.build().toByteArray();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        byte[] pbBytes = this.toBytes();
        out.writeInt(pbBytes.length);
        out.write(pbBytes);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        byte[] inBytes = new byte[len];
        in.readFully(inBytes);
        AuthenticationProtos.TokenIdentifier.Builder builder = AuthenticationProtos.TokenIdentifier.newBuilder();
        ProtobufUtil.mergeFrom(builder, inBytes);
        AuthenticationProtos.TokenIdentifier identifier = builder.build();
        if (!identifier.hasKind() || identifier.getKind() != AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN) {
            throw new IOException("Invalid TokenIdentifier kind from input " + identifier.getKind());
        }
        if (identifier.hasUsername()) {
            this.username = identifier.getUsername().toStringUtf8();
        }
        if (identifier.hasKeyId()) {
            this.keyId = identifier.getKeyId();
        }
        if (identifier.hasIssueDate()) {
            this.issueDate = identifier.getIssueDate();
        }
        if (identifier.hasExpirationDate()) {
            this.expirationDate = identifier.getExpirationDate();
        }
        if (identifier.hasSequenceNumber()) {
            this.sequenceNumber = identifier.getSequenceNumber();
        }
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof AuthenticationTokenIdentifier) {
            AuthenticationTokenIdentifier ident = (AuthenticationTokenIdentifier)other;
            return this.sequenceNumber == ident.getSequenceNumber() && this.keyId == ident.getKeyId() && this.issueDate == ident.getIssueDate() && this.expirationDate == ident.getExpirationDate() && (this.username == null ? ident.getUsername() == null : this.username.equals(ident.getUsername()));
        }
        return false;
    }

    public int hashCode() {
        return (int)this.sequenceNumber;
    }

    public String toString() {
        return "(username=" + this.username + ", keyId=" + this.keyId + ", issueDate=" + this.issueDate + ", expirationDate=" + this.expirationDate + ", sequenceNumber=" + this.sequenceNumber + ")";
    }
}

