/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm;

import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.AnnotationWriter;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ByteVector;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassTooLargeException;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.FieldWriter;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.MethodWriter;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.ModuleWriter;
import org.jruby.org.objectweb.asm.RecordComponentVisitor;
import org.jruby.org.objectweb.asm.RecordComponentWriter;
import org.jruby.org.objectweb.asm.Symbol;
import org.jruby.org.objectweb.asm.SymbolTable;
import org.jruby.org.objectweb.asm.TypePath;

public class ClassWriter
extends ClassVisitor {
    public static final int COMPUTE_MAXS = 1;
    public static final int COMPUTE_FRAMES = 2;
    private int version;
    private final SymbolTable symbolTable;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private FieldWriter firstField;
    private FieldWriter lastField;
    private MethodWriter firstMethod;
    private MethodWriter lastMethod;
    private int numberOfInnerClasses;
    private ByteVector innerClasses;
    private int enclosingClassIndex;
    private int enclosingMethodIndex;
    private int signatureIndex;
    private int sourceFileIndex;
    private ByteVector debugExtension;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ModuleWriter moduleWriter;
    private int nestHostClassIndex;
    private int numberOfNestMemberClasses;
    private ByteVector nestMemberClasses;
    private int numberOfPermittedSubclasses;
    private ByteVector permittedSubclasses;
    private RecordComponentWriter firstRecordComponent;
    private RecordComponentWriter lastRecordComponent;
    private Attribute firstAttribute;
    private int compute;

    public ClassWriter(int flags2) {
        this(null, flags2);
    }

    public ClassWriter(ClassReader classReader, int flags2) {
        super(589824);
        SymbolTable symbolTable = this.symbolTable = classReader == null ? new SymbolTable(this) : new SymbolTable(this, classReader);
        this.compute = (flags2 & 2) != 0 ? 4 : ((flags2 & 1) != 0 ? 1 : 0);
    }

    public final void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        this.version = version;
        this.accessFlags = access;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(version & 0xFFFF, name2);
        if (signature != null) {
            this.signatureIndex = this.symbolTable.addConstantUtf8(signature);
        }
        int n = this.superClass = superName == null ? 0 : this.symbolTable.addConstantClass((String)superName).index;
        if (interfaces2 != null && interfaces2.length > 0) {
            this.interfaceCount = interfaces2.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
                this.interfaces[i2] = this.symbolTable.addConstantClass((String)interfaces2[i2]).index;
            }
        }
        if (this.compute == 1 && (version & 0xFFFF) >= 51) {
            this.compute = 2;
        }
    }

    public final void visitSource(String file2, String debug) {
        if (file2 != null) {
            this.sourceFileIndex = this.symbolTable.addConstantUtf8(file2);
        }
        if (debug != null) {
            this.debugExtension = new ByteVector().encodeUtf8(debug, 0, Integer.MAX_VALUE);
        }
    }

    public final ModuleVisitor visitModule(String name2, int access, String version) {
        this.moduleWriter = new ModuleWriter(this.symbolTable, this.symbolTable.addConstantModule((String)name2).index, access, version == null ? 0 : this.symbolTable.addConstantUtf8(version));
        return this.moduleWriter;
    }

    public final void visitNestHost(String nestHost) {
        this.nestHostClassIndex = this.symbolTable.addConstantClass((String)nestHost).index;
    }

    public final void visitOuterClass(String owner2, String name2, String descriptor) {
        this.enclosingClassIndex = this.symbolTable.addConstantClass((String)owner2).index;
        if (name2 != null && descriptor != null) {
            this.enclosingMethodIndex = this.symbolTable.addConstantNameAndType(name2, descriptor);
        }
    }

    public final AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (visible) {
            this.lastRuntimeVisibleAnnotation = AnnotationWriter.create(this.symbolTable, descriptor, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = AnnotationWriter.create(this.symbolTable, descriptor, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public final AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        if (visible) {
            this.lastRuntimeVisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, typeRef, typePath, descriptor, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = AnnotationWriter.create(this.symbolTable, typeRef, typePath, descriptor, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public final void visitAttribute(Attribute attribute) {
        attribute.nextAttribute = this.firstAttribute;
        this.firstAttribute = attribute;
    }

    public final void visitNestMember(String nestMember) {
        if (this.nestMemberClasses == null) {
            this.nestMemberClasses = new ByteVector();
        }
        ++this.numberOfNestMemberClasses;
        this.nestMemberClasses.putShort(this.symbolTable.addConstantClass((String)nestMember).index);
    }

    public final void visitPermittedSubclass(String permittedSubclass) {
        if (this.permittedSubclasses == null) {
            this.permittedSubclasses = new ByteVector();
        }
        ++this.numberOfPermittedSubclasses;
        this.permittedSubclasses.putShort(this.symbolTable.addConstantClass((String)permittedSubclass).index);
    }

    public final void visitInnerClass(String name2, String outerName, String innerName, int access) {
        if (this.innerClasses == null) {
            this.innerClasses = new ByteVector();
        }
        Symbol nameSymbol = this.symbolTable.addConstantClass(name2);
        if (nameSymbol.info == 0) {
            ++this.numberOfInnerClasses;
            this.innerClasses.putShort(nameSymbol.index);
            this.innerClasses.putShort(outerName == null ? 0 : this.symbolTable.addConstantClass((String)outerName).index);
            this.innerClasses.putShort(innerName == null ? 0 : this.symbolTable.addConstantUtf8(innerName));
            this.innerClasses.putShort(access);
            nameSymbol.info = this.numberOfInnerClasses;
        }
    }

    public final RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
        RecordComponentWriter recordComponentWriter = new RecordComponentWriter(this.symbolTable, name2, descriptor, signature);
        if (this.firstRecordComponent == null) {
            this.firstRecordComponent = recordComponentWriter;
        } else {
            this.lastRecordComponent.delegate = recordComponentWriter;
        }
        this.lastRecordComponent = recordComponentWriter;
        return this.lastRecordComponent;
    }

    public final FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        FieldWriter fieldWriter = new FieldWriter(this.symbolTable, access, name2, descriptor, signature, value2);
        if (this.firstField == null) {
            this.firstField = fieldWriter;
        } else {
            this.lastField.fv = fieldWriter;
        }
        this.lastField = fieldWriter;
        return this.lastField;
    }

    public final MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        MethodWriter methodWriter = new MethodWriter(this.symbolTable, access, name2, descriptor, signature, exceptions, this.compute);
        if (this.firstMethod == null) {
            this.firstMethod = methodWriter;
        } else {
            this.lastMethod.mv = methodWriter;
        }
        this.lastMethod = methodWriter;
        return this.lastMethod;
    }

    public final void visitEnd() {
    }

    public byte[] toByteArray() {
        int size2 = 24 + 2 * this.interfaceCount;
        int fieldsCount = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++fieldsCount;
            size2 += fieldWriter.computeFieldInfoSize();
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        int methodsCount = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++methodsCount;
            size2 += methodWriter.computeMethodInfoSize();
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        int attributesCount = 0;
        if (this.innerClasses != null) {
            ++attributesCount;
            size2 += 8 + this.innerClasses.length;
            this.symbolTable.addConstantUtf8("InnerClasses");
        }
        if (this.enclosingClassIndex != 0) {
            ++attributesCount;
            size2 += 10;
            this.symbolTable.addConstantUtf8("EnclosingMethod");
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            ++attributesCount;
            size2 += 6;
            this.symbolTable.addConstantUtf8("Synthetic");
        }
        if (this.signatureIndex != 0) {
            ++attributesCount;
            size2 += 8;
            this.symbolTable.addConstantUtf8("Signature");
        }
        if (this.sourceFileIndex != 0) {
            ++attributesCount;
            size2 += 8;
            this.symbolTable.addConstantUtf8("SourceFile");
        }
        if (this.debugExtension != null) {
            ++attributesCount;
            size2 += 6 + this.debugExtension.length;
            this.symbolTable.addConstantUtf8("SourceDebugExtension");
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++attributesCount;
            size2 += 6;
            this.symbolTable.addConstantUtf8("Deprecated");
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++attributesCount;
            size2 += this.lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++attributesCount;
            size2 += this.lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++attributesCount;
            size2 += this.lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++attributesCount;
            size2 += this.lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        if (this.symbolTable.computeBootstrapMethodsSize() > 0) {
            ++attributesCount;
            size2 += this.symbolTable.computeBootstrapMethodsSize();
        }
        if (this.moduleWriter != null) {
            attributesCount += this.moduleWriter.getAttributeCount();
            size2 += this.moduleWriter.computeAttributesSize();
        }
        if (this.nestHostClassIndex != 0) {
            ++attributesCount;
            size2 += 8;
            this.symbolTable.addConstantUtf8("NestHost");
        }
        if (this.nestMemberClasses != null) {
            ++attributesCount;
            size2 += 8 + this.nestMemberClasses.length;
            this.symbolTable.addConstantUtf8("NestMembers");
        }
        if (this.permittedSubclasses != null) {
            ++attributesCount;
            size2 += 8 + this.permittedSubclasses.length;
            this.symbolTable.addConstantUtf8("PermittedSubclasses");
        }
        int recordComponentCount = 0;
        int recordSize = 0;
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
            while (recordComponentWriter != null) {
                ++recordComponentCount;
                recordSize += recordComponentWriter.computeRecordComponentInfoSize();
                recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
            }
            ++attributesCount;
            size2 += 8 + recordSize;
            this.symbolTable.addConstantUtf8("Record");
        }
        if (this.firstAttribute != null) {
            attributesCount += this.firstAttribute.getAttributeCount();
            size2 += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        size2 += this.symbolTable.getConstantPoolLength();
        int constantPoolCount = this.symbolTable.getConstantPoolCount();
        if (constantPoolCount > 65535) {
            throw new ClassTooLargeException(this.symbolTable.getClassName(), constantPoolCount);
        }
        ByteVector result2 = new ByteVector(size2);
        result2.putInt(-889275714).putInt(this.version);
        this.symbolTable.putConstantPool(result2);
        int mask = (this.version & 0xFFFF) < 49 ? 4096 : 0;
        result2.putShort(this.accessFlags & ~mask).putShort(this.thisClass).putShort(this.superClass);
        result2.putShort(this.interfaceCount);
        for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
            result2.putShort(this.interfaces[i2]);
        }
        result2.putShort(fieldsCount);
        fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.putFieldInfo(result2);
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        result2.putShort(methodsCount);
        boolean hasFrames = false;
        boolean hasAsmInstructions = false;
        methodWriter = this.firstMethod;
        while (methodWriter != null) {
            hasFrames |= methodWriter.hasFrames();
            hasAsmInstructions |= methodWriter.hasAsmInstructions();
            methodWriter.putMethodInfo(result2);
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        result2.putShort(attributesCount);
        if (this.innerClasses != null) {
            result2.putShort(this.symbolTable.addConstantUtf8("InnerClasses")).putInt(this.innerClasses.length + 2).putShort(this.numberOfInnerClasses).putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.enclosingClassIndex != 0) {
            result2.putShort(this.symbolTable.addConstantUtf8("EnclosingMethod")).putInt(4).putShort(this.enclosingClassIndex).putShort(this.enclosingMethodIndex);
        }
        if ((this.accessFlags & 0x1000) != 0 && (this.version & 0xFFFF) < 49) {
            result2.putShort(this.symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (this.signatureIndex != 0) {
            result2.putShort(this.symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(this.signatureIndex);
        }
        if (this.sourceFileIndex != 0) {
            result2.putShort(this.symbolTable.addConstantUtf8("SourceFile")).putInt(2).putShort(this.sourceFileIndex);
        }
        if (this.debugExtension != null) {
            int length2 = this.debugExtension.length;
            result2.putShort(this.symbolTable.addConstantUtf8("SourceDebugExtension")).putInt(length2).putByteArray(this.debugExtension.data, 0, length2);
        }
        if ((this.accessFlags & 0x20000) != 0) {
            result2.putShort(this.symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
        AnnotationWriter.putAnnotations(this.symbolTable, this.lastRuntimeVisibleAnnotation, this.lastRuntimeInvisibleAnnotation, this.lastRuntimeVisibleTypeAnnotation, this.lastRuntimeInvisibleTypeAnnotation, result2);
        this.symbolTable.putBootstrapMethods(result2);
        if (this.moduleWriter != null) {
            this.moduleWriter.putAttributes(result2);
        }
        if (this.nestHostClassIndex != 0) {
            result2.putShort(this.symbolTable.addConstantUtf8("NestHost")).putInt(2).putShort(this.nestHostClassIndex);
        }
        if (this.nestMemberClasses != null) {
            result2.putShort(this.symbolTable.addConstantUtf8("NestMembers")).putInt(this.nestMemberClasses.length + 2).putShort(this.numberOfNestMemberClasses).putByteArray(this.nestMemberClasses.data, 0, this.nestMemberClasses.length);
        }
        if (this.permittedSubclasses != null) {
            result2.putShort(this.symbolTable.addConstantUtf8("PermittedSubclasses")).putInt(this.permittedSubclasses.length + 2).putShort(this.numberOfPermittedSubclasses).putByteArray(this.permittedSubclasses.data, 0, this.permittedSubclasses.length);
        }
        if ((this.accessFlags & 0x10000) != 0 || this.firstRecordComponent != null) {
            result2.putShort(this.symbolTable.addConstantUtf8("Record")).putInt(recordSize + 2).putShort(recordComponentCount);
            RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
            while (recordComponentWriter != null) {
                recordComponentWriter.putRecordComponentInfo(result2);
                recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
            }
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, result2);
        }
        if (hasAsmInstructions) {
            return this.replaceAsmInstructions(result2.data, hasFrames);
        }
        return result2.data;
    }

    private byte[] replaceAsmInstructions(byte[] classFile, boolean hasFrames) {
        Attribute[] attributes = this.getAttributePrototypes();
        this.firstField = null;
        this.lastField = null;
        this.firstMethod = null;
        this.lastMethod = null;
        this.lastRuntimeVisibleAnnotation = null;
        this.lastRuntimeInvisibleAnnotation = null;
        this.lastRuntimeVisibleTypeAnnotation = null;
        this.lastRuntimeInvisibleTypeAnnotation = null;
        this.moduleWriter = null;
        this.nestHostClassIndex = 0;
        this.numberOfNestMemberClasses = 0;
        this.nestMemberClasses = null;
        this.numberOfPermittedSubclasses = 0;
        this.permittedSubclasses = null;
        this.firstRecordComponent = null;
        this.lastRecordComponent = null;
        this.firstAttribute = null;
        this.compute = hasFrames ? 3 : 0;
        new ClassReader(classFile, 0, false).accept(this, attributes, (hasFrames ? 8 : 0) | 0x100);
        return this.toByteArray();
    }

    private Attribute[] getAttributePrototypes() {
        Attribute.Set attributePrototypes = new Attribute.Set();
        attributePrototypes.addAttributes(this.firstAttribute);
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.collectAttributePrototypes(attributePrototypes);
            fieldWriter = (FieldWriter)fieldWriter.fv;
        }
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            methodWriter.collectAttributePrototypes(attributePrototypes);
            methodWriter = (MethodWriter)methodWriter.mv;
        }
        RecordComponentWriter recordComponentWriter = this.firstRecordComponent;
        while (recordComponentWriter != null) {
            recordComponentWriter.collectAttributePrototypes(attributePrototypes);
            recordComponentWriter = (RecordComponentWriter)recordComponentWriter.delegate;
        }
        return attributePrototypes.toArray();
    }

    public int newConst(Object value2) {
        return this.symbolTable.addConstant((Object)value2).index;
    }

    public int newUTF8(String value2) {
        return this.symbolTable.addConstantUtf8(value2);
    }

    public int newClass(String value2) {
        return this.symbolTable.addConstantClass((String)value2).index;
    }

    public int newMethodType(String methodDescriptor) {
        return this.symbolTable.addConstantMethodType((String)methodDescriptor).index;
    }

    public int newModule(String moduleName) {
        return this.symbolTable.addConstantModule((String)moduleName).index;
    }

    public int newPackage(String packageName) {
        return this.symbolTable.addConstantPackage((String)packageName).index;
    }

    @Deprecated
    public int newHandle(int tag2, String owner2, String name2, String descriptor) {
        return this.newHandle(tag2, owner2, name2, descriptor, tag2 == 9);
    }

    public int newHandle(int tag2, String owner2, String name2, String descriptor, boolean isInterface) {
        return this.symbolTable.addConstantMethodHandle((int)tag2, (String)owner2, (String)name2, (String)descriptor, (boolean)isInterface).index;
    }

    public int newConstantDynamic(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        return this.symbolTable.addConstantDynamic((String)name2, (String)descriptor, (Handle)bootstrapMethodHandle, (Object[])bootstrapMethodArguments).index;
    }

    public int newInvokeDynamic(String name2, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        return this.symbolTable.addConstantInvokeDynamic((String)name2, (String)descriptor, (Handle)bootstrapMethodHandle, (Object[])bootstrapMethodArguments).index;
    }

    public int newField(String owner2, String name2, String descriptor) {
        return this.symbolTable.addConstantFieldref((String)owner2, (String)name2, (String)descriptor).index;
    }

    public int newMethod(String owner2, String name2, String descriptor, boolean isInterface) {
        return this.symbolTable.addConstantMethodref((String)owner2, (String)name2, (String)descriptor, (boolean)isInterface).index;
    }

    public int newNameType(String name2, String descriptor) {
        return this.symbolTable.addConstantNameAndType(name2, descriptor);
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class<?> class2;
        Class<?> class1;
        ClassLoader classLoader = this.getClassLoader();
        try {
            class1 = Class.forName(type1.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type1, e);
        }
        try {
            class2 = Class.forName(type2.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(type2, e);
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }

    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

