/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReservoirSample<T> {
    private final List<T> r;
    private final int k;
    private int n;

    public ReservoirSample(int k) {
        Preconditions.checkArgument(k > 0, "negative sampling number(%s) is not allowed", k);
        this.r = new ArrayList<T>(k);
        this.k = k;
    }

    public void add(T t) {
        if (this.n < this.k) {
            this.r.add(t);
        } else {
            int j = ThreadLocalRandom.current().nextInt(this.n + 1);
            if (j < this.k) {
                this.r.set(j, t);
            }
        }
        ++this.n;
    }

    public void add(Iterator<T> iter) {
        iter.forEachRemaining(this::add);
    }

    public void add(Stream<T> s2) {
        s2.forEachOrdered(this::add);
    }

    public List<T> getSamplingResult() {
        return this.r;
    }
}

