/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestFilterListOrOperatorWithBlkCnt {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterListOrOperatorWithBlkCnt.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestFilterListOrOperatorWithBlkCnt.class);
    private byte[] family = Bytes.toBytes((String)"family");
    private byte[] qf = Bytes.toBytes((String)"qf");
    private byte[] value = Bytes.toBytes((String)"val");
    private TableName tableName;
    private int numRows = 10000;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        long blkSize = 4096L;
        TEST_UTIL.getConfiguration().setLong("dfs.blocksize", blkSize);
        TEST_UTIL.getConfiguration().setLong("dfs.bytes-per-checksum", blkSize);
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private static long getBlkAccessCount() {
        return HFile.DATABLOCK_READ_COUNT.sum();
    }

    @Test
    public void testMultiRowRangeWithFilterListOrOperatorWithBlkCnt() throws IOException {
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
        Table ht = TEST_UTIL.createTable(this.tableName, this.family, Integer.MAX_VALUE);
        this.generateRows(this.numRows, ht, this.family, this.qf, this.value);
        Scan scan = new Scan();
        scan.setMaxVersions();
        long blocksStart = TestFilterListOrOperatorWithBlkCnt.getBlkAccessCount();
        ArrayList<MultiRowRangeFilter.RowRange> ranges1 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)15), false));
        ranges1.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)9980), true, Bytes.toBytes((int)9985), false));
        MultiRowRangeFilter filter1 = new MultiRowRangeFilter(ranges1);
        ArrayList<MultiRowRangeFilter.RowRange> ranges2 = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)15), true, Bytes.toBytes((int)20), false));
        ranges2.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)9985), true, Bytes.toBytes((int)9990), false));
        MultiRowRangeFilter filter2 = new MultiRowRangeFilter(ranges2);
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
        filterList.addFilter((Filter)filter1);
        filterList.addFilter((Filter)filter2);
        scan.setFilter((Filter)filterList);
        int resultsSize = this.getResultsSize(ht, scan);
        LOG.info("found " + resultsSize + " results");
        List<Cell> results1 = this.getScanResult(Bytes.toBytes((int)10), Bytes.toBytes((int)20), ht);
        List<Cell> results2 = this.getScanResult(Bytes.toBytes((int)9980), Bytes.toBytes((int)9990), ht);
        Assert.assertEquals((long)(results1.size() + results2.size()), (long)resultsSize);
        long blocksEnd = TestFilterListOrOperatorWithBlkCnt.getBlkAccessCount();
        long diff = blocksEnd - blocksStart;
        LOG.info("Diff in number of blocks " + diff);
        Assert.assertEquals((long)4L, (long)diff);
        ht.close();
    }

    private void generateRows(int numberOfRows, Table ht, byte[] family, byte[] qf, byte[] value) throws IOException {
        for (int i = 0; i < numberOfRows; ++i) {
            byte[] row = Bytes.toBytes((int)i);
            Put p = new Put(row);
            p.addColumn(family, qf, value);
            p.setDurability(Durability.SKIP_WAL);
            ht.put(p);
        }
        TEST_UTIL.flush();
    }

    private List<Cell> getScanResult(byte[] startRow, byte[] stopRow, Table ht) throws IOException {
        Result r;
        Scan scan = new Scan();
        scan.setMaxVersions();
        if (!Bytes.toString((byte[])startRow).isEmpty()) {
            scan.setStartRow(startRow);
        }
        if (!Bytes.toString((byte[])stopRow).isEmpty()) {
            scan.setStopRow(stopRow);
        }
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> kvList = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                kvList.add(kv);
            }
        }
        return kvList;
    }

    private int getResultsSize(Table ht, Scan scan) throws IOException {
        Result r;
        ResultScanner scanner = ht.getScanner(scan);
        ArrayList<Cell> results = new ArrayList<Cell>();
        while ((r = scanner.next()) != null) {
            for (Cell kv : r.listCells()) {
                results.add(kv);
            }
        }
        return results.size();
    }
}

