/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.api.exceptions.HelixMetaDataAccessException;
import org.apache.helix.api.listeners.ClusterConfigChangeListener;
import org.apache.helix.api.listeners.ControllerChangeListener;
import org.apache.helix.api.listeners.CurrentStateChangeListener;
import org.apache.helix.api.listeners.CustomizedStateChangeListener;
import org.apache.helix.api.listeners.CustomizedStateConfigChangeListener;
import org.apache.helix.api.listeners.CustomizedStateRootChangeListener;
import org.apache.helix.api.listeners.IdealStateChangeListener;
import org.apache.helix.api.listeners.InstanceConfigChangeListener;
import org.apache.helix.api.listeners.LiveInstanceChangeListener;
import org.apache.helix.api.listeners.MessageListener;
import org.apache.helix.api.listeners.PreFetch;
import org.apache.helix.api.listeners.ResourceConfigChangeListener;
import org.apache.helix.api.listeners.TaskCurrentStateChangeListener;
import org.apache.helix.common.ClusterEventBlockingQueue;
import org.apache.helix.common.DedupEventProcessor;
import org.apache.helix.controller.dataproviders.BaseControllerDataProvider;
import org.apache.helix.controller.dataproviders.ManagementControllerDataProvider;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.pipeline.PipelineRegistry;
import org.apache.helix.controller.rebalancer.StatefulRebalancer;
import org.apache.helix.controller.rebalancer.waged.WagedRebalancer;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.BestPossibleStateCalcStage;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ClusterEventType;
import org.apache.helix.controller.stages.CompatibilityCheckStage;
import org.apache.helix.controller.stages.CurrentStateComputationStage;
import org.apache.helix.controller.stages.CustomizedStateComputationStage;
import org.apache.helix.controller.stages.CustomizedViewAggregationStage;
import org.apache.helix.controller.stages.ExternalViewComputeStage;
import org.apache.helix.controller.stages.IntermediateStateCalcStage;
import org.apache.helix.controller.stages.MaintenanceRecoveryStage;
import org.apache.helix.controller.stages.ManagementMessageDispatchStage;
import org.apache.helix.controller.stages.ManagementMessageGenerationPhase;
import org.apache.helix.controller.stages.ManagementModeStage;
import org.apache.helix.controller.stages.MessageGenerationPhase;
import org.apache.helix.controller.stages.MessageSelectionStage;
import org.apache.helix.controller.stages.MessageThrottleStage;
import org.apache.helix.controller.stages.PersistAssignmentStage;
import org.apache.helix.controller.stages.ReadClusterDataStage;
import org.apache.helix.controller.stages.ResourceComputationStage;
import org.apache.helix.controller.stages.ResourceValidationStage;
import org.apache.helix.controller.stages.TargetExteralViewCalcStage;
import org.apache.helix.controller.stages.TaskGarbageCollectionStage;
import org.apache.helix.controller.stages.TopStateHandoffReportStage;
import org.apache.helix.controller.stages.resource.ResourceMessageDispatchStage;
import org.apache.helix.controller.stages.task.TaskMessageDispatchStage;
import org.apache.helix.controller.stages.task.TaskPersistDataStage;
import org.apache.helix.controller.stages.task.TaskSchedulingStage;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedState;
import org.apache.helix.model.CustomizedStateConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.mbeans.ClusterEventMonitor;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.helix.zookeeper.zkclient.exception.ZkInterruptedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericHelixController
implements IdealStateChangeListener,
LiveInstanceChangeListener,
MessageListener,
CurrentStateChangeListener,
TaskCurrentStateChangeListener,
CustomizedStateRootChangeListener,
CustomizedStateChangeListener,
CustomizedStateConfigChangeListener,
ControllerChangeListener,
InstanceConfigChangeListener,
ResourceConfigChangeListener,
ClusterConfigChangeListener {
    private static final Logger logger = LoggerFactory.getLogger((String)GenericHelixController.class.getName());
    private static final long EVENT_THREAD_JOIN_TIMEOUT = 1000L;
    private static final int ASYNC_TASKS_THREADPOOL_SIZE = 10;
    private final PipelineRegistry _registry;
    private final PipelineRegistry _taskRegistry;
    private final PipelineRegistry _managementModeRegistry;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenInstances;
    final AtomicReference<Map<String, LiveInstance>> _lastSeenSessions;
    final AtomicReference<Map<String, Set<String>>> _lastSeenCustomizedStateTypesMapRef;
    private boolean _isMonitoring = false;
    private final ClusterStatusMonitor _clusterStatusMonitor;
    private final ClusterEventBlockingQueue _eventQueue;
    private final ClusterEventProcessor _eventThread;
    private final ClusterEventBlockingQueue _taskEventQueue;
    private final ClusterEventProcessor _taskEventThread;
    private boolean _inManagementMode;
    private final ClusterEventBlockingQueue _managementModeEventQueue;
    private final ClusterEventProcessor _managementModeEventThread;
    private final Map<AsyncWorkerType, DedupEventProcessor<String, Runnable>> _asyncFIFOWorkerPool;
    private long _continuousRebalanceFailureCount = 0L;
    private long _continuousResourceRebalanceFailureCount = 0L;
    private long _continuousTaskRebalanceFailureCount = 0L;
    private final ScheduledExecutorService _periodicalRebalanceExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture _periodicRebalanceFutureTask = null;
    long _timerPeriod = Long.MAX_VALUE;
    Timer _onDemandRebalanceTimer = null;
    AtomicReference<RebalanceTask> _nextRebalanceTask = new AtomicReference();
    private final ResourceControllerDataProvider _resourceControlDataProvider;
    private final WorkflowControllerDataProvider _workflowControlDataProvider;
    private final ManagementControllerDataProvider _managementControllerDataProvider;
    private final ScheduledExecutorService _asyncTasksThreadPool;
    private long _lastPipelineEndTimestamp;
    private final String _clusterName;
    private final Set<Pipeline.Type> _enabledPipelineTypes;
    private HelixManager _helixManager;
    private final StatefulRebalancerRef _rebalancerRef = new StatefulRebalancerRef(){

        protected StatefulRebalancer createRebalancer(HelixManager helixManager) {
            return new WagedRebalancer(helixManager);
        }
    };
    private static Map<String, ImmutableSet<GenericHelixController>> _helixControllerFactory = new ConcurrentHashMap<String, ImmutableSet<GenericHelixController>>();

    public static GenericHelixController getLeaderController(String clusterName) {
        ImmutableSet<GenericHelixController> controllers;
        if (clusterName != null && (controllers = _helixControllerFactory.get(clusterName)) != null) {
            return controllers.stream().filter(controller -> controller._helixManager.isLeader()).findAny().orElse(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addController(GenericHelixController controller) {
        if (controller != null && controller._clusterName != null) {
            Map<String, ImmutableSet<GenericHelixController>> map = _helixControllerFactory;
            synchronized (map) {
                Set currentControllerSet = (Set)_helixControllerFactory.get(controller._clusterName);
                if (currentControllerSet == null) {
                    _helixControllerFactory.put(controller._clusterName, (ImmutableSet<GenericHelixController>)ImmutableSet.of((Object)controller));
                } else {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    builder.addAll((Iterable)currentControllerSet);
                    builder.add((Object)controller);
                    _helixControllerFactory.put(controller._clusterName, (ImmutableSet<GenericHelixController>)builder.build());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeController(GenericHelixController controller) {
        if (controller != null && controller._clusterName != null) {
            Map<String, ImmutableSet<GenericHelixController>> map = _helixControllerFactory;
            synchronized (map) {
                Set currentControllerSet = (Set)_helixControllerFactory.get(controller._clusterName);
                if (currentControllerSet != null && currentControllerSet.contains(controller)) {
                    ImmutableSet.Builder builder = ImmutableSet.builder();
                    builder.addAll((Iterable)currentControllerSet.stream().filter(c -> c.hashCode() != controller.hashCode()).collect(Collectors.toSet()));
                    _helixControllerFactory.put(controller._clusterName, (ImmutableSet<GenericHelixController>)builder.build());
                }
            }
        }
    }

    public GenericHelixController() {
        this(GenericHelixController.createDefaultRegistry(Pipeline.Type.DEFAULT.name()), GenericHelixController.createTaskRegistry(Pipeline.Type.TASK.name()));
    }

    public GenericHelixController(String clusterName) {
        this(GenericHelixController.createDefaultRegistry(Pipeline.Type.DEFAULT.name()), GenericHelixController.createTaskRegistry(Pipeline.Type.TASK.name()), GenericHelixController.createManagementModeRegistry(Pipeline.Type.MANAGEMENT_MODE.name()), clusterName, Sets.newHashSet((Object[])new Pipeline.Type[]{Pipeline.Type.TASK, Pipeline.Type.DEFAULT}));
    }

    public GenericHelixController(String clusterName, Set<Pipeline.Type> enabledPipelins) {
        this(GenericHelixController.createDefaultRegistry(Pipeline.Type.DEFAULT.name()), GenericHelixController.createTaskRegistry(Pipeline.Type.TASK.name()), GenericHelixController.createManagementModeRegistry(Pipeline.Type.MANAGEMENT_MODE.name()), clusterName, enabledPipelins);
    }

    public void setInManagementMode(boolean enabled) {
        this._inManagementMode = enabled;
    }

    private void forceRebalance(HelixManager manager, ClusterEventType eventType) {
        NotificationContext changeContext = new NotificationContext(manager);
        changeContext.setType(NotificationContext.Type.CALLBACK);
        this.pushToEventQueues(eventType, changeContext, Collections.EMPTY_MAP);
        logger.info(String.format("Controller rebalance pipeline triggered with event type: %s for cluster %s", new Object[]{eventType, this._clusterName}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPeriodRebalance(long period, HelixManager manager) {
        if (period != this._timerPeriod) {
            ScheduledFuture lastScheduledFuture;
            logger.info("Controller starting periodical rebalance timer at period " + period);
            ScheduledExecutorService scheduledExecutorService = this._periodicalRebalanceExecutor;
            synchronized (scheduledExecutorService) {
                lastScheduledFuture = this._periodicRebalanceFutureTask;
                this._timerPeriod = period;
                this._periodicRebalanceFutureTask = this._periodicalRebalanceExecutor.scheduleAtFixedRate(new RebalanceTask(manager, ClusterEventType.PeriodicalRebalance), this._timerPeriod, this._timerPeriod, TimeUnit.MILLISECONDS);
            }
            if (lastScheduledFuture != null && !lastScheduledFuture.isCancelled()) {
                lastScheduledFuture.cancel(false);
            }
        } else {
            logger.info("Controller already has periodical rebalance timer at period " + this._timerPeriod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPeriodRebalance() {
        logger.info("Controller stopping periodical rebalance timer at period " + this._timerPeriod);
        ScheduledExecutorService scheduledExecutorService = this._periodicalRebalanceExecutor;
        synchronized (scheduledExecutorService) {
            if (this._periodicRebalanceFutureTask != null && !this._periodicRebalanceFutureTask.isCancelled()) {
                this._periodicRebalanceFutureTask.cancel(false);
                this._timerPeriod = Long.MAX_VALUE;
            }
        }
    }

    private void shutdownOnDemandTimer() {
        logger.info("GenericHelixController stopping onDemand timer");
        if (this._onDemandRebalanceTimer != null) {
            this._onDemandRebalanceTimer.cancel();
        }
    }

    @Deprecated
    public void scheduleRebalance(long rebalanceTime) {
        if (this._helixManager == null) {
            logger.warn("Failed to schedule a future pipeline run for cluster " + this._clusterName + " helix manager is null!");
            return;
        }
        long current = System.currentTimeMillis();
        long delay = rebalanceTime - current;
        if (rebalanceTime > current) {
            RebalanceTask preTask = this._nextRebalanceTask.get();
            if (preTask != null && preTask.getNextRebalanceTime() > current && preTask.getNextRebalanceTime() < rebalanceTime) {
                return;
            }
            RebalanceTask newTask = new RebalanceTask(this._helixManager, ClusterEventType.OnDemandRebalance, rebalanceTime);
            this._onDemandRebalanceTimer.schedule((TimerTask)newTask, delay);
            logger.info("Scheduled a future pipeline run for cluster " + this._helixManager.getClusterName() + " in delay " + delay);
            preTask = this._nextRebalanceTask.getAndSet(newTask);
            if (preTask != null) {
                preTask.cancel();
            }
        }
    }

    @Deprecated
    public void scheduleOnDemandRebalance(long delay) {
        this.scheduleOnDemandRebalance(delay, true);
    }

    public void scheduleOnDemandRebalance(long delay, boolean shouldRefreshCache) {
        RebalanceTask preTask;
        if (this._helixManager == null) {
            logger.error("Failed to schedule a future pipeline run for cluster {}. Helix manager is null!", (Object)this._clusterName);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long rebalanceTime = currentTime + delay;
        if (delay > 0L && (preTask = this._nextRebalanceTask.get()) != null && preTask.getNextRebalanceTime() > currentTime && preTask.getNextRebalanceTime() < rebalanceTime) {
            return;
        }
        RebalanceTask newTask = new RebalanceTask(this._helixManager, ClusterEventType.OnDemandRebalance, rebalanceTime, shouldRefreshCache);
        this._onDemandRebalanceTimer.schedule((TimerTask)newTask, delay);
        logger.info("Scheduled instant pipeline run for cluster {}.", (Object)this._helixManager.getClusterName());
        RebalanceTask preTask2 = this._nextRebalanceTask.getAndSet(newTask);
        if (preTask2 != null) {
            preTask2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineRegistry createDefaultRegistry(String pipelineName) {
        logger.info("createDefaultRegistry");
        Class<GenericHelixController> clazz = GenericHelixController.class;
        synchronized (GenericHelixController.class) {
            PipelineRegistry registry = new PipelineRegistry();
            Pipeline dataRefresh = new Pipeline(pipelineName);
            dataRefresh.addStage(new ReadClusterDataStage());
            Pipeline dataPreprocess = new Pipeline(pipelineName);
            dataPreprocess.addStage(new ResourceComputationStage());
            dataPreprocess.addStage(new ResourceValidationStage());
            dataPreprocess.addStage(new CurrentStateComputationStage());
            dataPreprocess.addStage(new CustomizedStateComputationStage());
            dataPreprocess.addStage(new TopStateHandoffReportStage());
            Pipeline rebalancePipeline = new Pipeline(pipelineName);
            rebalancePipeline.addStage(new BestPossibleStateCalcStage());
            rebalancePipeline.addStage(new MessageGenerationPhase());
            rebalancePipeline.addStage(new MessageSelectionStage());
            rebalancePipeline.addStage(new IntermediateStateCalcStage());
            rebalancePipeline.addStage(new MessageThrottleStage());
            rebalancePipeline.addStage(new MaintenanceRecoveryStage());
            rebalancePipeline.addStage(new ResourceMessageDispatchStage());
            rebalancePipeline.addStage(new PersistAssignmentStage());
            rebalancePipeline.addStage(new TargetExteralViewCalcStage());
            Pipeline externalViewPipeline = new Pipeline(pipelineName);
            externalViewPipeline.addStage(new ExternalViewComputeStage());
            Pipeline customizedViewPipeline = new Pipeline(pipelineName);
            customizedViewPipeline.addStage(new CustomizedViewAggregationStage());
            Pipeline liveInstancePipeline = new Pipeline(pipelineName);
            liveInstancePipeline.addStage(new CompatibilityCheckStage());
            Pipeline autoExitMaintenancePipeline = new Pipeline(pipelineName);
            autoExitMaintenancePipeline.addStage(new MaintenanceRecoveryStage());
            registry.register(ClusterEventType.IdealStateChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.CurrentStateChange, dataRefresh, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.InstanceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ResourceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ClusterConfigChange, dataRefresh, autoExitMaintenancePipeline, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.LiveInstanceChange, dataRefresh, autoExitMaintenancePipeline, liveInstancePipeline, dataPreprocess, externalViewPipeline, customizedViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.MessageChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.Resume, dataRefresh, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.PeriodicalRebalance, dataRefresh, autoExitMaintenancePipeline, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.OnDemandRebalance, dataRefresh, autoExitMaintenancePipeline, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.ControllerChange, dataRefresh, autoExitMaintenancePipeline, dataPreprocess, externalViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.CustomizedStateChange, dataRefresh, dataPreprocess, customizedViewPipeline, rebalancePipeline);
            registry.register(ClusterEventType.CustomizeStateConfigChange, dataRefresh, dataPreprocess, customizedViewPipeline, rebalancePipeline);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineRegistry createTaskRegistry(String pipelineName) {
        logger.info("createTaskRegistry");
        Class<GenericHelixController> clazz = GenericHelixController.class;
        synchronized (GenericHelixController.class) {
            PipelineRegistry registry = new PipelineRegistry();
            Pipeline dataRefresh = new Pipeline(pipelineName);
            dataRefresh.addStage(new ReadClusterDataStage());
            Pipeline dataPreprocess = new Pipeline(pipelineName);
            dataPreprocess.addStage(new ResourceComputationStage());
            dataPreprocess.addStage(new ResourceValidationStage());
            dataPreprocess.addStage(new CurrentStateComputationStage());
            Pipeline rebalancePipeline = new Pipeline(pipelineName);
            rebalancePipeline.addStage(new TaskSchedulingStage());
            rebalancePipeline.addStage(new TaskPersistDataStage());
            rebalancePipeline.addStage(new TaskGarbageCollectionStage());
            rebalancePipeline.addStage(new MessageGenerationPhase());
            rebalancePipeline.addStage(new TaskMessageDispatchStage());
            Pipeline liveInstancePipeline = new Pipeline(pipelineName);
            liveInstancePipeline.addStage(new CompatibilityCheckStage());
            registry.register(ClusterEventType.IdealStateChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.CurrentStateChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.TaskCurrentStateChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.InstanceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ResourceConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ClusterConfigChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.LiveInstanceChange, dataRefresh, liveInstancePipeline, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.MessageChange, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.Resume, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.PeriodicalRebalance, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.OnDemandRebalance, dataRefresh, dataPreprocess, rebalancePipeline);
            registry.register(ClusterEventType.ControllerChange, dataRefresh, dataPreprocess, rebalancePipeline);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PipelineRegistry createManagementModeRegistry(String pipelineName) {
        logger.info("Creating management mode registry");
        Class<GenericHelixController> clazz = GenericHelixController.class;
        synchronized (GenericHelixController.class) {
            Pipeline dataRefresh = new Pipeline(pipelineName);
            dataRefresh.addStage(new ReadClusterDataStage());
            Pipeline dataPreprocess = new Pipeline(pipelineName);
            dataPreprocess.addStage(new ResourceComputationStage());
            dataPreprocess.addStage(new CurrentStateComputationStage());
            Pipeline managementMode = new Pipeline(pipelineName);
            managementMode.addStage(new ManagementModeStage());
            managementMode.addStage(new ManagementMessageGenerationPhase());
            managementMode.addStage(new ManagementMessageDispatchStage());
            PipelineRegistry registry = new PipelineRegistry();
            Arrays.asList(ClusterEventType.ControllerChange, ClusterEventType.LiveInstanceChange, ClusterEventType.MessageChange, ClusterEventType.OnDemandRebalance, ClusterEventType.PeriodicalRebalance).forEach(type -> registry.register((ClusterEventType)((Object)type), dataRefresh, dataPreprocess, managementMode));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return registry;
        }
    }

    public GenericHelixController(PipelineRegistry registry, PipelineRegistry taskRegistry) {
        this(registry, taskRegistry, GenericHelixController.createManagementModeRegistry(Pipeline.Type.MANAGEMENT_MODE.name()), null, Sets.newHashSet((Object[])new Pipeline.Type[]{Pipeline.Type.TASK, Pipeline.Type.DEFAULT}));
    }

    private GenericHelixController(PipelineRegistry registry, PipelineRegistry taskRegistry, PipelineRegistry managementModeRegistry, String clusterName, Set<Pipeline.Type> enabledPipelineTypes) {
        this._enabledPipelineTypes = enabledPipelineTypes;
        this._registry = registry;
        this._taskRegistry = taskRegistry;
        this._managementModeRegistry = managementModeRegistry;
        this._lastSeenInstances = new AtomicReference();
        this._lastSeenSessions = new AtomicReference();
        this._lastSeenCustomizedStateTypesMapRef = new AtomicReference();
        this._clusterName = clusterName;
        this._lastPipelineEndTimestamp = -1L;
        this._clusterStatusMonitor = new ClusterStatusMonitor(this._clusterName);
        this._asyncTasksThreadPool = Executors.newScheduledThreadPool(10, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "HelixController-async_tasks-" + GenericHelixController.this._clusterName);
            }
        });
        this._asyncFIFOWorkerPool = new HashMap<AsyncWorkerType, DedupEventProcessor<String, Runnable>>();
        this.initializeAsyncFIFOWorkers();
        this._onDemandRebalanceTimer = new Timer("GenericHelixController_" + this._clusterName + "_onDemand_Timer", true);
        if (this._enabledPipelineTypes.contains((Object)Pipeline.Type.DEFAULT)) {
            logger.info("Initializing {} pipeline", (Object)Pipeline.Type.DEFAULT.name());
            this._resourceControlDataProvider = new ResourceControllerDataProvider(clusterName);
            this._eventQueue = new ClusterEventBlockingQueue();
            this._eventThread = new ClusterEventProcessor(this._resourceControlDataProvider, this._eventQueue, "default-" + clusterName);
            this.initPipeline(this._eventThread, this._resourceControlDataProvider);
            logger.info("Initialized {} pipeline", (Object)Pipeline.Type.DEFAULT.name());
        } else {
            this._eventQueue = null;
            this._resourceControlDataProvider = null;
            this._eventThread = null;
        }
        if (this._enabledPipelineTypes.contains((Object)Pipeline.Type.TASK)) {
            logger.info("Initializing {} pipeline", (Object)Pipeline.Type.TASK.name());
            this._workflowControlDataProvider = new WorkflowControllerDataProvider(clusterName);
            this._taskEventQueue = new ClusterEventBlockingQueue();
            this._taskEventThread = new ClusterEventProcessor(this._workflowControlDataProvider, this._taskEventQueue, "task-" + clusterName);
            this.initPipeline(this._taskEventThread, this._workflowControlDataProvider);
            logger.info("Initialized {} pipeline", (Object)Pipeline.Type.TASK.name());
        } else {
            this._workflowControlDataProvider = null;
            this._taskEventQueue = null;
            this._taskEventThread = null;
        }
        logger.info("Initializing {} pipeline", (Object)Pipeline.Type.MANAGEMENT_MODE.name());
        this._managementControllerDataProvider = new ManagementControllerDataProvider(clusterName, Pipeline.Type.MANAGEMENT_MODE.name());
        this._managementModeEventQueue = new ClusterEventBlockingQueue();
        this._managementModeEventThread = new ClusterEventProcessor(this._managementControllerDataProvider, this._managementModeEventQueue, Pipeline.Type.MANAGEMENT_MODE.name() + "-" + clusterName);
        this.initPipeline(this._managementModeEventThread, this._managementControllerDataProvider);
        logger.info("Initialized {} pipeline", (Object)Pipeline.Type.MANAGEMENT_MODE.name());
        GenericHelixController.addController(this);
    }

    private void initializeAsyncFIFOWorkers() {
        for (AsyncWorkerType type : AsyncWorkerType.values()) {
            DedupEventProcessor<String, Runnable> worker = new DedupEventProcessor<String, Runnable>(this._clusterName, type.name()){

                @Override
                protected void handleEvent(Runnable event) {
                    event.run();
                }
            };
            worker.start();
            this._asyncFIFOWorkerPool.put(type, worker);
            logger.info("Started async worker {}", (Object)worker.getName());
        }
    }

    private void shutdownAsyncFIFOWorkers() {
        for (DedupEventProcessor<String, Runnable> processor : this._asyncFIFOWorkerPool.values()) {
            processor.shutdown();
            logger.info("Shutdown async worker {}", (Object)processor.getName());
        }
    }

    private boolean isEventQueueEmpty(boolean taskQueue) {
        if (taskQueue) {
            return this._taskEventQueue == null || this._taskEventQueue.isEmpty();
        }
        return this._eventQueue == null || this._eventQueue.isEmpty();
    }

    private void handleEvent(ClusterEvent event, BaseControllerDataProvider dataProvider) {
        List<Pipeline> pipelines;
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            logger.error("No cluster manager in event:" + (Object)((Object)event.getEventType()));
            return;
        }
        event.addAttribute(AttributeName.STATEFUL_REBALANCER.name(), this._rebalancerRef.getRebalancer(manager));
        Optional eventSessionId = Optional.empty();
        if (!event.containsAttribute(AttributeName.EVENT_SESSION.name())) {
            logger.info("Event {} does not have event session attribute", (Object)event.getEventId());
        } else {
            eventSessionId = (Optional)event.getAttribute(AttributeName.EVENT_SESSION.name());
            String managerSessionId = manager.getSessionId();
            if (!eventSessionId.isPresent() || !((String)eventSessionId.get()).equals(managerSessionId)) {
                logger.warn("Controller pipeline is not invoked because event session doesn't match cluster manager session. Event type: {}, id: {}, session: {}, actual manager session: {}, instance: {}, cluster: {}", new Object[]{event.getEventType(), event.getEventId(), eventSessionId.orElse("NOT_PRESENT"), managerSessionId, manager.getInstanceName(), manager.getClusterName()});
                return;
            }
        }
        this._helixManager = manager;
        boolean isTaskFrameworkPipeline = false;
        boolean isManagementPipeline = false;
        if (dataProvider instanceof ResourceControllerDataProvider) {
            pipelines = this._registry.getPipelinesForEvent(event.getEventType());
        } else if (dataProvider instanceof WorkflowControllerDataProvider) {
            pipelines = this._taskRegistry.getPipelinesForEvent(event.getEventType());
            isTaskFrameworkPipeline = true;
        } else if (dataProvider instanceof ManagementControllerDataProvider) {
            pipelines = this._managementModeRegistry.getPipelinesForEvent(event.getEventType());
            isManagementPipeline = true;
        } else {
            logger.warn(String.format("No %s pipeline to run for event: %s::%s", new Object[]{dataProvider.getPipelineName(), event.getEventType(), event.getEventId()}));
            return;
        }
        if (this._inManagementMode != isManagementPipeline) {
            logger.info("Should not run management mode and default/task pipelines at the same time. cluster={}, inManagementMode={}, isManagementPipeline={}. Ignoring the event: {}", new Object[]{manager.getClusterName(), this._inManagementMode, isManagementPipeline, event.getEventType()});
            return;
        }
        NotificationContext context = null;
        if (event.getAttribute(AttributeName.changeContext.name()) != null) {
            context = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
        }
        if (context != null) {
            if (context.getType() == NotificationContext.Type.FINALIZE) {
                this.stopPeriodRebalance();
                logger.info("Get FINALIZE notification, skip the pipeline. Event :" + (Object)((Object)event.getEventType()));
                return;
            }
            if (this._resourceControlDataProvider != null) {
                this.checkRebalancingTimer(manager, Collections.emptyList(), dataProvider.getClusterConfig());
            }
            if (this._isMonitoring) {
                this._clusterStatusMonitor.setEnabled(!this._inManagementMode);
                this._clusterStatusMonitor.setPaused(this._inManagementMode);
                event.addAttribute(AttributeName.clusterStatusMonitor.name(), this._clusterStatusMonitor);
            }
        }
        dataProvider.setClusterEventId(event.getEventId());
        event.addAttribute(AttributeName.LastRebalanceFinishTimeStamp.name(), this._lastPipelineEndTimestamp);
        event.addAttribute(AttributeName.ControllerDataProvider.name(), dataProvider);
        logger.info("START: Invoking {} controller pipeline for cluster: {}. Event type: {}, ID: {}. Event session ID: {}", new Object[]{dataProvider.getPipelineName(), manager.getClusterName(), event.getEventType(), event.getEventId(), eventSessionId.orElse("NOT_PRESENT")});
        long startTime = System.currentTimeMillis();
        boolean helixMetaDataAccessRebalanceFail = false;
        boolean rebalanceFail = false;
        for (Pipeline pipeline : pipelines) {
            event.addAttribute(AttributeName.PipelineType.name(), pipeline.getPipelineType());
            try {
                pipeline.handle(event);
                pipeline.finish();
            }
            catch (Exception e) {
                logger.error("Exception while executing {} pipeline for cluster {}. Will not continue to next pipeline", new Object[]{dataProvider.getPipelineName(), this._clusterName, e});
                if (e instanceof HelixMetaDataAccessException) {
                    helixMetaDataAccessRebalanceFail = true;
                    dataProvider.requireFullRefresh();
                    logger.warn("Rebalance pipeline failed due to read failure from zookeeper, cluster: " + this._clusterName);
                    if (this.isEventQueueEmpty(isTaskFrameworkPipeline)) {
                        ++this._continuousRebalanceFailureCount;
                        long delay = this.getRetryDelay(this._continuousRebalanceFailureCount);
                        if (delay == 0L) {
                            this.forceRebalance(manager, ClusterEventType.RetryRebalance);
                        } else {
                            this._asyncTasksThreadPool.schedule(new RebalanceTask(manager, ClusterEventType.RetryRebalance), delay, TimeUnit.MILLISECONDS);
                        }
                        logger.info("Retry rebalance pipeline with delay " + delay + "ms for cluster: " + this._clusterName);
                    }
                }
                this._clusterStatusMonitor.reportRebalanceFailure();
                this.updateContinuousRebalancedFailureCount(isTaskFrameworkPipeline, false);
                rebalanceFail = true;
                break;
            }
        }
        if (!helixMetaDataAccessRebalanceFail) {
            this._continuousRebalanceFailureCount = 0L;
        }
        if (!rebalanceFail) {
            this.updateContinuousRebalancedFailureCount(isTaskFrameworkPipeline, true);
        }
        this._lastPipelineEndTimestamp = System.currentTimeMillis();
        logger.info("END: Invoking {} controller pipeline for event {}::{} for cluster {}, took {} ms", new Object[]{dataProvider.getPipelineName(), event.getEventType(), event.getEventId(), this._clusterName, this._lastPipelineEndTimestamp - startTime});
        if (!isTaskFrameworkPipeline) {
            NotificationContext notificationContext = (NotificationContext)event.getAttribute(AttributeName.changeContext.name());
            long enqueueTime = event.getCreationTime();
            StringBuilder sb = new StringBuilder();
            if (notificationContext != null) {
                long zkCallbackTime = notificationContext.getCreationTime();
                if (this._isMonitoring) {
                    this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.Callback.name(), enqueueTime - zkCallbackTime);
                }
                sb.append(String.format("Callback time for event: %s took: %s ms\n", new Object[]{event.getEventType(), enqueueTime - zkCallbackTime}));
            }
            if (this._isMonitoring) {
                this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.InQueue.name(), startTime - enqueueTime);
                this._clusterStatusMonitor.updateClusterEventDuration(ClusterEventMonitor.PhaseName.TotalProcessed.name(), this._lastPipelineEndTimestamp - startTime);
            }
            sb.append(String.format("InQueue time for event: %s took: %s ms\n", new Object[]{event.getEventType(), startTime - enqueueTime}));
            sb.append(String.format("TotalProcessed time for event: %s took: %s ms", new Object[]{event.getEventType(), this._lastPipelineEndTimestamp - startTime}));
            logger.info(sb.toString());
        }
        this.resetClusterStatusMonitor();
    }

    private void updateContinuousRebalancedFailureCount(boolean isTaskFrameworkPipeline, boolean resetToZero) {
        if (isTaskFrameworkPipeline) {
            this._continuousTaskRebalanceFailureCount = resetToZero ? 0L : this._continuousTaskRebalanceFailureCount + 1L;
            this._clusterStatusMonitor.reportContinuousTaskRebalanceFailureCount(this._continuousTaskRebalanceFailureCount);
        } else {
            this._continuousResourceRebalanceFailureCount = resetToZero ? 0L : this._continuousResourceRebalanceFailureCount + 1L;
            this._clusterStatusMonitor.reportContinuousResourceRebalanceFailureCount(this._continuousResourceRebalanceFailureCount);
        }
    }

    private long getRetryDelay(long failCount) {
        int lowLimit = 5;
        if (failCount <= (long)lowLimit) {
            return 0L;
        }
        long backoff = (long)(Math.pow(2.0, failCount - (long)lowLimit) * 10.0);
        return Math.min(backoff, 1000L);
    }

    @Override
    @PreFetch(enabled=false)
    public void onStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onStateChange()");
        this.notifyCaches(changeContext, HelixConstants.ChangeType.CURRENT_STATE);
        this.pushToEventQueues(ClusterEventType.CurrentStateChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        logger.info("END: GenericClusterController.onStateChange()");
    }

    @Override
    @PreFetch(enabled=false)
    public void onTaskCurrentStateChange(String instanceName, List<CurrentState> statesInfo, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onTaskCurrentStateChange()");
        this.notifyCaches(changeContext, HelixConstants.ChangeType.TASK_CURRENT_STATE);
        this.pushToEventQueues(ClusterEventType.TaskCurrentStateChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        logger.info("END: GenericClusterController.onTaskCurrentStateChange()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreFetch(enabled=false)
    public void onCustomizedStateRootChange(String instanceName, List<String> customizedStateTypes, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onCustomizedStateRootChange()");
        HelixManager manager = changeContext.getManager();
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
        if (customizedStateTypes.isEmpty()) {
            customizedStateTypes = manager.getHelixDataAccessor().getChildNames(keyBuilder.customizedStatesRoot(instanceName));
        }
        AtomicReference<Map<String, Set<String>>> atomicReference = this._lastSeenCustomizedStateTypesMapRef;
        synchronized (atomicReference) {
            Map<String, Set<String>> lastSeenCustomizedStateTypesMap = this._lastSeenCustomizedStateTypesMapRef.get();
            if (null == lastSeenCustomizedStateTypesMap) {
                lastSeenCustomizedStateTypesMap = new HashMap<String, Set<String>>();
                this._lastSeenCustomizedStateTypesMapRef.set(lastSeenCustomizedStateTypesMap);
            }
            if (!lastSeenCustomizedStateTypesMap.containsKey(instanceName)) {
                lastSeenCustomizedStateTypesMap.put(instanceName, new HashSet());
            }
            Set<String> lastSeenCustomizedStateTypes = lastSeenCustomizedStateTypesMap.get(instanceName);
            for (String customizedState : customizedStateTypes) {
                try {
                    if (lastSeenCustomizedStateTypes.contains(customizedState)) continue;
                    manager.addCustomizedStateChangeListener(this, instanceName, customizedState);
                    logger.info(manager.getInstanceName() + " added customized state listener for " + instanceName + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add customized state listener for instance: " + instanceName, (Throwable)e);
                }
            }
            for (String previousCustomizedState : lastSeenCustomizedStateTypes) {
                if (customizedStateTypes.contains(previousCustomizedState)) continue;
                manager.removeListener(keyBuilder.customizedStates(instanceName, previousCustomizedState), this);
            }
            lastSeenCustomizedStateTypes.clear();
            lastSeenCustomizedStateTypes.addAll(customizedStateTypes);
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onCustomizedStateChange(String instanceName, List<CustomizedState> statesInfo, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onCustomizedStateChange()");
        this.notifyCaches(changeContext, HelixConstants.ChangeType.CUSTOMIZED_STATE);
        this.pushToEventQueues(ClusterEventType.CustomizedStateChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        logger.info("END: GenericClusterController.onCustomizedStateChange()");
    }

    @Override
    @PreFetch(enabled=false)
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onMessage() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.MESSAGE);
        this.pushToEventQueues(ClusterEventType.MessageChange, changeContext, Collections.singletonMap(AttributeName.instanceName.name(), instanceName));
        logger.info("END: GenericClusterController.onMessage() for cluster " + this._clusterName);
    }

    @Override
    public void onLiveInstanceChange(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        logger.info("START: Generic GenericClusterController.onLiveInstanceChange() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.LIVE_INSTANCE);
        if (liveInstances == null) {
            liveInstances = Collections.emptyList();
        }
        if (changeContext.getType() == NotificationContext.Type.INIT || changeContext.getType() == NotificationContext.Type.CALLBACK) {
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        } else if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("remove message/current-state listeners. lastSeenInstances: " + this._lastSeenInstances + ", lastSeenSessions: " + this._lastSeenSessions);
            liveInstances = Collections.emptyList();
            this.checkLiveInstancesObservation(liveInstances, changeContext);
        }
        this.pushToEventQueues(ClusterEventType.LiveInstanceChange, changeContext, Collections.singletonMap(AttributeName.eventData.name(), liveInstances));
        logger.info("END: Generic GenericClusterController.onLiveInstanceChange() for cluster " + this._clusterName);
    }

    private void checkRebalancingTimer(HelixManager manager, List<IdealState> idealStates, ClusterConfig clusterConfig) {
        long period;
        if (manager.getConfigAccessor() == null) {
            logger.warn(manager.getInstanceName() + " config accessor doesn't exist. should be in file-based mode.");
            return;
        }
        long minPeriod = Long.MAX_VALUE;
        if (clusterConfig != null && (period = clusterConfig.getRebalanceTimePeriod()) > 0L && minPeriod > period) {
            minPeriod = period;
        }
        for (IdealState idealState : idealStates) {
            long period2 = idealState.getRebalanceTimerPeriod();
            if (period2 <= 0L || minPeriod <= period2) continue;
            minPeriod = period2;
        }
        if (minPeriod != Long.MAX_VALUE) {
            this.startPeriodRebalance(minPeriod, manager);
        } else {
            this.stopPeriodRebalance();
        }
    }

    @Override
    @PreFetch(enabled=false)
    public void onIdealStateChange(List<IdealState> idealStates, NotificationContext changeContext) {
        HelixManager manager;
        logger.info("START: Generic GenericClusterController.onIdealStateChange() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.IDEAL_STATE);
        this.pushToEventQueues(ClusterEventType.IdealStateChange, changeContext, Collections.emptyMap());
        if (changeContext.getType() != NotificationContext.Type.FINALIZE && (manager = changeContext.getManager()) != null) {
            HelixDataAccessor dataAccessor = changeContext.getManager().getHelixDataAccessor();
            this.checkRebalancingTimer(changeContext.getManager(), idealStates, (ClusterConfig)dataAccessor.getProperty(dataAccessor.keyBuilder().clusterConfig()));
        }
        logger.info("END: GenericClusterController.onIdealStateChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onInstanceConfigChange(List<InstanceConfig> instanceConfigs, NotificationContext changeContext) {
        logger.info("START: GenericClusterController.onInstanceConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(changeContext, HelixConstants.ChangeType.INSTANCE_CONFIG);
        this.pushToEventQueues(ClusterEventType.InstanceConfigChange, changeContext, Collections.emptyMap());
        logger.info("END: GenericClusterController.onInstanceConfigChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onResourceConfigChange(List<ResourceConfig> resourceConfigs, NotificationContext context) {
        logger.info("START: GenericClusterController.onResourceConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(context, HelixConstants.ChangeType.RESOURCE_CONFIG);
        this.pushToEventQueues(ClusterEventType.ResourceConfigChange, context, Collections.emptyMap());
        logger.info("END: GenericClusterController.onResourceConfigChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onCustomizedStateConfigChange(CustomizedStateConfig customizedStateConfig, NotificationContext context) {
        logger.info("START: GenericClusterController.onCustomizedStateConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(context, HelixConstants.ChangeType.CUSTOMIZED_STATE_CONFIG);
        this.pushToEventQueues(ClusterEventType.CustomizeStateConfigChange, context, Collections.emptyMap());
        logger.info("END: GenericClusterController.onCustomizedStateConfigChange() for cluster " + this._clusterName);
    }

    @Override
    @PreFetch(enabled=false)
    public void onClusterConfigChange(ClusterConfig clusterConfig, NotificationContext context) {
        logger.info("START: GenericClusterController.onClusterConfigChange() for cluster " + this._clusterName);
        this.notifyCaches(context, HelixConstants.ChangeType.CLUSTER_CONFIG);
        this.pushToEventQueues(ClusterEventType.ClusterConfigChange, context, Collections.emptyMap());
        logger.info("END: GenericClusterController.onClusterConfigChange() for cluster " + this._clusterName);
    }

    private void notifyCaches(NotificationContext context, HelixConstants.ChangeType changeType) {
        if (context == null || context.getType() != NotificationContext.Type.CALLBACK) {
            this.requestDataProvidersFullRefresh();
        } else {
            this.updateDataChangeInProvider(changeType, context.getPathChanged());
        }
    }

    private void updateDataChangeInProvider(HelixConstants.ChangeType type, String path) {
        if (this._resourceControlDataProvider != null) {
            this._resourceControlDataProvider.notifyDataChange(type, path);
        }
        if (this._workflowControlDataProvider != null) {
            this._workflowControlDataProvider.notifyDataChange(type, path);
        }
        if (this._managementControllerDataProvider != null) {
            this._managementControllerDataProvider.notifyDataChange(type, path);
        }
    }

    private void requestDataProvidersFullRefresh() {
        if (this._resourceControlDataProvider != null) {
            this._resourceControlDataProvider.requireFullRefresh();
        }
        if (this._workflowControlDataProvider != null) {
            this._workflowControlDataProvider.requireFullRefresh();
        }
        if (this._managementControllerDataProvider != null) {
            this._managementControllerDataProvider.requireFullRefresh();
        }
    }

    private void pushToEventQueues(ClusterEventType eventType, NotificationContext changeContext, Map<String, Object> eventAttributes) {
        String uid = UUID.randomUUID().toString().substring(0, 8);
        ClusterEvent event = new ClusterEvent(this._clusterName, eventType, String.format("%s_%s", uid, Pipeline.Type.DEFAULT.name()));
        event.addAttribute(AttributeName.EVENT_SESSION.name(), changeContext.getManager().getSessionIdIfLead());
        event.addAttribute(AttributeName.helixmanager.name(), changeContext.getManager());
        event.addAttribute(AttributeName.changeContext.name(), changeContext);
        event.addAttribute(AttributeName.AsyncFIFOWorkerPool.name(), this._asyncFIFOWorkerPool);
        for (Map.Entry<String, Object> attr : eventAttributes.entrySet()) {
            event.addAttribute(attr.getKey(), attr.getValue());
        }
        if (this._inManagementMode) {
            event.setEventId(uid + "_" + Pipeline.Type.MANAGEMENT_MODE.name());
            this.enqueueEvent(this._managementModeEventQueue, event);
            return;
        }
        this.enqueueEvent(this._eventQueue, event);
        this.enqueueEvent(this._taskEventQueue, event.clone(String.format("%s_%s", uid, Pipeline.Type.TASK.name())));
    }

    private void enqueueEvent(ClusterEventBlockingQueue queue, ClusterEvent event) {
        if (event == null || queue == null) {
            return;
        }
        queue.put(event);
    }

    @Override
    public void onControllerChange(NotificationContext changeContext) {
        boolean controllerIsLeader;
        logger.info("START: GenericClusterController.onControllerChange() for cluster " + this._clusterName);
        this.requestDataProvidersFullRefresh();
        if (changeContext == null || changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info("GenericClusterController.onControllerChange() Cluster change type {} for cluster {}. Disable leadership.", (Object)(changeContext == null ? null : changeContext.getType()), (Object)this._clusterName);
            controllerIsLeader = false;
        } else {
            controllerIsLeader = changeContext.getManager().isLeader();
        }
        if (controllerIsLeader) {
            this.enableClusterStatusMonitor(true);
            this.pushToEventQueues(ClusterEventType.ControllerChange, changeContext, Collections.emptyMap());
        } else {
            this.enableClusterStatusMonitor(false);
            this._rebalancerRef.invalidateRebalancer();
        }
        logger.info("END: GenericClusterController.onControllerChange() for cluster " + this._clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLiveInstancesObservation(List<LiveInstance> liveInstances, NotificationContext changeContext) {
        HashMap<String, LiveInstance> curInstances = new HashMap<String, LiveInstance>();
        HashMap<String, LiveInstance> curSessions = new HashMap<String, LiveInstance>();
        for (LiveInstance liveInstance : liveInstances) {
            curInstances.put(liveInstance.getInstanceName(), liveInstance);
            curSessions.put(liveInstance.getEphemeralOwner(), liveInstance);
        }
        AtomicReference<Map<String, LiveInstance>> atomicReference = this._lastSeenInstances;
        synchronized (atomicReference) {
            String instanceName;
            Map<String, LiveInstance> lastInstances = this._lastSeenInstances.get();
            Map<String, LiveInstance> lastSessions = this._lastSeenSessions.get();
            HelixManager manager = changeContext.getManager();
            PropertyKey.Builder keyBuilder = new PropertyKey.Builder(manager.getClusterName());
            if (lastSessions != null) {
                for (String session : lastSessions.keySet()) {
                    if (curSessions.containsKey(session)) continue;
                    instanceName = lastSessions.get(session).getInstanceName();
                    manager.removeListener(keyBuilder.currentStates(instanceName, session), this);
                    manager.removeListener(keyBuilder.taskCurrentStates(instanceName, session), this);
                }
            }
            if (lastInstances != null) {
                for (String instance : lastInstances.keySet()) {
                    if (curInstances.containsKey(instance)) continue;
                    manager.removeListener(keyBuilder.messages(instance), this);
                    manager.removeListener(keyBuilder.customizedStatesRoot(instance), this);
                }
            }
            for (String session : curSessions.keySet()) {
                if (lastSessions != null && lastSessions.containsKey(session)) continue;
                instanceName = ((LiveInstance)curSessions.get(session)).getInstanceName();
                try {
                    manager.addCurrentStateChangeListener(this, instanceName, session);
                    manager.addTaskCurrentStateChangeListener(this, instanceName, session);
                    logger.info(manager.getInstanceName() + " added current-state listener for instance: " + instanceName + ", session: " + session + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add current state listener for instance: " + instanceName + " with session: " + session, (Throwable)e);
                }
            }
            for (String instance : curInstances.keySet()) {
                if (lastInstances != null && lastInstances.containsKey(instance)) continue;
                try {
                    manager.addMessageListener(this, instance);
                    logger.info(manager.getInstanceName() + " added message listener for " + instance + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add message listener for instance: " + instance, (Throwable)e);
                }
            }
            for (String instance : curInstances.keySet()) {
                if (lastInstances != null && lastInstances.containsKey(instance)) continue;
                try {
                    manager.addCustomizedStateRootChangeListener(this, instance);
                    logger.info(manager.getInstanceName() + " added root path listener for customized " + "state change for " + instance + ", listener: " + this);
                }
                catch (Exception e) {
                    logger.error("Fail to add root path listener for customized state change for instance: " + instance, (Throwable)e);
                }
            }
            this._lastSeenInstances.set(curInstances);
            this._lastSeenSessions.set(curSessions);
        }
    }

    public void shutdown() throws InterruptedException {
        GenericHelixController.removeController(this);
        this.stopPeriodRebalance();
        this._periodicalRebalanceExecutor.shutdown();
        if (!this._periodicalRebalanceExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
            this._periodicalRebalanceExecutor.shutdownNow();
        }
        this.shutdownOnDemandTimer();
        logger.info("Shutting down {} pipeline", (Object)Pipeline.Type.DEFAULT.name());
        this.shutdownPipeline(this._eventThread, this._eventQueue);
        logger.info("Shutting down {} pipeline", (Object)Pipeline.Type.TASK.name());
        this.shutdownPipeline(this._taskEventThread, this._taskEventQueue);
        this._asyncTasksThreadPool.shutdownNow();
        try {
            this._asyncTasksThreadPool.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            logger.warn("Timeout when terminating async tasks. Some async tasks are still executing.");
        }
        this.shutdownAsyncFIFOWorkers();
        this.enableClusterStatusMonitor(false);
        this._rebalancerRef.closeRebalancer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableClusterStatusMonitor(boolean enable) {
        ClusterStatusMonitor clusterStatusMonitor = this._clusterStatusMonitor;
        synchronized (clusterStatusMonitor) {
            if (this._isMonitoring != enable) {
                if (enable) {
                    logger.info("Enable clusterStatusMonitor for cluster " + this._clusterName);
                    if (this._resourceControlDataProvider != null) {
                        this._resourceControlDataProvider.clearMonitoringRecords();
                    }
                    this._clusterStatusMonitor.active();
                } else {
                    logger.info("Disable clusterStatusMonitor for cluster " + this._clusterName);
                }
                this._isMonitoring = enable;
            }
            this.resetClusterStatusMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetClusterStatusMonitor() {
        ClusterStatusMonitor clusterStatusMonitor = this._clusterStatusMonitor;
        synchronized (clusterStatusMonitor) {
            if (!this._isMonitoring) {
                this._clusterStatusMonitor.reset();
            }
        }
    }

    private void shutdownPipeline(Thread thread, ClusterEventBlockingQueue queue) throws InterruptedException {
        if (queue != null) {
            queue.clear();
        }
        if (thread != null) {
            while (thread.isAlive()) {
                thread.interrupt();
                thread.join(1000L);
            }
        }
    }

    private void initPipeline(Thread eventThread, BaseControllerDataProvider cache) {
        if (eventThread == null || cache == null) {
            logger.warn("pipeline cannot be initialized");
            return;
        }
        cache.setAsyncTasksThreadPool(this._asyncTasksThreadPool);
        eventThread.setDaemon(true);
        eventThread.start();
    }

    private abstract class StatefulRebalancerRef<T extends StatefulRebalancer> {
        private T _rebalancer = null;
        private boolean _isRebalancerValid = true;

        private StatefulRebalancerRef() {
        }

        protected abstract T createRebalancer(HelixManager var1);

        synchronized void invalidateRebalancer() {
            this._isRebalancerValid = false;
        }

        synchronized T getRebalancer(HelixManager helixManager) {
            if (this._rebalancer == null) {
                this._rebalancer = this.createRebalancer(helixManager);
                this._isRebalancerValid = true;
            }
            if (!this._isRebalancerValid) {
                this._rebalancer.reset();
                this._isRebalancerValid = true;
            }
            return this._rebalancer;
        }

        synchronized void closeRebalancer() {
            if (this._rebalancer != null) {
                this._rebalancer.close();
                this._rebalancer = null;
            }
        }
    }

    @Deprecated
    private class ClusterEventProcessor
    extends Thread {
        private final BaseControllerDataProvider _cache;
        private final ClusterEventBlockingQueue _eventBlockingQueue;
        private final String _processorName;

        ClusterEventProcessor(BaseControllerDataProvider cache, ClusterEventBlockingQueue eventBlockingQueue, String processorName) {
            this._cache = cache;
            this._eventBlockingQueue = eventBlockingQueue;
            this._processorName = processorName;
        }

        @Override
        public void run() {
            logger.info("START ClusterEventProcessor thread  for cluster " + GenericHelixController.this._clusterName + ", processor name: " + this._processorName);
            while (!this.isInterrupted()) {
                try {
                    ClusterEvent newClusterEvent = this._eventBlockingQueue.take();
                    String threadName = String.format("HelixController-pipeline-%s-(%s)", this._processorName, newClusterEvent.getEventId());
                    this.setName(threadName);
                    GenericHelixController.this.handleEvent(newClusterEvent, this._cache);
                }
                catch (InterruptedException e) {
                    logger.warn("ClusterEventProcessor interrupted " + this._processorName, (Throwable)e);
                    this.interrupt();
                }
                catch (ZkInterruptedException e) {
                    logger.warn("ClusterEventProcessor caught a ZK connection interrupt " + this._processorName, (Throwable)e);
                    this.interrupt();
                }
                catch (ThreadDeath death) {
                    logger.error("ClusterEventProcessor caught a ThreadDeath  " + this._processorName, (Throwable)death);
                    throw death;
                }
                catch (Throwable t) {
                    logger.error("ClusterEventProcessor failed while running the controller pipeline " + this._processorName, t);
                }
            }
            logger.info("END ClusterEventProcessor thread " + this._processorName);
        }
    }

    class RebalanceTask
    extends TimerTask {
        final HelixManager _manager;
        final ClusterEventType _clusterEventType;
        private final Optional<Boolean> _shouldRefreshCacheOption;
        private long _nextRebalanceTime;

        public RebalanceTask(HelixManager manager, ClusterEventType clusterEventType) {
            this(manager, clusterEventType, -1L);
        }

        public RebalanceTask(HelixManager manager, ClusterEventType clusterEventType, long nextRebalanceTime) {
            this(manager, clusterEventType, nextRebalanceTime, Optional.empty());
        }

        public RebalanceTask(HelixManager manager, ClusterEventType clusterEventType, long nextRebalanceTime, boolean shouldRefreshCache) {
            this(manager, clusterEventType, nextRebalanceTime, Optional.of(shouldRefreshCache));
        }

        private RebalanceTask(HelixManager manager, ClusterEventType clusterEventType, long nextRebalanceTime, Optional<Boolean> shouldRefreshCacheOption) {
            this._manager = manager;
            this._clusterEventType = clusterEventType;
            this._nextRebalanceTime = nextRebalanceTime;
            this._shouldRefreshCacheOption = shouldRefreshCacheOption;
        }

        public long getNextRebalanceTime() {
            return this._nextRebalanceTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this._shouldRefreshCacheOption.orElse(this._clusterEventType.equals((Object)ClusterEventType.PeriodicalRebalance) || this._clusterEventType.equals((Object)ClusterEventType.OnDemandRebalance)).booleanValue()) {
                    GenericHelixController.this.requestDataProvidersFullRefresh();
                    HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                    PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                    List<LiveInstance> liveInstances = accessor.getChildValues(keyBuilder.liveInstances(), true);
                    if (liveInstances != null && !liveInstances.isEmpty()) {
                        NotificationContext changeContext = new NotificationContext(this._manager);
                        changeContext.setType(NotificationContext.Type.CALLBACK);
                        HelixManager helixManager = this._manager;
                        synchronized (helixManager) {
                            GenericHelixController.this.checkLiveInstancesObservation(liveInstances, changeContext);
                        }
                    }
                }
                GenericHelixController.this.forceRebalance(this._manager, this._clusterEventType);
            }
            catch (Throwable ex) {
                logger.error("Time task failed. Rebalance task type: " + (Object)((Object)this._clusterEventType) + ", cluster: " + GenericHelixController.this._clusterName, ex);
            }
        }
    }
}

