/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jetty;

import java.io.IOException;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Scheduler;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.ssl.SslUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.ext.jetty.internal.JettyClientCall;
import org.restlet.ext.jetty.internal.RestletSslContextFactory;

public class HttpClientHelper
extends org.restlet.engine.adapter.HttpClientHelper {
    private volatile HttpClient httpClient;

    public HttpClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.HTTP);
        this.getProtocols().add(Protocol.HTTPS);
    }

    public ClientCall create(Request request) {
        JettyClientCall result = null;
        try {
            result = new JettyClientCall(this, request.getMethod().toString(), ReferenceUtils.update((Reference)request.getResourceRef(), (Request)request).toString());
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty HTTP/HTTPS client call", e);
        }
        return result;
    }

    private HttpClient createHttpClient() {
        RestletSslContextFactory sslContextFactory = null;
        try {
            sslContextFactory = new RestletSslContextFactory(SslUtils.getSslContextFactory((RestletHelper)this));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to create the SSL context factory.", e);
        }
        HttpClient httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        httpClient.setAddressResolutionTimeout(this.getAddressResolutionTimeout());
        httpClient.setBindAddress(this.getBindAddress());
        httpClient.setConnectTimeout(this.getConnectTimeout());
        CookieStore cookieStore = this.getCookieStore();
        if (cookieStore != null) {
            httpClient.setCookieStore(cookieStore);
        }
        httpClient.setDispatchIO(this.isDispatchIO());
        httpClient.setExecutor(this.getExecutor());
        httpClient.setFollowRedirects(this.isFollowRedirects());
        httpClient.setIdleTimeout(this.getIdleTimeout());
        httpClient.setMaxConnectionsPerDestination(this.getMaxConnectionsPerDestination());
        httpClient.setMaxRedirects(this.getMaxRedirects());
        httpClient.setMaxRequestsQueuedPerDestination(this.getMaxRequestsQueuedPerDestination());
        httpClient.setRequestBufferSize(this.getRequestBufferSize());
        httpClient.setResponseBufferSize(this.getResponseBufferSize());
        httpClient.setScheduler(this.getScheduler());
        httpClient.setStopTimeout(this.getStopTimeout());
        httpClient.setStrictEventOrdering(this.isStrictEventOrdering());
        httpClient.setTCPNoDelay(this.isTcpNoDelay());
        String userAgentField = this.getUserAgentField();
        if (userAgentField != null) {
            httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, userAgentField));
        }
        return httpClient;
    }

    public long getAddressResolutionTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("addressResolutionTimeout", "15000"));
    }

    public SocketAddress getBindAddress() {
        String bindAddress = this.getHelpedParameters().getFirstValue("bindAddress", null);
        String bindPort = this.getHelpedParameters().getFirstValue("bindPort", null);
        if (bindAddress != null && bindPort != null) {
            return new InetSocketAddress(bindAddress, Integer.parseInt(bindPort));
        }
        return null;
    }

    public long getConnectTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("connectTimeout", "15000"));
    }

    public CookieStore getCookieStore() {
        return null;
    }

    public Executor getExecutor() {
        return null;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public long getIdleTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("idleTimeout", "60000"));
    }

    public int getMaxConnectionsPerDestination() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxConnectionsPerDestination", "10"));
    }

    public int getMaxRedirects() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxRedirects", "8"));
    }

    public int getMaxRequestsQueuedPerDestination() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("maxRequestsQueuedPerDestination", "1024"));
    }

    public int getRequestBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("requestBufferSize", "4096"));
    }

    public int getResponseBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("responseBufferSize", "16384"));
    }

    public Scheduler getScheduler() {
        return null;
    }

    public long getStopTimeout() {
        return Long.parseLong(this.getHelpedParameters().getFirstValue("stopTimeout", "60000"));
    }

    public String getUserAgentField() {
        return this.getHelpedParameters().getFirstValue("userAgentField", null);
    }

    public boolean isDispatchIO() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("dispatchIo", "true"));
    }

    public boolean isFollowRedirects() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("followRedirects", "true"));
    }

    public boolean isStrictEventOrdering() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("strictEventOrdering", "false"));
    }

    public boolean isTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "true"));
    }

    public void start() throws Exception {
        HttpClient httpClient;
        super.start();
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient();
        }
        if ((httpClient = this.getHttpClient()) != null) {
            this.getLogger().info("Starting a Jetty HTTP/HTTPS client");
            httpClient.start();
        }
    }

    public void stop() throws Exception {
        HttpClient httpClient = this.getHttpClient();
        if (httpClient != null) {
            this.getLogger().info("Stopping a Jetty HTTP/HTTPS client");
            httpClient.stop();
        }
        super.stop();
    }
}

