/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixRebalanceException;
import org.apache.helix.controller.changedetector.ResourceChangeDetector;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.DelayedAutoRebalancer;
import org.apache.helix.controller.rebalancer.StatefulRebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.DelayedRebalanceUtil;
import org.apache.helix.controller.rebalancer.util.WagedValidationUtil;
import org.apache.helix.controller.rebalancer.waged.AssignmentMetadataStore;
import org.apache.helix.controller.rebalancer.waged.RebalanceAlgorithm;
import org.apache.helix.controller.rebalancer.waged.constraints.ConstraintBasedAlgorithmFactory;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModel;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.controller.rebalancer.waged.model.OptimalAssignment;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.monitoring.metrics.MetricCollector;
import org.apache.helix.monitoring.metrics.WagedRebalancerMetricCollector;
import org.apache.helix.monitoring.metrics.implementation.BaselineDivergenceGauge;
import org.apache.helix.monitoring.metrics.model.CountMetric;
import org.apache.helix.monitoring.metrics.model.LatencyMetric;
import org.apache.helix.util.RebalanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WagedRebalancer
implements StatefulRebalancer<ResourceControllerDataProvider> {
    private static final Logger LOG = LoggerFactory.getLogger(WagedRebalancer.class);
    private static final Set<HelixConstants.ChangeType> GLOBAL_REBALANCE_REQUIRED_CHANGE_TYPES = ImmutableSet.of((Object)((Object)HelixConstants.ChangeType.RESOURCE_CONFIG), (Object)((Object)HelixConstants.ChangeType.IDEAL_STATE), (Object)((Object)HelixConstants.ChangeType.CLUSTER_CONFIG), (Object)((Object)HelixConstants.ChangeType.INSTANCE_CONFIG));
    private static final Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> NOT_CONFIGURED_PREFERENCE = ImmutableMap.of((Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.EVENNESS), (Object)-1, (Object)((Object)ClusterConfig.GlobalRebalancePreferenceKey.LESS_MOVEMENT), (Object)-1);
    private static final RebalanceAlgorithm DEFAULT_REBALANCE_ALGORITHM = ConstraintBasedAlgorithmFactory.getInstance(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    private static final List<HelixRebalanceException.Type> FAILURE_TYPES_TO_PROPAGATE = Collections.unmodifiableList(Arrays.asList(HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, HelixRebalanceException.Type.UNKNOWN_FAILURE));
    private final ExecutorService _baselineCalculateExecutor;
    private final ExecutorService _bestPossibleCalculateExecutor;
    private final ResourceChangeDetector _changeDetector;
    private final HelixManager _manager;
    private final MappingCalculator<ResourceControllerDataProvider> _mappingCalculator;
    private final AssignmentMetadataStore _assignmentMetadataStore;
    private final MetricCollector _metricCollector;
    private final CountMetric _rebalanceFailureCount;
    private final CountMetric _baselineCalcCounter;
    private final LatencyMetric _baselineCalcLatency;
    private final LatencyMetric _writeLatency;
    private final CountMetric _partialRebalanceCounter;
    private final LatencyMetric _partialRebalanceLatency;
    private final CountMetric _emergencyRebalanceCounter;
    private final LatencyMetric _emergencyRebalanceLatency;
    private final CountMetric _rebalanceOverwriteCounter;
    private final LatencyMetric _rebalanceOverwriteLatency;
    private final LatencyMetric _stateReadLatency;
    private final BaselineDivergenceGauge _baselineDivergenceGauge;
    private boolean _asyncGlobalRebalanceEnabled;
    private boolean _asyncPartialRebalanceEnabled;
    private Future<Boolean> _asyncPartialRebalanceResult;
    private RebalanceAlgorithm _rebalanceAlgorithm;
    private Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> _preference = NOT_CONFIGURED_PREFERENCE;

    private static AssignmentMetadataStore constructAssignmentStore(String metadataStoreAddrs, String clusterName) {
        if (metadataStoreAddrs != null && clusterName != null) {
            return new AssignmentMetadataStore(metadataStoreAddrs, clusterName);
        }
        return null;
    }

    public WagedRebalancer(HelixManager helixManager) {
        this(helixManager == null ? null : WagedRebalancer.constructAssignmentStore(helixManager.getMetadataStoreConnectionString(), helixManager.getClusterName()), DEFAULT_REBALANCE_ALGORITHM, new DelayedAutoRebalancer(), helixManager, helixManager == null ? new WagedRebalancerMetricCollector() : new WagedRebalancerMetricCollector(helixManager.getClusterName()), true, true);
        this._preference = ImmutableMap.copyOf(ClusterConfig.DEFAULT_GLOBAL_REBALANCE_PREFERENCE);
    }

    protected WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, Optional<MetricCollector> metricCollectorOptional) {
        this(assignmentMetadataStore, algorithm, new DelayedAutoRebalancer(), null, metricCollectorOptional.orElse(new WagedRebalancerMetricCollector()), false, false);
    }

    private WagedRebalancer(AssignmentMetadataStore assignmentMetadataStore, RebalanceAlgorithm algorithm, MappingCalculator mappingCalculator, HelixManager manager, MetricCollector metricCollector, boolean isAsyncGlobalRebalanceEnabled, boolean isAsyncPartialRebalanceEnabled) {
        if (assignmentMetadataStore == null) {
            LOG.warn("Assignment Metadata Store is not configured properly. The rebalancer will not access the assignment store during the rebalance.");
        }
        this._assignmentMetadataStore = assignmentMetadataStore;
        this._rebalanceAlgorithm = algorithm;
        this._mappingCalculator = mappingCalculator;
        if (manager == null) {
            LOG.warn("HelixManager is not provided. The rebalancer is not going to schedule for a future rebalance even when delayed rebalance is enabled.");
        }
        this._manager = manager;
        this._metricCollector = metricCollector;
        this._rebalanceFailureCount = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceFailureCounter.name(), CountMetric.class);
        this._baselineCalcCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.GlobalBaselineCalcCounter.name(), CountMetric.class);
        this._baselineCalcLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.GlobalBaselineCalcLatencyGauge.name(), LatencyMetric.class);
        this._partialRebalanceCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceCounter.name(), CountMetric.class);
        this._partialRebalanceLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.PartialRebalanceLatencyGauge.name(), LatencyMetric.class);
        this._emergencyRebalanceCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.EmergencyRebalanceCounter.name(), CountMetric.class);
        this._emergencyRebalanceLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.EmergencyRebalanceLatencyGauge.name(), LatencyMetric.class);
        this._rebalanceOverwriteCounter = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceOverwriteCounter.name(), CountMetric.class);
        this._rebalanceOverwriteLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.RebalanceOverwriteLatencyGauge.name(), LatencyMetric.class);
        this._writeLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateWriteLatencyGauge.name(), LatencyMetric.class);
        this._stateReadLatency = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.StateReadLatencyGauge.name(), LatencyMetric.class);
        this._baselineDivergenceGauge = this._metricCollector.getMetric(WagedRebalancerMetricCollector.WagedRebalancerMetricNames.BaselineDivergenceGauge.name(), BaselineDivergenceGauge.class);
        this._changeDetector = new ResourceChangeDetector(true);
        this._baselineCalculateExecutor = Executors.newSingleThreadExecutor();
        this._bestPossibleCalculateExecutor = Executors.newSingleThreadExecutor();
        this._asyncGlobalRebalanceEnabled = isAsyncGlobalRebalanceEnabled;
        this._asyncPartialRebalanceEnabled = isAsyncPartialRebalanceEnabled;
    }

    public void setGlobalRebalanceAsyncMode(boolean isAsyncGlobalRebalanceEnabled) {
        this._asyncGlobalRebalanceEnabled = isAsyncGlobalRebalanceEnabled;
    }

    public void setPartialRebalanceAsyncMode(boolean isAsyncPartialRebalanceEnabled) {
        this._asyncPartialRebalanceEnabled = isAsyncPartialRebalanceEnabled;
    }

    public synchronized void updateRebalancePreference(Map<ClusterConfig.GlobalRebalancePreferenceKey, Integer> newPreference) {
        if (!this._preference.equals(NOT_CONFIGURED_PREFERENCE) && !this._preference.equals(newPreference)) {
            this._rebalanceAlgorithm = ConstraintBasedAlgorithmFactory.getInstance(newPreference);
            this._preference = ImmutableMap.copyOf(newPreference);
        }
    }

    @Override
    public void reset() {
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.reset();
        }
        this._changeDetector.resetSnapshots();
    }

    @Override
    public void close() {
        if (this._baselineCalculateExecutor != null) {
            this._baselineCalculateExecutor.shutdownNow();
        }
        if (this._bestPossibleCalculateExecutor != null) {
            this._bestPossibleCalculateExecutor.shutdownNow();
        }
        if (this._assignmentMetadataStore != null) {
            this._assignmentMetadataStore.close();
        }
        this._metricCollector.unregister();
    }

    @Override
    public Map<String, IdealState> computeNewIdealStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput) throws HelixRebalanceException {
        Map<String, IdealState> newIdealStates;
        LOG.info("Start computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        this.validateInput(clusterData, resourceMap);
        try {
            newIdealStates = this.computeBestPossibleStates(clusterData, resourceMap, currentStateOutput, this._rebalanceAlgorithm);
        }
        catch (HelixRebalanceException ex) {
            LOG.error("Failed to calculate the new assignments.", (Throwable)ex);
            this._rebalanceFailureCount.increment(1L);
            HelixRebalanceException.Type failureType = ex.getFailureType();
            if (this.failureTypesToPropagate().contains((Object)failureType)) {
                throw ex;
            }
            LOG.warn("Returning the last known-good best possible assignment from metadata store due to rebalance failure of type: {}", (Object)failureType);
            Map<String, ResourceAssignment> assignmentRecord = this.getBestPossibleAssignment(this._assignmentMetadataStore, new CurrentStateOutput(), resourceMap.keySet());
            newIdealStates = this.convertResourceAssignment(clusterData, assignmentRecord);
        }
        newIdealStates.values().parallelStream().forEach(idealState -> {
            String resourceName = idealState.getResourceName();
            ResourceAssignment finalAssignment = this._mappingCalculator.computeBestPossiblePartitionState(clusterData, (IdealState)idealState, (Resource)resourceMap.get(resourceName), currentStateOutput);
            idealState.getRecord().getMapFields().clear();
            for (Partition partition : finalAssignment.getMappedPartitions()) {
                Map<String, String> newStateMap = finalAssignment.getReplicaMap(partition);
                idealState.setInstanceStateMap(partition.getPartitionName(), newStateMap == null ? Collections.emptyMap() : newStateMap);
            }
        });
        LOG.info("Finish computing new ideal states for resources: {}", (Object)resourceMap.keySet().toString());
        return newIdealStates;
    }

    private Map<String, IdealState> computeBestPossibleStates(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Set<String> activeNodes = DelayedRebalanceUtil.getActiveNodes(clusterData.getAllInstances(), clusterData.getEnabledLiveInstances(), clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterData.getClusterConfig());
        this.delayedRebalanceSchedule(clusterData, activeNodes, resourceMap.keySet());
        Map<String, ResourceAssignment> newBestPossibleAssignment = this.computeBestPossibleAssignment(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        Map<String, IdealState> newIdealStates = this.convertResourceAssignment(clusterData, newBestPossibleAssignment);
        if (!activeNodes.equals(clusterData.getEnabledLiveInstances()) && this.requireRebalanceOverwrite(clusterData, newBestPossibleAssignment)) {
            this.applyRebalanceOverwrite(newIdealStates, clusterData, resourceMap, this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet()), algorithm);
        }
        newIdealStates.forEach((resourceName, idealState) -> this.applyUserDefinedPreferenceList(clusterData.getResourceConfig((String)resourceName), (IdealState)idealState));
        return newIdealStates;
    }

    protected Map<String, ResourceAssignment> computeBestPossibleAssignment(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        this.globalRebalance(clusterData, resourceMap, currentStateOutput, algorithm);
        Map<String, ResourceAssignment> newAssignment = this.emergencyRebalance(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        return newAssignment;
    }

    private Map<String, IdealState> convertResourceAssignment(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> assignments) throws HelixRebalanceException {
        HashMap<String, IdealState> finalIdealStateMap = new HashMap<String, IdealState>();
        for (String resourceName : assignments.keySet()) {
            try {
                IdealState currentIdealState = clusterData.getIdealState(resourceName);
                Map<String, Integer> statePriorityMap = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()).getStatePriorityMap();
                IdealState newIdealState = new IdealState(resourceName);
                newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
                newIdealState.setPreferenceLists(this.getPreferenceLists(assignments.get(resourceName), statePriorityMap));
                finalIdealStateMap.put(resourceName, newIdealState);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to calculate the new IdealState for resource: " + resourceName, HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
        }
        return finalIdealStateMap;
    }

    protected List<HelixRebalanceException.Type> failureTypesToPropagate() {
        return FAILURE_TYPES_TO_PROPAGATE;
    }

    private void globalRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        this._changeDetector.updateSnapshots(clusterData);
        Map<HelixConstants.ChangeType, Set<String>> clusterChanges = this._changeDetector.getAllChanges();
        if (clusterChanges.keySet().stream().anyMatch(GLOBAL_REBALANCE_REQUIRED_CHANGE_TYPES::contains)) {
            boolean waitForGlobalRebalance = !this._asyncGlobalRebalanceEnabled;
            Future<Boolean> result = this._baselineCalculateExecutor.submit(() -> {
                try {
                    this.doGlobalRebalance(clusterData, resourceMap, algorithm, currentStateOutput, !waitForGlobalRebalance, clusterChanges);
                }
                catch (HelixRebalanceException e) {
                    if (this._asyncGlobalRebalanceEnabled) {
                        this._rebalanceFailureCount.increment(1L);
                    }
                    LOG.error("Failed to calculate baseline assignment!", (Throwable)e);
                    return false;
                }
                return true;
            });
            if (waitForGlobalRebalance) {
                try {
                    if (!result.get().booleanValue()) {
                        throw new HelixRebalanceException("Failed to calculate for the new Baseline.", HelixRebalanceException.Type.FAILED_TO_CALCULATE);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new HelixRebalanceException("Failed to execute new Baseline calculation.", HelixRebalanceException.Type.FAILED_TO_CALCULATE, e);
                }
            }
        }
    }

    private void doGlobalRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, RebalanceAlgorithm algorithm, CurrentStateOutput currentStateOutput, boolean shouldTriggerMainPipeline, Map<HelixConstants.ChangeType, Set<String>> clusterChanges) throws HelixRebalanceException {
        boolean isBaselineChanged;
        ClusterModel clusterModel;
        LOG.info("Start calculating the new baseline.");
        this._baselineCalcCounter.increment(1L);
        this._baselineCalcLatency.startMeasuringLatency();
        Map<String, ResourceAssignment> currentBaseline = this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        try {
            clusterModel = ClusterModelProvider.generateClusterModelForBaseline(clusterData, resourceMap, clusterData.getAllInstances(), clusterChanges, currentBaseline);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for global rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, ResourceAssignment> newBaseline = this.calculateAssignment(clusterModel, algorithm);
        boolean bl = isBaselineChanged = this._assignmentMetadataStore != null && this._assignmentMetadataStore.isBaselineChanged(newBaseline);
        if (isBaselineChanged) {
            try {
                this._writeLatency.startMeasuringLatency();
                this._assignmentMetadataStore.persistBaseline(newBaseline);
                this._writeLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to persist the new baseline assignment.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the baseline assignment.");
        }
        this._baselineCalcLatency.endMeasuringLatency();
        LOG.info("Global baseline calculation completed and has been persisted into metadata store.");
        if (isBaselineChanged && shouldTriggerMainPipeline) {
            LOG.info("Schedule a new rebalance after the new baseline calculation has finished.");
            RebalanceUtil.scheduleOnDemandPipeline(clusterData.getClusterName(), 0L, false);
        }
    }

    private void partialRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        if (this._asyncPartialRebalanceEnabled && this._asyncPartialRebalanceResult != null && !this._asyncPartialRebalanceResult.isDone()) {
            return;
        }
        this._asyncPartialRebalanceResult = this._bestPossibleCalculateExecutor.submit(() -> {
            try {
                this.doPartialRebalance(clusterData, resourceMap, activeNodes, algorithm, currentStateOutput);
            }
            catch (HelixRebalanceException e) {
                if (this._asyncPartialRebalanceEnabled) {
                    this._rebalanceFailureCount.increment(1L);
                }
                LOG.error("Failed to calculate best possible assignment!", (Throwable)e);
                return false;
            }
            return true;
        });
        if (!this._asyncPartialRebalanceEnabled) {
            try {
                if (!this._asyncPartialRebalanceResult.get().booleanValue()) {
                    throw new HelixRebalanceException("Failed to calculate for the new best possible.", HelixRebalanceException.Type.FAILED_TO_CALCULATE);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HelixRebalanceException("Failed to execute new best possible calculation.", HelixRebalanceException.Type.FAILED_TO_CALCULATE, e);
            }
        }
    }

    private void doPartialRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, RebalanceAlgorithm algorithm, CurrentStateOutput currentStateOutput) throws HelixRebalanceException {
        ClusterModel clusterModel;
        LOG.info("Start calculating the new best possible assignment.");
        this._partialRebalanceCounter.increment(1L);
        this._partialRebalanceLatency.startMeasuringLatency();
        int newBestPossibleAssignmentVersion = -1;
        if (this._assignmentMetadataStore != null) {
            newBestPossibleAssignmentVersion = this._assignmentMetadataStore.getBestPossibleVersion() + 1;
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip getting best possible assignment version.");
        }
        Map<String, ResourceAssignment> currentBaseline = this.getBaselineAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        Map<String, ResourceAssignment> currentBestPossibleAssignment = this.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        try {
            clusterModel = ClusterModelProvider.generateClusterModelForPartialRebalance(clusterData, resourceMap, activeNodes, currentBaseline, currentBestPossibleAssignment);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for partial rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, ResourceAssignment> newAssignment = this.calculateAssignment(clusterModel, algorithm);
        HashMap<String, ResourceAssignment> newAssignmentCopy = new HashMap<String, ResourceAssignment>();
        for (Map.Entry<String, ResourceAssignment> entry : newAssignment.entrySet()) {
            newAssignmentCopy.put(entry.getKey(), new ResourceAssignment(entry.getValue().getRecord()));
        }
        this._baselineDivergenceGauge.asyncMeasureAndUpdateValue(clusterData.getAsyncTasksThreadPool(), currentBaseline, newAssignmentCopy);
        boolean bestPossibleUpdateSuccessful = false;
        if (this._assignmentMetadataStore != null && this._assignmentMetadataStore.isBestPossibleChanged(newAssignment)) {
            bestPossibleUpdateSuccessful = this._assignmentMetadataStore.asyncUpdateBestPossibleAssignmentCache(newAssignment, newBestPossibleAssignmentVersion);
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the baseline assignment.");
        }
        this._partialRebalanceLatency.endMeasuringLatency();
        LOG.info("Finish calculating the new best possible assignment.");
        if (bestPossibleUpdateSuccessful) {
            LOG.info("Schedule a new rebalance after the new best possible calculation has finished.");
            RebalanceUtil.scheduleOnDemandPipeline(clusterData.getClusterName(), 0L, false);
        }
    }

    protected Map<String, ResourceAssignment> emergencyRebalance(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Set<String> activeNodes, CurrentStateOutput currentStateOutput, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        Map<String, ResourceAssignment> newAssignment;
        LOG.info("Start emergency rebalance.");
        this._emergencyRebalanceCounter.increment(1L);
        this._emergencyRebalanceLatency.startMeasuringLatency();
        Map<String, ResourceAssignment> currentBestPossibleAssignment = this.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
        AtomicBoolean allNodesActive = new AtomicBoolean(true);
        currentBestPossibleAssignment.values().parallelStream().forEach(resourceAssignment -> resourceAssignment.getMappedPartitions().parallelStream().forEach(partition -> {
            for (String instance : resourceAssignment.getReplicaMap((Partition)partition).keySet()) {
                if (activeNodes.contains(instance)) continue;
                allNodesActive.set(false);
                break;
            }
        }));
        if (!allNodesActive.get()) {
            ClusterModel clusterModel;
            LOG.info("Emergency rebalance responding to permanent node down.");
            try {
                clusterModel = ClusterModelProvider.generateClusterModelForEmergencyRebalance(clusterData, resourceMap, activeNodes, currentBestPossibleAssignment);
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to generate cluster model for emergency rebalance.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
            }
            newAssignment = this.calculateAssignment(clusterModel, algorithm);
        } else {
            newAssignment = currentBestPossibleAssignment;
        }
        this.persistBestPossibleAssignment(newAssignment);
        this._emergencyRebalanceLatency.endMeasuringLatency();
        LOG.info("Finish emergency rebalance");
        this.partialRebalance(clusterData, resourceMap, activeNodes, currentStateOutput, algorithm);
        if (!this._asyncPartialRebalanceEnabled) {
            newAssignment = this.getBestPossibleAssignment(this._assignmentMetadataStore, currentStateOutput, resourceMap.keySet());
            this.persistBestPossibleAssignment(newAssignment);
        }
        return newAssignment;
    }

    private Map<String, ResourceAssignment> calculateAssignment(ClusterModel clusterModel, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        long startTime = System.currentTimeMillis();
        LOG.info("Start calculating for an assignment with algorithm {}", (Object)algorithm.getClass().getSimpleName());
        OptimalAssignment optimalAssignment = algorithm.calculate(clusterModel);
        Map<String, ResourceAssignment> newAssignment = optimalAssignment.getOptimalResourceAssignment();
        LOG.info("Finish calculating an assignment with algorithm {}. Took: {} ms.", (Object)algorithm.getClass().getSimpleName(), (Object)(System.currentTimeMillis() - startTime));
        return newAssignment;
    }

    private Map<String, List<String>> getPreferenceLists(ResourceAssignment newAssignment, Map<String, Integer> statePriorityMap) {
        HashMap<String, List<String>> preferenceList = new HashMap<String, List<String>>();
        for (Partition partition : newAssignment.getMappedPartitions()) {
            ArrayList<String> nodes = new ArrayList<String>(newAssignment.getReplicaMap(partition).keySet());
            nodes.sort((node1, node2) -> {
                int statePriority2;
                int statePriority1 = (Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node1));
                if (statePriority1 == (statePriority2 = ((Integer)statePriorityMap.get(newAssignment.getReplicaMap(partition).get(node2))).intValue())) {
                    return node1.compareTo((String)node2);
                }
                return statePriority1 - statePriority2;
            });
            preferenceList.put(partition.getPartitionName(), nodes);
        }
        return preferenceList;
    }

    private void validateInput(ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap) throws HelixRebalanceException {
        Set nonCompatibleResources = resourceMap.keySet().stream().filter(resource -> !WagedValidationUtil.isWagedEnabled(clusterData.getIdealState((String)resource))).collect(Collectors.toSet());
        if (!nonCompatibleResources.isEmpty()) {
            throw new HelixRebalanceException(String.format("Input contains invalid resource(s) that cannot be rebalanced by the WAGED rebalancer. %s", nonCompatibleResources.toString()), HelixRebalanceException.Type.INVALID_INPUT);
        }
    }

    private Map<String, ResourceAssignment> getBaselineAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        HashMap<Object, Object> currentBaseline = new HashMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBaseline = new HashMap<String, ResourceAssignment>(assignmentMetadataStore.getBaseline());
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current baseline assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        currentBaseline.keySet().retainAll(resources);
        HashSet<String> missingResources = new HashSet<String>(resources);
        missingResources.removeAll(currentBaseline.keySet());
        currentBaseline.putAll(currentStateOutput.getAssignment(missingResources));
        return currentBaseline;
    }

    protected Map<String, ResourceAssignment> getBestPossibleAssignment(AssignmentMetadataStore assignmentMetadataStore, CurrentStateOutput currentStateOutput, Set<String> resources) throws HelixRebalanceException {
        HashMap<Object, Object> currentBestAssignment = new HashMap();
        if (assignmentMetadataStore != null) {
            try {
                this._stateReadLatency.startMeasuringLatency();
                currentBestAssignment = new HashMap<String, ResourceAssignment>(assignmentMetadataStore.getBestPossibleAssignment());
                this._stateReadLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to get the current best possible assignment because of unexpected error.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        }
        currentBestAssignment.keySet().retainAll(resources);
        HashSet<String> missingResources = new HashSet<String>(resources);
        missingResources.removeAll(currentBestAssignment.keySet());
        currentBestAssignment.putAll(currentStateOutput.getAssignment(missingResources));
        return currentBestAssignment;
    }

    private void persistBestPossibleAssignment(Map<String, ResourceAssignment> bestPossibleAssignment) throws HelixRebalanceException {
        if (this._assignmentMetadataStore != null && this._assignmentMetadataStore.isBestPossibleChanged(bestPossibleAssignment)) {
            try {
                this._writeLatency.startMeasuringLatency();
                this._assignmentMetadataStore.persistBestPossibleAssignment(bestPossibleAssignment);
                this._writeLatency.endMeasuringLatency();
            }
            catch (Exception ex) {
                throw new HelixRebalanceException("Failed to persist the new best possible assignment.", HelixRebalanceException.Type.INVALID_REBALANCER_STATUS, ex);
            }
        } else {
            LOG.debug("Assignment Metadata Store is null. Skip persisting the best possible assignment.");
        }
    }

    private void delayedRebalanceSchedule(ResourceControllerDataProvider clusterData, Set<String> delayedActiveNodes, Set<String> resourceSet) {
        if (this._manager != null) {
            ClusterConfig clusterConfig = clusterData.getClusterConfig();
            boolean delayedRebalanceEnabled = DelayedRebalanceUtil.isDelayRebalanceEnabled(clusterConfig);
            HashSet<String> offlineOrDisabledInstances = new HashSet<String>(delayedActiveNodes);
            offlineOrDisabledInstances.removeAll(clusterData.getEnabledLiveInstances());
            for (String resource : resourceSet) {
                DelayedRebalanceUtil.setRebalanceScheduler(resource, delayedRebalanceEnabled, offlineOrDisabledInstances, clusterData.getInstanceOfflineTimeMap(), clusterData.getLiveInstances().keySet(), clusterData.getInstanceConfigMap(), clusterConfig.getRebalanceDelayTime(), clusterConfig, this._manager);
            }
        } else {
            LOG.warn("Skip scheduling a delayed rebalancer since HelixManager is not specified.");
        }
    }

    protected boolean requireRebalanceOverwrite(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> bestPossibleAssignment) {
        AtomicBoolean allMinActiveReplicaMet = new AtomicBoolean(true);
        bestPossibleAssignment.values().parallelStream().forEach(resourceAssignment -> {
            String resourceName = resourceAssignment.getResourceName();
            IdealState currentIdealState = clusterData.getIdealState(resourceName);
            Set<String> enabledLiveInstances = clusterData.getEnabledLiveInstances();
            int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
            int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
            resourceAssignment.getMappedPartitions().parallelStream().forEach(partition -> {
                int enabledLivePlacementCounter = 0;
                for (String instance : resourceAssignment.getReplicaMap((Partition)partition).keySet()) {
                    if (!enabledLiveInstances.contains(instance)) continue;
                    ++enabledLivePlacementCounter;
                }
                if (enabledLivePlacementCounter < Math.min(minActiveReplica, numReplica)) {
                    allMinActiveReplicaMet.set(false);
                }
            });
        });
        return !allMinActiveReplicaMet.get();
    }

    protected void applyRebalanceOverwrite(Map<String, IdealState> idealStateMap, ResourceControllerDataProvider clusterData, Map<String, Resource> resourceMap, Map<String, ResourceAssignment> baseline, RebalanceAlgorithm algorithm) throws HelixRebalanceException {
        ClusterModel clusterModel;
        this._rebalanceOverwriteCounter.increment(1L);
        this._rebalanceOverwriteLatency.startMeasuringLatency();
        try {
            clusterModel = ClusterModelProvider.generateClusterModelFromExistingAssignment(clusterData, resourceMap, baseline);
        }
        catch (Exception ex) {
            throw new HelixRebalanceException("Failed to generate cluster model for delayed rebalance overwrite.", HelixRebalanceException.Type.INVALID_CLUSTER_STATUS, ex);
        }
        Map<String, IdealState> activeIdealStates = this.convertResourceAssignment(clusterData, this.calculateAssignment(clusterModel, algorithm));
        for (String resourceName : idealStateMap.keySet()) {
            IdealState newIdealState = idealStateMap.get(resourceName);
            if (!activeIdealStates.containsKey(resourceName)) {
                throw new HelixRebalanceException("Failed to calculate the complete partition assignment with all active nodes. Cannot find the resource assignment for " + resourceName, HelixRebalanceException.Type.FAILED_TO_CALCULATE);
            }
            IdealState newActiveIdealState = activeIdealStates.get(resourceName);
            IdealState currentIdealState = clusterData.getIdealState(resourceName);
            Set<String> enabledLiveInstances = clusterData.getEnabledLiveInstances();
            int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
            int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
            Map<String, List<String>> finalPreferenceLists = DelayedRebalanceUtil.getFinalDelayedMapping(newActiveIdealState.getPreferenceLists(), newIdealState.getPreferenceLists(), enabledLiveInstances, Math.min(minActiveReplica, numReplica));
            newIdealState.setPreferenceLists(finalPreferenceLists);
            this._rebalanceOverwriteLatency.endMeasuringLatency();
        }
    }

    private void applyUserDefinedPreferenceList(ResourceConfig resourceConfig, IdealState idealState) {
        Map<String, List<String>> userDefinedPreferenceList;
        if (resourceConfig != null && !(userDefinedPreferenceList = resourceConfig.getPreferenceLists()).isEmpty()) {
            LOG.info("Using user defined preference list for partitions.");
            for (String partition : userDefinedPreferenceList.keySet()) {
                idealState.setPreferenceList(partition, userDefinedPreferenceList.get(partition));
            }
        }
    }

    protected AssignmentMetadataStore getAssignmentMetadataStore() {
        return this._assignmentMetadataStore;
    }

    protected MetricCollector getMetricCollector() {
        return this._metricCollector;
    }

    protected ResourceChangeDetector getChangeDetector() {
        return this._changeDetector;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

