/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.constraints;

import org.apache.helix.controller.rebalancer.waged.constraints.HardConstraint;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

class FaultZoneAwareConstraint
extends HardConstraint {
    FaultZoneAwareConstraint() {
    }

    @Override
    boolean isAssignmentValid(AssignableNode node, AssignableReplica replica, ClusterContext clusterContext) {
        if (!node.hasFaultZone()) {
            return true;
        }
        return !clusterContext.getPartitionsForResourceAndFaultZone(replica.getResourceName(), node.getFaultZone()).contains(replica.getPartitionName());
    }

    @Override
    String getDescription() {
        return "A fault zone cannot contain more than 1 replica of same partition";
    }
}

