/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.helix.manager.zk.CallbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackEventThreadPoolFactory {
    private static Logger logger = LoggerFactory.getLogger(CallbackHandler.class);
    private static final int CALLBACK_EVENT_THREAD_POOL_SIZE = 10;
    private static final int CALLBACK_EVENT_THREAD_POOL_TTL_MINUTE = 3;
    private static final ReentrantReadWriteLock _lock = new ReentrantReadWriteLock();
    private static Map<Integer, ThreadPoolExecutor> _managerToCallBackThreadPoolMap = new HashMap<Integer, ThreadPoolExecutor>();
    private static Map<Integer, AtomicInteger> _callBackEventProcessorCountPerThreadPool = new HashMap<Integer, AtomicInteger>();

    public static ThreadPoolExecutor getOrCreateThreadPool(int hash) {
        _lock.readLock().lock();
        ThreadPoolExecutor result = null;
        if (_managerToCallBackThreadPoolMap.containsKey(hash)) {
            result = _managerToCallBackThreadPoolMap.get(hash);
            _callBackEventProcessorCountPerThreadPool.get(hash).incrementAndGet();
        }
        _lock.readLock().unlock();
        if (result == null) {
            result = CallbackEventThreadPoolFactory.getOrCreateThreadPoolHelper(hash);
        }
        return result;
    }

    private static ThreadPoolExecutor getOrCreateThreadPoolHelper(int hash) {
        ThreadPoolExecutor result = null;
        _lock.writeLock().lock();
        if (_managerToCallBackThreadPoolMap.containsKey(hash)) {
            _lock.readLock().lock();
            _lock.writeLock().unlock();
            result = _managerToCallBackThreadPoolMap.get(hash);
            _lock.readLock().unlock();
        } else {
            try {
                ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat(String.format("CallbackHandlerExecutorService - %s ", hash)).build();
                result = new ThreadPoolExecutor(10, 10, 3L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
                result.allowCoreThreadTimeOut(true);
                _managerToCallBackThreadPoolMap.put(hash, result);
                _callBackEventProcessorCountPerThreadPool.put(hash, new AtomicInteger(1));
            }
            finally {
                _lock.writeLock().unlock();
            }
        }
        return result;
    }

    public static void unregisterEventProcessor(int managerHash) {
        ExecutorService threadPoolToClose = null;
        _lock.writeLock().lock();
        if (_callBackEventProcessorCountPerThreadPool.get(managerHash).decrementAndGet() == 0) {
            _callBackEventProcessorCountPerThreadPool.remove(managerHash);
            threadPoolToClose = _managerToCallBackThreadPoolMap.remove(managerHash);
        }
        _lock.writeLock().unlock();
        if (threadPoolToClose != null) {
            threadPoolToClose.shutdown();
        }
    }
}

