/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.waged.model;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixException;
import org.apache.helix.controller.rebalancer.waged.model.AssignableNode;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterContext;

public class ClusterModel {
    private final ClusterContext _clusterContext;
    private final Map<String, Set<AssignableReplica>> _assignableReplicaMap;
    private final Map<String, Map<String, AssignableReplica>> _assignableReplicaIndex;
    private final Map<String, AssignableNode> _assignableNodeMap;
    private final Set<String> _assignableNodeLogicalIds;

    ClusterModel(ClusterContext clusterContext, Set<AssignableReplica> assignableReplicas, Set<AssignableNode> assignableNodes) {
        this._clusterContext = clusterContext;
        this._assignableReplicaMap = assignableReplicas.stream().collect(Collectors.groupingBy(AssignableReplica::getResourceName, Collectors.toSet()));
        this._assignableReplicaIndex = assignableReplicas.stream().collect(Collectors.groupingBy(AssignableReplica::getResourceName, Collectors.toMap(AssignableReplica::toString, replica -> replica, (oldValue, newValue) -> oldValue)));
        this._assignableNodeMap = assignableNodes.parallelStream().collect(Collectors.toMap(AssignableNode::getInstanceName, node -> node));
        this._assignableNodeLogicalIds = assignableNodes.parallelStream().map(AssignableNode::getLogicalId).collect(Collectors.toSet());
    }

    public ClusterContext getContext() {
        return this._clusterContext;
    }

    public Map<String, AssignableNode> getAssignableNodes() {
        return this._assignableNodeMap;
    }

    public Set<String> getAssignableLogicalIds() {
        return this._assignableNodeLogicalIds;
    }

    public Map<String, Set<AssignableReplica>> getAssignableReplicaMap() {
        return this._assignableReplicaMap;
    }

    public void assign(String resourceName, String partitionName, String state, String instanceName) {
        AssignableNode node = this.locateAssignableNode(instanceName);
        AssignableReplica replica = this.locateAssignableReplica(resourceName, partitionName, state);
        node.assign(replica);
        this._clusterContext.addPartitionToFaultZone(node.getFaultZone(), resourceName, partitionName);
    }

    public void release(String resourceName, String partitionName, String state, String instanceName) {
        AssignableNode node = this.locateAssignableNode(instanceName);
        AssignableReplica replica = this.locateAssignableReplica(resourceName, partitionName, state);
        node.release(replica);
        this._clusterContext.removePartitionFromFaultZone(node.getFaultZone(), resourceName, partitionName);
    }

    private AssignableNode locateAssignableNode(String instanceName) {
        AssignableNode node = this._assignableNodeMap.get(instanceName);
        if (node == null) {
            throw new HelixException("Cannot find the instance: " + instanceName);
        }
        return node;
    }

    private AssignableReplica locateAssignableReplica(String resourceName, String partitionName, String state) {
        AssignableReplica sampleReplica = (AssignableReplica)this._assignableReplicaIndex.getOrDefault(resourceName, Collections.emptyMap()).get(AssignableReplica.generateReplicaKey(resourceName, partitionName, state));
        if (sampleReplica == null) {
            throw new HelixException(String.format("Cannot find the replication with resource name %s, partition name %s, state %s.", resourceName, partitionName, state));
        }
        return sampleReplica;
    }
}

