/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public final class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<? extends DDLDesc>, Class<? extends DDLOperation>> DESC_TO_OPERATION = new HashMap<Class<? extends DDLDesc>, Class<? extends DDLOperation>>();

    @Override
    public boolean requireLock() {
        return this.work != null && ((DDLWork)this.work).getNeedLock();
    }

    @Override
    public int execute() {
        if (this.context.getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return 0;
        }
        Object ddlOperation = null;
        try {
            DDLDesc ddlDesc = ((DDLWork)this.work).getDDLDesc();
            if (DESC_TO_OPERATION.containsKey(ddlDesc.getClass())) {
                DDLOperationContext ddlOperationContext = new DDLOperationContext(this.conf, this.context, this, (DDLWork)this.work, this.queryState, this.queryPlan, this.console);
                Class<? extends DDLOperation> ddlOperationClass = DESC_TO_OPERATION.get(ddlDesc.getClass());
                Constructor<? extends DDLOperation> constructor = ddlOperationClass.getConstructor(DDLOperationContext.class, ddlDesc.getClass());
                ddlOperation = constructor.newInstance(ddlOperationContext, ddlDesc);
                return ((DDLOperation)ddlOperation).execute();
            }
            throw new IllegalArgumentException("Unknown DDL request: " + ddlDesc.getClass());
        }
        catch (Throwable e) {
            if (((DDLWork)this.work).isReplication() && ReplUtils.shouldIgnoreOnError(ddlOperation, e)) {
                LOG.warn("Error while table creation: ", e);
                return 0;
            }
            this.failed(e);
            if (ddlOperation != null) {
                LOG.error("DDLTask failed, DDL Operation: " + ddlOperation.getClass().toString(), e);
            }
            return ReplUtils.handleException(((DDLWork)this.work).isReplication(), e, ((DDLWork)this.work).getDumpDirectory(), ((DDLWork)this.work).getMetricCollector(), this.getName(), this.conf);
        }
    }

    private void failed(Throwable e) {
        while (e.getCause() != null && e.getClass() == RuntimeException.class) {
            e = e.getCause();
        }
        this.setException(e);
        LOG.error("Failed", e);
    }

    @Override
    public StageType getType() {
        return StageType.DDL;
    }

    public String getName() {
        return "DDL";
    }

    @Override
    public boolean canExecuteInParallel() {
        return ((DDLWork)this.work).canExecuteInParallel();
    }

    static {
        Set operationClasses = new Reflections("org.apache.hadoop.hive.ql.ddl", new Scanner[0]).getSubTypesOf(DDLOperation.class);
        for (Class operationClass : operationClasses) {
            if (Modifier.isAbstract(operationClass.getModifiers())) continue;
            ParameterizedType parameterizedType = (ParameterizedType)operationClass.getGenericSuperclass();
            Class descClass = (Class)parameterizedType.getActualTypeArguments()[0];
            DESC_TO_OPERATION.put(descClass, operationClass);
        }
    }
}

