/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.drop;

import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.dataconnector.drop.DropDataConnectorDesc;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1002})
public class DropDataConnectorAnalyzer
extends BaseSemanticAnalyzer {
    public DropDataConnectorAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        boolean ifExists;
        String connectorName = DropDataConnectorAnalyzer.unescapeIdentifier(root.getChild(0).getText());
        DataConnector connector = this.getDataConnector(connectorName, !(ifExists = root.getFirstChildWithType(1050) != null));
        if (connector == null) {
            return;
        }
        this.inputs.add(new ReadEntity(connector));
        this.outputs.add(new WriteEntity(connector, WriteEntity.WriteType.DDL_NO_LOCK));
        DropDataConnectorDesc desc = new DropDataConnectorDesc(connectorName, ifExists);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc)));
    }
}

