/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.show;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.dataconnector.show.ShowDataConnectorsDesc;
import org.apache.hadoop.hive.ql.ddl.dataconnector.show.ShowDataConnectorsFormatter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.io.IOUtils;

public class ShowDataConnectorsOperation
extends DDLOperation<ShowDataConnectorsDesc> {
    public ShowDataConnectorsOperation(DDLOperationContext context, ShowDataConnectorsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        List<String> connectors = this.context.getDb().getAllDataConnectorNames();
        if (((ShowDataConnectorsDesc)this.desc).getPattern() != null) {
            LOG.debug("pattern: {}", (Object)((ShowDataConnectorsDesc)this.desc).getPattern());
            Pattern pattern = Pattern.compile(UDFLike.likePatternToRegExp(((ShowDataConnectorsDesc)this.desc).getPattern()), 2);
            connectors = connectors.stream().filter(name -> pattern.matcher((CharSequence)name).matches()).collect(Collectors.toList());
        }
        LOG.info("Found {} connector(s) matching the SHOW CONNECTORS statement.", (Object)connectors.size());
        DataOutputStream outStream = ShowUtils.getOutputStream(new Path(((ShowDataConnectorsDesc)this.desc).getResFile()), this.context);
        try {
            ShowDataConnectorsFormatter formatter = ShowDataConnectorsFormatter.getFormatter(this.context.getConf());
            formatter.showDataConnectors(outStream, connectors);
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show connectors"});
        }
        finally {
            IOUtils.closeStream((Closeable)outStream);
        }
        return 0;
    }
}

