/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class BucketNumExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int rowNum = -1;
    private int bucketNum = -1;
    private boolean rowSet = false;
    private boolean bucketNumSet = false;

    public BucketNumExpression(int outputColNum) {
        super(-1, outputColNum);
    }

    public void initBuffer(VectorizedRowBatch batch) {
        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.outputColumnNum];
        cv.isRepeating = false;
        cv.initBuffer();
    }

    public void setRowNum(int rowNum) throws HiveException {
        this.rowNum = rowNum;
        if (this.rowSet) {
            throw new HiveException("Row number is already set");
        }
        this.rowSet = true;
    }

    public void setBucketNum(int bucketNum) throws HiveException {
        this.bucketNum = bucketNum;
        if (this.bucketNumSet) {
            throw new HiveException("Bucket number is already set");
        }
        this.bucketNumSet = true;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (!this.rowSet || !this.bucketNumSet) {
            throw new HiveException("row number or bucket number is not set before evaluation");
        }
        BytesColumnVector cv = (BytesColumnVector)batch.cols[this.outputColumnNum];
        String bucketNumStr = String.valueOf(this.bucketNum);
        cv.setVal(this.rowNum, bucketNumStr.getBytes(), 0, bucketNumStr.length());
        this.rowSet = false;
        this.bucketNumSet = false;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col : _bucket_number";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

