/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.EndianUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.TeradataBinaryRecordReader;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataBinaryFileOutputFormat<K extends WritableComparable, V extends Writable>
extends HiveIgnoreKeyTextOutputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(TeradataBinaryFileOutputFormat.class);
    static final byte RECORD_END_BYTE = 10;

    @Override
    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path outPath, Class<? extends Writable> valueClass, boolean isCompressed, final Properties tableProperties, Progressable progress) throws IOException {
        FileSystem fs = outPath.getFileSystem((Configuration)jc);
        final OutputStream outStream = Utilities.createCompressedStream(jc, (OutputStream)fs.create(outPath, progress), isCompressed);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable r) throws IOException {
                BytesWritable bw = (BytesWritable)r;
                int recordLength = bw.getLength();
                String rowLength = tableProperties.getProperty("teradata.row.length", "64kb").toLowerCase();
                LOG.debug(String.format("The table property %s is: %s", "teradata.row.length", rowLength));
                if (TeradataBinaryRecordReader.TD_ROW_LENGTH_TO_BYTE_NUM.containsKey(rowLength)) {
                    if (rowLength.equals("64kb")) {
                        EndianUtils.writeSwappedShort((OutputStream)outStream, (short)((short)recordLength));
                    } else if (rowLength.equals("1mb")) {
                        EndianUtils.writeSwappedInteger((OutputStream)outStream, (int)recordLength);
                    }
                } else {
                    throw new IllegalArgumentException(String.format("%s doesn't support the value %s, the supported values are %s", "teradata.row.length", rowLength, TeradataBinaryRecordReader.TD_ROW_LENGTH_TO_BYTE_NUM.keySet()));
                }
                outStream.write(bw.getBytes(), 0, bw.getLength());
                outStream.write(10);
            }

            @Override
            public void close(boolean abort) throws IOException {
                outStream.close();
            }
        };
    }
}

