/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.optimizer.BucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.BucketVersionPopulator;
import org.apache.hadoop.hive.ql.optimizer.BucketingSortingReduceSinkOptimizer;
import org.apache.hadoop.hive.ql.optimizer.ColumnPruner;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagate;
import org.apache.hadoop.hive.ql.optimizer.CountDistinctRewriteProc;
import org.apache.hadoop.hive.ql.optimizer.FixedBucketPruningOptimizer;
import org.apache.hadoop.hive.ql.optimizer.GlobalLimitOptimizer;
import org.apache.hadoop.hive.ql.optimizer.GroupByOptimizer;
import org.apache.hadoop.hive.ql.optimizer.IdentityProjectRemover;
import org.apache.hadoop.hive.ql.optimizer.JoinReorder;
import org.apache.hadoop.hive.ql.optimizer.LimitPushdownOptimizer;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.NonBlockingOpDeDupProc;
import org.apache.hadoop.hive.ql.optimizer.OrderlessLimitPushDownOptimizer;
import org.apache.hadoop.hive.ql.optimizer.PartitionColumnsSeparator;
import org.apache.hadoop.hive.ql.optimizer.PointLookupOptimizer;
import org.apache.hadoop.hive.ql.optimizer.RedundantDynamicPruningConditionsRemoval;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchAggregation;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SkewJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedDynPartitionTimeGranularityOptimizer;
import org.apache.hadoop.hive.ql.optimizer.SortedMergeBucketMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.StatsOptimizer;
import org.apache.hadoop.hive.ql.optimizer.TablePropertyEnrichmentOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverterPostProc;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationOptimizer;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateWithOpTraits;
import org.apache.hadoop.hive.ql.optimizer.pcr.PartitionConditionRemover;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateWithStatistics;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcessor;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.ppd.PredicatePushDown;
import org.apache.hadoop.hive.ql.ppd.PredicateTransitivePropagate;
import org.apache.hadoop.hive.ql.ppd.SimplePredicatePushDown;
import org.apache.hadoop.hive.ql.ppd.SyntheticJoinPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Optimizer {
    private ParseContext pctx;
    private List<Transform> transformations;
    private static final Logger LOG = LoggerFactory.getLogger((String)Optimizer.class.getName());

    public void initialize(HiveConf hiveConf) {
        boolean isTezExecEngine = HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez");
        boolean bucketMapJoinOptimizer = false;
        this.transformations = new ArrayList<Transform>();
        this.transformations.add(new HiveOpConverterPostProc());
        if (HiveConf.shouldComputeLineage((HiveConf)hiveConf)) {
            this.transformations.add(Generator.fromConf(hiveConf));
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_POINT_LOOKUP_OPTIMIZER) && !this.pctx.getContext().isCboSucceeded()) {
            int min = HiveConf.getIntVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_POINT_LOOKUP_OPTIMIZER_MIN);
            this.transformations.add(new PointLookupOptimizer(min));
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARTITION_COLUMN_SEPARATOR)) {
            this.transformations.add(new PartitionColumnsSeparator());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_PPD) && !this.pctx.getContext().isCboSucceeded()) {
            this.transformations.add(new PredicateTransitivePropagate());
            if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_CONSTANT_PROPAGATION)) {
                this.transformations.add(new ConstantPropagate());
            }
            this.transformations.add(new SyntheticJoinPredicate());
            this.transformations.add(new PredicatePushDown());
        } else if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_PPD) && this.pctx.getContext().isCboSucceeded()) {
            this.transformations.add(new SyntheticJoinPredicate());
            this.transformations.add(new SimplePredicatePushDown());
            this.transformations.add(new RedundantDynamicPruningConditionsRemoval());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_CONSTANT_PROPAGATION) && (!this.pctx.getContext().isCboSucceeded() || this.pctx.getContext().getOperation() == Context.Operation.MERGE)) {
            this.transformations.add(new ConstantPropagate());
        }
        this.transformations.add(new SortedDynPartitionTimeGranularityOptimizer());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_PPD)) {
            this.transformations.add(new PartitionPruner());
            this.transformations.add(new PartitionConditionRemover());
            if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_LIST_BUCKETING)) {
                this.transformations.add(new ListBucketingPruner());
            }
            if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_CONSTANT_PROPAGATION) && !this.pctx.getContext().isCboSucceeded()) {
                this.transformations.add(new ConstantPropagate());
            }
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_GROUPBY) || HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT)) {
            this.transformations.add(new GroupByOptimizer());
        }
        this.transformations.add(new ColumnPruner());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_COUNT_DISTINCT_OPTIMIZER) && (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST) || isTezExecEngine)) {
            this.transformations.add(new CountDistinctRewriteProc());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME)) {
            if (!isTezExecEngine) {
                this.transformations.add(new SkewJoinOptimizer());
            } else {
                LOG.warn("Skew join is currently not supported in tez! Disabling the skew join optimization.");
            }
        }
        this.transformations.add(new SamplePruner());
        MapJoinProcessor mapJoinProcessor = new MapJoinProcessor();
        this.transformations.add(mapJoinProcessor);
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_BUCKET_MAPJOIN) && !isTezExecEngine) {
            this.transformations.add(new BucketMapJoinOptimizer());
            bucketMapJoinOptimizer = true;
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_SORT_MERGE_BUCKET_MAPJOIN) && !isTezExecEngine) {
            if (!bucketMapJoinOptimizer) {
                this.transformations.add(new BucketMapJoinOptimizer());
            }
            this.transformations.add(new SortedMergeBucketMapJoinOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_BUCKETING_SORTING)) {
            this.transformations.add(new BucketingSortingReduceSinkOptimizer());
        }
        this.transformations.add(new UnionProcessor());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.N_WAY_JOIN_REORDER)) {
            this.transformations.add(new JoinReorder());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_OPTIMIZE_BUCKET_PRUNING) && HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_PPD) && HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_INDEX_FILTER)) {
            boolean compatMode = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.TEZ_OPTIMIZE_BUCKET_PRUNING_COMPAT);
            this.transformations.add(new FixedBucketPruningOptimizer(compatMode));
        }
        this.transformations.add(new BucketVersionPopulator());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_REDUCE_DEDUPLICATION) && !isTezExecEngine) {
            this.transformations.add(new ReduceSinkDeDuplication());
        }
        this.transformations.add(new NonBlockingOpDeDupProc());
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IDENTITY_PROJECT_REMOVER) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_RETPATH_HIVEOP)) {
            this.transformations.add(new IdentityProjectRemover());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LIMIT_OPT_ENABLE)) {
            this.transformations.add(new GlobalLimitOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_CORRELATION) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_SKEW) && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME) && !isTezExecEngine) {
            this.transformations.add(new CorrelationOptimizer());
        }
        if (HiveConf.getFloatVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LIMIT_PUSHDOWN_MEMORY_USAGE) > 0.0f) {
            this.transformations.add(new LimitPushdownOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_LIMIT)) {
            this.transformations.add(new OrderlessLimitPushDownOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_METADATA_QUERIES)) {
            this.transformations.add(new StatsOptimizer());
        }
        if (this.pctx.getContext().isExplainSkipExecution() && !isTezExecEngine) {
            this.transformations.add(new AnnotateWithStatistics());
            this.transformations.add(new AnnotateWithOpTraits());
        }
        if (!HiveConf.getVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_CONVERSION).equals("none")) {
            this.transformations.add(new SimpleFetchOptimizer());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_TASK_AGGR)) {
            this.transformations.add(new SimpleFetchAggregation());
        }
        if (HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPTIMIZE_TABLE_PROPERTIES_FROM_SERDE)) {
            this.transformations.add(new TablePropertyEnrichmentOptimizer());
        }
    }

    public ParseContext optimize() throws SemanticException {
        for (Transform t : this.transformations) {
            t.beginPerfLogging();
            this.pctx = t.transform(this.pctx);
            t.endPerfLogging(t.toString());
        }
        return this.pctx;
    }

    public ParseContext getPctx() {
        return this.pctx;
    }

    public void setPctx(ParseContext pctx) {
        this.pctx = pctx;
    }
}

