/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSortPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCSortPushDownRule.class);
    public static final JDBCSortPushDownRule INSTANCE = new JDBCSortPushDownRule();

    public JDBCSortPushDownRule() {
        super(JDBCSortPushDownRule.operand(HiveSortLimit.class, (RelOptRuleOperand)JDBCSortPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCSortPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        Sort sort = (Sort)call.rel(0);
        HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
        for (RexNode currCall : sort.getSortExps()) {
            if (JDBCRexCallValidator.isValidJdbcOperation(currCall, conv.getJdbcDialect())) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCSortPushDownRule has been called");
        HiveSortLimit sort = (HiveSortLimit)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        JdbcRules.JdbcSort node = sort.fetch != null && RexLiteral.intValue((RexNode)sort.fetch) == 0 ? new JdbcRules.JdbcFilter(sort.getCluster(), sort.getTraitSet().replace((RelTrait)converter.getJdbcConvention()), converter.getInput(), (RexNode)call.builder().literal((Object)false)) : new JdbcRules.JdbcSort(sort.getCluster(), sort.getTraitSet().replace((RelTrait)converter.getJdbcConvention()), converter.getInput(), sort.getCollation(), sort.offset, sort.fetch);
        call.transformTo(converter.copy(converter.getTraitSet(), (RelNode)node));
    }
}

