/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

@DDLSemanticAnalyzerFactory.DDLType(types={1136})
public class PrepareStatementAnalyzer
extends CalcitePlanner {
    public PrepareStatementAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    private String getQueryName(ASTNode root) {
        ASTNode queryNameAST = (ASTNode)root.getChild(1);
        return queryNameAST.getText();
    }

    private void savePlan(String queryName) throws SemanticException {
        SessionState ss = SessionState.get();
        assert (ss != null);
        if (ss.getPreparePlans().containsKey(queryName)) {
            throw new SemanticException("Prepare query: " + queryName + " already exists.");
        }
        ss.getPreparePlans().put(queryName, this);
    }

    private <T> T makeCopy(Object task, Class<T> objClass) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializationUtilities.serializePlan(task, baos);
        return SerializationUtilities.deserializePlan(new ByteArrayInputStream(baos.toByteArray()), objClass);
    }

    @Override
    protected void compilePlan(ParseContext pCtx) throws SemanticException {
        this.topOpsCopy = new HashMap();
        this.topOpsCopy = (Map)this.makeCopy(this.getTopOps(), this.getTopOps().getClass());
        super.compilePlan(pCtx);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        ASTNode query = (ASTNode)root.getChild(0);
        String queryName = this.getQueryName(root);
        super.analyzeInternal(query);
        this.prepareQuery = true;
        if (this.ctx.getExplainConfig() == null) {
            this.savePlan(queryName);
        }
    }
}

