/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationLog {
    private static final Logger LOG = LoggerFactory.getLogger(OperationLog.class);
    private final String operationName;
    private final LogFile logFile;
    private final LogFile testLogFile;
    private final boolean isShortLogs;
    private final boolean isRemoveLogs;
    private final LoggingLevel opLoggingLevel;

    public OperationLog(String name, File file, HiveConf hiveConf) {
        this.operationName = name;
        this.logFile = new LogFile(file);
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_ENABLED)) {
            String logLevel = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LEVEL);
            this.opLoggingLevel = OperationLog.getLoggingLevel(logLevel);
        } else {
            this.opLoggingLevel = LoggingLevel.UNKNOWN;
        }
        if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST)) {
            this.isRemoveLogs = hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_TESTING_REMOVE_LOGS);
            if (hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_TESTING_SHORT_LOGS)) {
                this.testLogFile = new LogFile(new File(file.getAbsolutePath() + ".test"));
                this.isShortLogs = true;
            } else {
                this.testLogFile = null;
                this.isShortLogs = false;
            }
        } else {
            this.testLogFile = null;
            this.isShortLogs = false;
            this.isRemoveLogs = !hiveConf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_HISTORIC_OPERATION_LOG_ENABLED);
        }
    }

    public static LoggingLevel getLoggingLevel(String mode) {
        String m;
        switch (m = StringUtils.defaultString((String)mode).toLowerCase()) {
            case "none": {
                return LoggingLevel.NONE;
            }
            case "execution": {
                return LoggingLevel.EXECUTION;
            }
            case "verbose": {
                return LoggingLevel.VERBOSE;
            }
            case "performance": {
                return LoggingLevel.PERFORMANCE;
            }
        }
        return LoggingLevel.UNKNOWN;
    }

    public LoggingLevel getOpLoggingLevel() {
        return this.opLoggingLevel;
    }

    public List<String> readOperationLog(boolean isFetchFirst, long maxRows) throws SQLException {
        LogFile lf = this.isShortLogs ? this.testLogFile : this.logFile;
        return lf.read(isFetchFirst, maxRows);
    }

    public void close() {
        if (this.isShortLogs) {
            this.logFile.close(this.isRemoveLogs);
            this.testLogFile.close(this.isRemoveLogs);
        } else {
            this.logFile.close(this.isRemoveLogs);
        }
    }

    public String toString() {
        return this.logFile.file.toString();
    }

    private class LogFile {
        private final File file;
        private BufferedReader in;
        private volatile boolean isRemoved;

        LogFile(File file) {
            this.file = file;
            this.isRemoved = false;
        }

        synchronized List<String> read(boolean isFetchFirst, long maxRows) throws SQLException {
            if (isFetchFirst) {
                this.resetIn();
            }
            if (maxRows >= Integer.MAX_VALUE) {
                throw new SQLException("Cannot support loading this many rows: " + maxRows);
            }
            return this.readResults((int)maxRows);
        }

        synchronized void close(boolean removeLog) {
            try {
                this.resetIn();
                if (removeLog && !this.isRemoved) {
                    if (this.file.exists()) {
                        FileUtils.forceDelete((File)this.file);
                    }
                    this.isRemoved = true;
                }
            }
            catch (IOException e) {
                LOG.error("Failed to remove corresponding log file of operation: {}", (Object)OperationLog.this.operationName, (Object)e);
            }
        }

        private void resetIn() {
            IOUtils.closeStream((Closeable)this.in);
            this.in = null;
        }

        private List<String> readResults(int nLines) throws SQLException {
            int readCount;
            ArrayList<String> logs = new ArrayList<String>();
            int n = readCount = nLines <= 0 ? Integer.MAX_VALUE : nLines;
            if (this.in == null) {
                try {
                    this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));
                    if (OperationLog.this.isShortLogs) {
                        logs.add("Reading log file: " + this.file);
                        --readCount;
                    }
                }
                catch (FileNotFoundException e) {
                    return Collections.emptyList();
                }
            }
            try {
                while (readCount > 0) {
                    String line = this.in.readLine();
                    --readCount;
                    boolean added = CollectionUtils.addIgnoreNull(logs, (Object)line);
                    if (added) continue;
                    break;
                }
            }
            catch (IOException e) {
                if (this.isRemoved) {
                    throw new SQLException("The operation has been closed and its log file " + this.file.getAbsolutePath() + " will be removed", e);
                }
                throw new SQLException("Reading operation log file encountered an exception", e);
            }
            return logs;
        }
    }

    public static enum LoggingLevel {
        NONE,
        EXECUTION,
        PERFORMANCE,
        VERBOSE,
        UNKNOWN;

    }
}

