/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.txn.compactor.CompactionQueryBuilder;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionQueryBuilderForMinor
extends CompactionQueryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompactionQueryBuilderForMinor.class.getName());

    CompactionQueryBuilderForMinor() {
        super(CompactionType.MINOR, false);
    }

    @Override
    protected void buildSelectClauseForInsert(StringBuilder query) {
        query.append("`operation`, `originalTransaction`, `bucket`, `rowId`, `currentTransaction`, `row`");
    }

    @Override
    protected void buildWhereClauseForInsert(StringBuilder query) {
        long[] invalidWriteIds;
        if (this.validWriteIdList != null && (invalidWriteIds = this.validWriteIdList.getInvalidWriteIds()).length > 0) {
            query.append(" where `originalTransaction` not in (").append(StringUtils.join((Object[])ArrayUtils.toObject((long[])invalidWriteIds), (String)",")).append(")");
        }
    }

    @Override
    protected void getDdlForCreate(StringBuilder query) {
        this.defineColumns(query);
        if (this.isPartitioned) {
            query.append(" PARTITIONED BY (`file_name` STRING) ");
        }
        int bucketingVersion = this.getMinorCrudBucketing(query);
        query.append(" stored as orc");
        if (this.location != null) {
            query.append(" LOCATION '").append(HiveStringUtils.escapeHiveCommand((String)this.location)).append("'");
        }
        this.addTblProperties(query, this.isBucketed, bucketingVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMinorCrudBucketing(StringBuilder query) {
        int bucketingVersion = 0;
        if (this.isBucketed && this.sourceTab != null) {
            int numBuckets = 1;
            try {
                Table t = this.getTable();
                numBuckets = Math.max(t.getNumBuckets(), numBuckets);
                bucketingVersion = t.getBucketingVersion();
            }
            catch (HiveException e) {
                LOG.info("Error finding table {}. Minor compaction result will use 0 buckets.", (Object)this.sourceTab.getTableName());
            }
            finally {
                query.append(" clustered by (`bucket`)").append(" sorted by (`originalTransaction`, `bucket`, `rowId`)").append(" into ").append(numBuckets).append(" buckets");
            }
        }
        return bucketingVersion;
    }

    protected Table getTable() throws HiveException {
        return Hive.get().getTable(this.sourceTab.getDbName(), this.sourceTab.getTableName());
    }
}

