/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="array_distinct", value="_FUNC_(array(obj1, obj2,...)) - The function returns an array of the same type as the input array with distinct values.", extended="Example:\n  > SELECT _FUNC_(array('b', 'd', 'd', 'a')) FROM src LIMIT 1;\n  ['b', 'd', 'a']")
public class GenericUDFArrayDistinct
extends AbstractGenericUDFArrayBase {
    public GenericUDFArrayDistinct() {
        super("ARRAY_DISTINCT", 1, 1, ObjectInspector.Category.LIST);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        if (this.arrayOI.getListLength(array) == 0) {
            return Collections.emptyList();
        }
        if (this.arrayOI.getListLength(array) < 0) {
            return null;
        }
        List retArray = ((ListObjectInspector)this.argumentOIs[0]).getList(array);
        return retArray.stream().distinct().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

