/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.hive.common.io.NonSyncByteArrayInputStream;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorInBloomFilterColDynamicValue;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.BloomKFilter;

@VectorizedExpressions(value={VectorInBloomFilterColDynamicValue.class})
@Description(name="in_bloom_filter")
public class GenericUDFInBloomFilter
extends GenericUDF {
    private transient ObjectInspector valObjectInspector;
    private transient ObjectInspector bloomFilterObjectInspector;
    private transient BloomKFilter bloomFilter;
    private transient boolean initializedBloomFilter;
    private transient byte[] scratchBuffer = new byte[79];

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("InBloomFilter requires exactly 2 arguments but got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "The 1st argument must be a primitive type but " + arguments[0].getTypeName() + " was passed");
        }
        if (((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentTypeException(1, "The 2nd argument must be a binary type but " + arguments[1].getTypeName() + " was passed");
        }
        this.valObjectInspector = arguments[0];
        this.bloomFilterObjectInspector = arguments[1];
        assert (this.bloomFilterObjectInspector instanceof WritableBinaryObjectInspector);
        this.initializedBloomFilter = false;
        return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("in_bloom_filter", children);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        block21: {
            if (arguments[0].get() == null || arguments[1].get() == null) {
                return null;
            }
            if (this.initializedBloomFilter) break block21;
            NonSyncByteArrayInputStream in = null;
            try {
                BytesWritable bw = (BytesWritable)arguments[1].get();
                byte[] bytes = new byte[bw.getLength()];
                System.arraycopy(bw.getBytes(), 0, bytes, 0, bw.getLength());
                in = new NonSyncByteArrayInputStream(bytes);
                this.bloomFilter = BloomKFilter.deserialize((InputStream)in);
            }
            catch (IOException e) {
                try {
                    throw new HiveException((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(in);
                    throw throwable;
                }
            }
            IOUtils.closeStream((Closeable)in);
            this.initializedBloomFilter = true;
        }
        switch (((PrimitiveObjectInspector)this.valObjectInspector).getTypeInfo().getPrimitiveCategory()) {
            case BOOLEAN: {
                boolean vBoolean = ((BooleanObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testLong(vBoolean ? 1L : 0L);
            }
            case BYTE: {
                byte vByte = ((ByteObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testLong((long)vByte);
            }
            case SHORT: {
                short vShort = ((ShortObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testLong((long)vShort);
            }
            case INT: {
                int vInt = ((IntObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testLong((long)vInt);
            }
            case LONG: {
                long vLong = ((LongObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testLong(vLong);
            }
            case FLOAT: {
                float vFloat = ((FloatObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testDouble((double)vFloat);
            }
            case DOUBLE: {
                double vDouble = ((DoubleObjectInspector)this.valObjectInspector).get(arguments[0].get());
                return this.bloomFilter.testDouble(vDouble);
            }
            case DECIMAL: {
                HiveDecimalWritable vDecimal = ((HiveDecimalObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get());
                int startIdx = vDecimal.toBytes(this.scratchBuffer);
                return this.bloomFilter.testBytes(this.scratchBuffer, startIdx, this.scratchBuffer.length - startIdx);
            }
            case DATE: {
                DateWritableV2 vDate = ((DateObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get());
                return this.bloomFilter.testLong((long)vDate.getDays());
            }
            case TIMESTAMP: {
                Timestamp vTimeStamp = ((TimestampObjectInspector)this.valObjectInspector).getPrimitiveJavaObject(arguments[0].get());
                return this.bloomFilter.testLong(vTimeStamp.toEpochMilli());
            }
            case CHAR: {
                Text vChar = ((HiveCharObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get()).getStrippedValue();
                return this.bloomFilter.testBytes(vChar.getBytes(), 0, vChar.getLength());
            }
            case VARCHAR: {
                Text vVarchar = ((HiveVarcharObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get()).getTextValue();
                return this.bloomFilter.testBytes(vVarchar.getBytes(), 0, vVarchar.getLength());
            }
            case STRING: {
                Text vString = ((StringObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get());
                return this.bloomFilter.testBytes(vString.getBytes(), 0, vString.getLength());
            }
            case BINARY: {
                BytesWritable vBytes = ((BinaryObjectInspector)this.valObjectInspector).getPrimitiveWritableObject(arguments[0].get());
                return this.bloomFilter.testBytes(vBytes.getBytes(), 0, vBytes.getLength());
            }
        }
        throw new UDFArgumentTypeException(0, "Bad primitive category " + ((PrimitiveTypeInfo)this.valObjectInspector).getPrimitiveCategory());
    }
}

