/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.tez.HashableInputSplit;
import org.apache.hadoop.hive.ql.io.PartitionAwareSplit;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.mr.hive.plan.IcebergBucketFunction;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.relocated.com.google.common.primitives.Longs;
import org.apache.iceberg.util.SerializationUtil;

public class HiveIcebergSplit
extends FileSplit
implements IcebergSplitContainer,
HashableInputSplit,
PartitionAwareSplit {
    private IcebergSplit innerSplit;
    private String tableLocation;
    private int numBuckets;

    public HiveIcebergSplit() {
    }

    HiveIcebergSplit(IcebergSplit split, String tableLocation, int numBuckets) {
        this.innerSplit = split;
        this.tableLocation = tableLocation;
        this.numBuckets = numBuckets;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this.innerSplit;
    }

    public long getLength() {
        return this.innerSplit.getLength();
    }

    public String[] getLocations() {
        return this.innerSplit.getLocations();
    }

    public Path getPath() {
        return new Path(this.tableLocation);
    }

    public byte[] getBytesForHash() {
        Object object;
        Collection<FileScanTask> fileScanTasks = this.innerSplit.taskGroup().tasks();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (FileScanTask task : fileScanTasks) {
                baos.write(((DataFile)task.file()).path().toString().getBytes());
                baos.write(Longs.toByteArray(task.start()));
            }
            object = baos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException("Couldn't produce hash input bytes for HiveIcebergSplit: " + this, ioe);
            }
        }
        baos.close();
        return object;
    }

    public OptionalInt getBucketId() {
        StructLike key = this.innerSplit.taskGroup().groupingKey();
        if (key.size() == 0) {
            return OptionalInt.empty();
        }
        int[] bucketIds = IntStream.range(0, key.size()).map(i -> key.get(i, Integer.class)).toArray();
        int hashCode = IcebergBucketFunction.getHashCode(bucketIds);
        return OptionalInt.of(ObjectInspectorUtils.getBucketNumber((int)hashCode, (int)this.numBuckets));
    }

    public long getStart() {
        return 0L;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = SerializationUtil.serializeToBytes(this.tableLocation);
        out.writeInt(bytes.length);
        out.write(bytes);
        out.writeInt(this.numBuckets);
        this.innerSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.tableLocation = (String)SerializationUtil.deserializeFromBytes(bytes);
        this.numBuckets = in.readInt();
        this.innerSplit = new IcebergSplit();
        this.innerSplit.readFields(in);
    }
}

