/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.hive.writer.WriterBuilder;
import org.apache.iceberg.mr.mapred.Container;

class HiveIcebergRecordWriter
extends HiveIcebergWriterBase {
    private final int currentSpecId;

    HiveIcebergRecordWriter(Table table, HiveFileWriterFactory fileWriterFactory, OutputFileFactory dataFileFactory, WriterBuilder.Context context) {
        super(table, HiveIcebergRecordWriter.newDataWriter(table, fileWriterFactory, dataFileFactory, context));
        this.currentSpecId = table.spec().specId();
    }

    public void write(Writable row) throws IOException {
        Record record = (Record)((Container)row).get();
        this.writer.write(record, (PartitionSpec)this.specs.get(this.currentSpecId), this.partition(record, this.currentSpecId));
    }

    @Override
    public FilesForCommit files() {
        List<DataFile> dataFiles = ((DataWriteResult)this.writer.result()).dataFiles();
        return FilesForCommit.onlyData(dataFiles);
    }
}

