/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public interface DataSourceProvider {
    default public DataSource create(Configuration hdpConfig) throws SQLException {
        int maxPoolSize = MetastoreConf.getIntVar((Configuration)hdpConfig, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_POOLING_MAX_CONNECTIONS);
        return this.create(hdpConfig, maxPoolSize);
    }

    public DataSource create(Configuration var1, int var2) throws SQLException;

    public String getPoolingType();

    public static Properties getPrefixedProperties(Configuration hdpConfig, String factoryPrefix) {
        Properties dataSourceProps = new Properties();
        Iterables.filter((Iterable)hdpConfig, entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith(factoryPrefix)).forEach(entry -> dataSourceProps.put(entry.getKey(), entry.getValue()));
        return dataSourceProps;
    }

    public static String getMetastoreJdbcUser(Configuration conf) {
        return MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME);
    }

    public static String getMetastoreJdbcPasswd(Configuration conf) throws SQLException {
        try {
            return MetastoreConf.getPassword((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD);
        }
        catch (IOException err) {
            throw new SQLException("Error getting metastore password", err);
        }
    }

    public static String getMetastoreJdbcDriverUrl(Configuration conf) throws SQLException {
        return MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY);
    }

    public static String getDataSourceName(Configuration conf) {
        return conf.get("metastore.DataSourceProvider.pool.name");
    }

    public static class DataSourceNameConfigurator
    implements Closeable {
        static final String DATA_SOURCE_NAME = "metastore.DataSourceProvider.pool.name";
        private final Configuration configuration;

        public DataSourceNameConfigurator(Configuration conf, String name) {
            this.configuration = conf;
            this.configuration.set(DATA_SOURCE_NAME, name);
        }

        public void resetName(String name) {
            this.configuration.set(DATA_SOURCE_NAME, name);
        }

        @Override
        public void close() {
            this.configuration.unset(DATA_SOURCE_NAME);
        }
    }
}

