SELECT 'Upgrading MetaStore schema from 3.2.0 to 4.0.0-alpha-1' AS MESSAGE;

-- HIVE-19416
ALTER TABLE TBLS ADD WRITE_ID bigint DEFAULT 0;
ALTER TABLE PARTITIONS ADD WRITE_ID bigint DEFAULT 0;


-- HIVE-20793
ALTER TABLE `WM_RESOURCEPLAN` ADD `NS` varchar(128);
UPDATE `WM_RESOURCEPLAN` SET `NS` = 'default' WHERE `NS` IS NULL;
ALTER TABLE `WM_RESOURCEPLAN` DROP KEY `UNIQUE_WM_RESOURCEPLAN`;
ALTER TABLE `WM_RESOURCEPLAN` ADD UNIQUE KEY `UNIQUE_WM_RESOURCEPLAN` (`NAME`, `NS`);

-- HIVE-21063
CREATE UNIQUE INDEX `NOTIFICATION_LOG_EVENT_ID` ON NOTIFICATION_LOG (`EVENT_ID`) USING BTREE;

-- HIVE-21337
ALTER TABLE COLUMNS_V2 MODIFY COMMENT varchar(4000) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL;

-- HIVE-22046 (DEFAULT HIVE)
ALTER TABLE TAB_COL_STATS ADD ENGINE varchar(128);
UPDATE `TAB_COL_STATS` SET `ENGINE` = 'hive' WHERE `ENGINE` IS NULL;
ALTER TABLE PART_COL_STATS ADD ENGINE varchar(128);
UPDATE `PART_COL_STATS` SET `ENGINE` = 'hive' WHERE `ENGINE` IS NULL;

CREATE TABLE SCHEDULED_QUERIES (
	SCHEDULED_QUERY_ID BIGINT NOT NULL,
	CLUSTER_NAMESPACE VARCHAR(256),
	ENABLED BOOLEAN NOT NULL,
	NEXT_EXECUTION INTEGER,
	QUERY VARCHAR(4000),
	SCHEDULE VARCHAR(256),
	SCHEDULE_NAME VARCHAR(256),
	`USER` VARCHAR(256),
	CONSTRAINT SCHEDULED_QUERIES_PK PRIMARY KEY (SCHEDULED_QUERY_ID)
);

CREATE TABLE SCHEDULED_EXECUTIONS (
	SCHEDULED_EXECUTION_ID BIGINT NOT NULL,
	END_TIME INTEGER,
	ERROR_MESSAGE VARCHAR(2000),
	EXECUTOR_QUERY_ID VARCHAR(256),
	LAST_UPDATE_TIME INTEGER,
	SCHEDULED_QUERY_ID BIGINT,
	START_TIME INTEGER,
	STATE VARCHAR(256),
	CONSTRAINT SCHEDULED_EXECUTIONS_PK PRIMARY KEY (SCHEDULED_EXECUTION_ID),
	CONSTRAINT SCHEDULED_EXECUTIONS_SCHQ_FK FOREIGN KEY (SCHEDULED_QUERY_ID) REFERENCES SCHEDULED_QUERIES(SCHEDULED_QUERY_ID) ON DELETE CASCADE
);

CREATE INDEX IDX_SCHEDULED_EXECUTIONS_LAST_UPDATE_TIME ON SCHEDULED_EXECUTIONS (LAST_UPDATE_TIME);
CREATE INDEX IDX_SCHEDULED_EXECUTIONS_SCHEDULED_QUERY_ID ON SCHEDULED_EXECUTIONS (SCHEDULED_QUERY_ID);
CREATE UNIQUE INDEX UNIQUE_SCHEDULED_EXECUTIONS_ID ON SCHEDULED_EXECUTIONS (SCHEDULED_EXECUTION_ID);

-- HIVE-22729
ALTER TABLE COMPACTION_QUEUE ADD CQ_ERROR_MESSAGE mediumtext;
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_ERROR_MESSAGE mediumtext;

-- HIVE-23683
ALTER TABLE COMPACTION_QUEUE ADD CQ_ENQUEUE_TIME bigint;
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_ENQUEUE_TIME bigint;

-- HIVE-22728
ALTER TABLE `KEY_CONSTRAINTS` DROP PRIMARY KEY;
ALTER TABLE `KEY_CONSTRAINTS` ADD CONSTRAINT `CONSTRAINTS_PK` PRIMARY KEY (`PARENT_TBL_ID`, `CONSTRAINT_NAME`, `POSITION`);

-- HIVE-21487
CREATE INDEX COMPLETED_COMPACTIONS_RES ON COMPLETED_COMPACTIONS (CC_DATABASE,CC_TABLE,CC_PARTITION);
-- HIVE-22872
ALTER TABLE SCHEDULED_QUERIES ADD COLUMN ACTIVE_EXECUTION_ID INTEGER ;

-- HIVE-22995
ALTER TABLE DBS ADD COLUMN DB_MANAGED_LOCATION_URI VARCHAR(4000) CHARACTER SET latin1 COLLATE latin1_bin;

-- HIVE-23107
ALTER TABLE COMPACTION_QUEUE ADD CQ_NEXT_TXN_ID bigint;

-- HIVE-23048
INSERT INTO TXNS (TXN_ID, TXN_STATE, TXN_STARTED, TXN_LAST_HEARTBEAT, TXN_USER, TXN_HOST)
  SELECT IFNULL(MAX(CTC_TXNID),0), 'c', 0, 0, '', '' FROM COMPLETED_TXN_COMPONENTS;
ALTER TABLE TXNS ADD COLUMN TXN_ID_TMP BIGINT;
UPDATE TXNS SET TXN_ID_TMP=TXN_ID;
SET FOREIGN_KEY_CHECKS = 0;
ALTER TABLE TXNS MODIFY TXN_ID BIGINT AUTO_INCREMENT;
SET FOREIGN_KEY_CHECKS = 1;
UPDATE TXNS SET TXN_ID=TXN_ID_TMP;
ALTER TABLE TXNS DROP COLUMN TXN_ID_TMP;
SELECT MAX(TXN_ID) + 1 INTO @AutoInc FROM TXNS;
SET @s:=CONCAT('ALTER TABLE TXNS AUTO_INCREMENT=', @AutoInc);
PREPARE stmt FROM @s;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
RENAME TABLE NEXT_TXN_ID TO TXN_LOCK_TBL;
ALTER TABLE TXN_LOCK_TBL CHANGE NTXN_NEXT TXN_LOCK bigint;

-- Create table replication metrics
CREATE TABLE IF NOT EXISTS REPLICATION_METRICS (
  RM_SCHEDULED_EXECUTION_ID bigint NOT NULL,
  RM_POLICY varchar(256) NOT NULL,
  RM_DUMP_EXECUTION_ID bigint NOT NULL,
  RM_METADATA varchar(4000),
  RM_PROGRESS varchar(4000),
  RM_START_TIME integer NOT NULL,
  PRIMARY KEY(RM_SCHEDULED_EXECUTION_ID)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--Increase the size of RM_PROGRESS to accomodate the replication statistics
ALTER TABLE REPLICATION_METRICS MODIFY RM_PROGRESS varchar(24000);

ALTER TABLE REPLICATION_METRICS MODIFY RM_PROGRESS varchar(10000);

ALTER TABLE REPLICATION_METRICS ADD COLUMN `MESSAGE_FORMAT` VARCHAR(16) DEFAULT 'json-0.2';

-- Create indexes for the replication metrics table
CREATE INDEX POLICY_IDX ON REPLICATION_METRICS (RM_POLICY);
CREATE INDEX DUMP_IDX ON REPLICATION_METRICS (RM_DUMP_EXECUTION_ID);

-- Create stored procedure tables
CREATE TABLE STORED_PROCS (
  `SP_ID` BIGINT(20) NOT NULL,
  `CREATE_TIME` INT(11) NOT NULL,
  `DB_ID` BIGINT(20) NOT NULL,
  `NAME` VARCHAR(256) NOT NULL,
  `OWNER_NAME` VARCHAR(128) NOT NULL,
  `SOURCE` LONGTEXT NOT NULL,
  PRIMARY KEY (`SP_ID`)
);

CREATE UNIQUE INDEX UNIQUESTOREDPROC ON STORED_PROCS (NAME, DB_ID);
ALTER TABLE `STORED_PROCS` ADD CONSTRAINT `STOREDPROC_FK1` FOREIGN KEY (`DB_ID`) REFERENCES DBS (`DB_ID`);

-- Create stored procedure tables
CREATE TABLE PACKAGES (
  `PKG_ID` BIGINT(20) NOT NULL,
  `CREATE_TIME` INT(11) NOT NULL,
  `DB_ID` BIGINT(20) NOT NULL,
  `NAME` VARCHAR(256) NOT NULL,
  `OWNER_NAME` VARCHAR(128) NOT NULL,
  `HEADER` LONGTEXT NOT NULL,
  `BODY` LONGTEXT NOT NULL,
  PRIMARY KEY (`PKG_ID`)
);

CREATE UNIQUE INDEX UNIQUEPKG ON PACKAGES (NAME, DB_ID);
ALTER TABLE `PACKAGES` ADD CONSTRAINT `PACKAGES_FK1` FOREIGN KEY (`DB_ID`) REFERENCES DBS (`DB_ID`);

-- HIVE-24291
ALTER TABLE COMPACTION_QUEUE ADD CQ_TXN_ID bigint;

-- HIVE-24275
ALTER TABLE COMPACTION_QUEUE ADD CQ_COMMIT_TIME bigint;

-- HIVE-24770
UPDATE SERDES SET SLIB='org.apache.hadoop.hive.serde2.MultiDelimitSerDe' where SLIB='org.apache.hadoop.hive.contrib.serde2.MultiDelimitSerDe';

-- HIVE-24880
ALTER TABLE COMPACTION_QUEUE ADD CQ_INITIATOR_ID varchar(128);
ALTER TABLE COMPACTION_QUEUE ADD CQ_INITIATOR_VERSION varchar(128);
ALTER TABLE COMPACTION_QUEUE ADD CQ_WORKER_VERSION varchar(128);
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_INITIATOR_ID varchar(128);
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_INITIATOR_VERSION varchar(128);
ALTER TABLE COMPLETED_COMPACTIONS ADD CC_WORKER_VERSION varchar(128);

-- HIVE-24396
-- Create DataConnectors and DataConnector_Params tables
CREATE TABLE `DATACONNECTORS` (
  `NAME` VARCHAR(128) NOT NULL,
  `TYPE` VARCHAR(32) NOT NULL,
  `URL` VARCHAR(4000) NOT NULL,
  `COMMENT` VARCHAR(256),
  `OWNER_NAME` VARCHAR(256),
  `OWNER_TYPE` VARCHAR(10),
  `CREATE_TIME` INT(11) NOT NULL,
  PRIMARY KEY (`NAME`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `DATACONNECTOR_PARAMS` (
  `NAME` VARCHAR(128) NOT NULL,
  `PARAM_KEY` VARCHAR(180) NOT NULL,
  `PARAM_VALUE` VARCHAR(4000),
  PRIMARY KEY (`NAME`, `PARAM_KEY`),
  CONSTRAINT `DATACONNECTOR_NAME_FK1` FOREIGN KEY (`NAME`) REFERENCES `DATACONNECTORS` (`NAME`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `DC_PRIVS` (
  `DC_GRANT_ID` bigint(20) NOT NULL,
  `CREATE_TIME` int(11) NOT NULL,
  `NAME` VARCHAR(128) DEFAULT NULL,
  `GRANT_OPTION` smallint(6) NOT NULL,
  `GRANTOR` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `GRANTOR_TYPE` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `PRINCIPAL_NAME` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `PRINCIPAL_TYPE` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `DC_PRIV` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  `AUTHORIZER` varchar(128) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT NULL,
  PRIMARY KEY (`DC_GRANT_ID`),
  UNIQUE KEY `DCPRIVILEGEINDEX` (`AUTHORIZER`,`NAME`,`PRINCIPAL_NAME`,`PRINCIPAL_TYPE`,`DC_PRIV`,`GRANTOR`,`GRANTOR_TYPE`),
  KEY `DC_PRIVS_N49` (`NAME`),
  CONSTRAINT `DC_PRIVS_FK1` FOREIGN KEY (`NAME`) REFERENCES `DATACONNECTORS` (`NAME`)
  ) ENGINE=InnoDB DEFAULT CHARSET=latin1;

ALTER TABLE `DBS` ADD COLUMN `TYPE` VARCHAR(32) CHARACTER SET latin1 COLLATE latin1_bin DEFAULT 'NATIVE' NOT NULL;
ALTER TABLE `DBS` ADD COLUMN `DATACONNECTOR_NAME` VARCHAR(128) CHARACTER SET latin1 COLLATE latin1_bin;
ALTER TABLE `DBS` ADD COLUMN `REMOTE_DBNAME` VARCHAR(128) CHARACTER SET latin1 COLLATE latin1_bin;
UPDATE `DBS` SET `TYPE` = 'NATIVE' WHERE `TYPE` IS NULL;

-- HIVE-25656
ALTER TABLE `MV_TABLES_USED` ADD COLUMN `INSERTED_COUNT` bigint(20) NOT NULL DEFAULT 0;
ALTER TABLE `MV_TABLES_USED` ADD COLUMN `UPDATED_COUNT` bigint(20) NOT NULL DEFAULT 0;
ALTER TABLE `MV_TABLES_USED` ADD COLUMN `DELETED_COUNT` bigint(20) NOT NULL DEFAULT 0;
ALTER TABLE `MV_TABLES_USED` ADD CONSTRAINT `MV_TABLES_USED_PK` PRIMARY KEY (`TBL_ID`, `MV_CREATION_METADATA_ID`);

-- HIVE-25737
ALTER TABLE COMPACTION_QUEUE ADD CQ_CLEANER_START bigint;

-- HIVE-25842
CREATE TABLE COMPACTION_METRICS_CACHE (
    CMC_DATABASE varchar(128) NOT NULL,
    CMC_TABLE varchar(128) NOT NULL,
    CMC_PARTITION varchar(767),
    CMC_METRIC_TYPE varchar(128) NOT NULL,
    CMC_METRIC_VALUE int NOT NULL,
    CMC_VERSION int NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- HIVE-25993
ALTER TABLE `COMPACTION_QUEUE` ADD COLUMN `CQ_RETRY_RETENTION` bigint NOT NULL DEFAULT 0;

-- HIVE-26049
ALTER TABLE TXN_COMPONENTS MODIFY TC_TABLE varchar(256);
ALTER TABLE HIVE_LOCKS MODIFY HL_TABLE varchar(256);
ALTER TABLE COMPACTION_QUEUE MODIFY CQ_TABLE varchar(256) NOT NULL;
ALTER TABLE COMPLETED_COMPACTIONS MODIFY CC_TABLE varchar(256) NOT NULL;
ALTER TABLE COMPACTION_METRICS_CACHE MODIFY CMC_TABLE varchar(256) NOT NULL;
ALTER TABLE WRITE_SET MODIFY WS_TABLE varchar(256) NOT NULL;
ALTER TABLE TXN_WRITE_NOTIFICATION_LOG MODIFY WNL_TABLE varchar(256) NOT NULL;

-- These lines need to be last.  Insert any changes above.
UPDATE VERSION SET SCHEMA_VERSION='4.0.0-alpha-1', VERSION_COMMENT='Hive release version 4.0.0-alpha-1' where VER_ID=1;
SELECT 'Finished upgrading MetaStore schema from 3.2.0 to 4.0.0-alpha-1' AS MESSAGE;
