/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.message;

import org.apache.hc.core5.http.HeaderElement;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeaderElement;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestBasicHeaderValueFormatter {
    private BasicHeaderValueFormatter formatter;

    TestBasicHeaderValueFormatter() {
    }

    @BeforeEach
    void setup() {
        this.formatter = BasicHeaderValueFormatter.INSTANCE;
    }

    @Test
    void testNVPFormatting() {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", "quote marks (\") must be escaped");
        BasicNameValuePair param5 = new BasicNameValuePair("param", "back slash (\\) must be escaped too");
        BasicNameValuePair param6 = new BasicNameValuePair("param", "values with\tblanks must always be quoted");
        BasicNameValuePair param7 = new BasicNameValuePair("param", null);
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param1, false);
        Assertions.assertEquals((Object)"param=regular_stuff", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param2, false);
        Assertions.assertEquals((Object)"param=\"this\\\\that\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param3, false);
        Assertions.assertEquals((Object)"param=\"this,that\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param4, false);
        Assertions.assertEquals((Object)"param=\"quote marks (\\\") must be escaped\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param5, false);
        Assertions.assertEquals((Object)"param=\"back slash (\\\\) must be escaped too\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param6, false);
        Assertions.assertEquals((Object)"param=\"values with\tblanks must always be quoted\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param7, false);
        Assertions.assertEquals((Object)"param", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param1, true);
        Assertions.assertEquals((Object)"param=\"regular_stuff\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param2, true);
        Assertions.assertEquals((Object)"param=\"this\\\\that\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param3, true);
        Assertions.assertEquals((Object)"param=\"this,that\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param4, true);
        Assertions.assertEquals((Object)"param=\"quote marks (\\\") must be escaped\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param5, true);
        Assertions.assertEquals((Object)"param=\"back slash (\\\\) must be escaped too\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param6, true);
        Assertions.assertEquals((Object)"param=\"values with\tblanks must always be quoted\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatNameValuePair(buf, (NameValuePair)param7, true);
        Assertions.assertEquals((Object)"param", (Object)buf.toString());
    }

    @Test
    void testParamsFormatting() {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        NameValuePair[] params = new NameValuePair[]{param1, param2, param3};
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.clear();
        this.formatter.formatParameters(buf, params, false);
        Assertions.assertEquals((Object)"param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"", (Object)buf.toString());
        buf.clear();
        this.formatter.formatParameters(buf, params, true);
        Assertions.assertEquals((Object)"param=\"regular_stuff\"; param=\"this\\\\that\"; param=\"this,that\"", (Object)buf.toString());
    }

    @Test
    void testHEFormatting() {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", null);
        NameValuePair[] params = new NameValuePair[]{param1, param2, param3, param4};
        BasicHeaderElement element = new BasicHeaderElement("name", "value", params);
        CharArrayBuffer buf = new CharArrayBuffer(64);
        this.formatter.formatHeaderElement(buf, (HeaderElement)element, false);
        Assertions.assertEquals((Object)"name=value; param=regular_stuff; param=\"this\\\\that\"; param=\"this,that\"; param", (Object)buf.toString());
    }

    @Test
    void testElementsFormatting() {
        BasicNameValuePair param1 = new BasicNameValuePair("param", "regular_stuff");
        BasicNameValuePair param2 = new BasicNameValuePair("param", "this\\that");
        BasicNameValuePair param3 = new BasicNameValuePair("param", "this,that");
        BasicNameValuePair param4 = new BasicNameValuePair("param", null);
        BasicHeaderElement element1 = new BasicHeaderElement("name1", "value1", new NameValuePair[]{param1});
        BasicHeaderElement element2 = new BasicHeaderElement("name2", "value2", new NameValuePair[]{param2});
        BasicHeaderElement element3 = new BasicHeaderElement("name3", "value3", new NameValuePair[]{param3});
        BasicHeaderElement element4 = new BasicHeaderElement("name4", "value4", new NameValuePair[]{param4});
        BasicHeaderElement element5 = new BasicHeaderElement("name5", null);
        HeaderElement[] elements = new HeaderElement[]{element1, element2, element3, element4, element5};
        CharArrayBuffer buf = new CharArrayBuffer(64);
        this.formatter.formatElements(buf, elements, false);
        Assertions.assertEquals((Object)"name1=value1; param=regular_stuff, name2=value2; param=\"this\\\\that\", name3=value3; param=\"this,that\", name4=value4; param, name5", (Object)buf.toString());
    }

    @Test
    void testInvalidArguments() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        BasicNameValuePair param = new BasicNameValuePair("param", "regular_stuff");
        NameValuePair[] params = new NameValuePair[]{param};
        BasicHeaderElement element = new BasicHeaderElement("name1", "value1", (NameValuePair[])null);
        HeaderElement[] elements = new HeaderElement[]{element};
        Assertions.assertThrows(NullPointerException.class, () -> this.lambda$testInvalidArguments$0((NameValuePair)param));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatNameValuePair(buf, null, false));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatParameters(null, params, false));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatParameters(buf, null, false));
        Assertions.assertThrows(NullPointerException.class, () -> this.lambda$testInvalidArguments$4((HeaderElement)element));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatHeaderElement(buf, null, false));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatElements(null, elements, false));
        Assertions.assertThrows(NullPointerException.class, () -> this.formatter.formatElements(buf, null, false));
    }

    private /* synthetic */ void lambda$testInvalidArguments$4(HeaderElement element) throws Throwable {
        this.formatter.formatHeaderElement(null, element, false);
    }

    private /* synthetic */ void lambda$testInvalidArguments$0(NameValuePair param) throws Throwable {
        this.formatter.formatNameValuePair(null, param, false);
    }
}

