/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.entity;

import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.WritableByteChannelMock;
import org.apache.hc.core5.http.nio.BasicDataStreamChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http.nio.entity.BasicAsyncEntityProducer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicAsyncEntityProducer {
    TestBasicAsyncEntityProducer() {
    }

    @Test
    void testBinaryContent() throws Exception {
        BasicAsyncEntityProducer producer = new BasicAsyncEntityProducer(new byte[]{97, 98, 99}, ContentType.DEFAULT_BINARY);
        Assertions.assertEquals((long)3L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.DEFAULT_BINARY.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce((DataStreamChannel)streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"abc", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testTextContent() throws Exception {
        BasicAsyncEntityProducer producer = new BasicAsyncEntityProducer((CharSequence)"abc", ContentType.TEXT_PLAIN);
        Assertions.assertEquals((long)3L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
        BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
        producer.produce((DataStreamChannel)streamChannel);
        Assertions.assertFalse((boolean)byteChannel.isOpen());
        Assertions.assertEquals((Object)"abc", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
    }

    @Test
    void testTextContentRepeatable() throws Exception {
        BasicAsyncEntityProducer producer = new BasicAsyncEntityProducer((CharSequence)"abc", ContentType.TEXT_PLAIN);
        Assertions.assertEquals((long)3L, (long)producer.getContentLength());
        Assertions.assertEquals((Object)ContentType.TEXT_PLAIN.toString(), (Object)producer.getContentType());
        Assertions.assertNull((Object)producer.getContentEncoding());
        for (int i = 0; i < 3; ++i) {
            WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
            BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
            producer.produce((DataStreamChannel)streamChannel);
            Assertions.assertFalse((boolean)byteChannel.isOpen());
            Assertions.assertEquals((Object)"abc", (Object)byteChannel.dump(StandardCharsets.US_ASCII));
            producer.releaseResources();
        }
    }

    @Test
    void testTextContentRepeatableUTF() throws Exception {
        String content = "<testtag></testtag>";
        BasicAsyncEntityProducer producer = new BasicAsyncEntityProducer((CharSequence)"<testtag></testtag>", ContentType.TEXT_XML);
        for (int i = 0; i < 3; ++i) {
            WritableByteChannelMock byteChannel = new WritableByteChannelMock(1024);
            BasicDataStreamChannel streamChannel = new BasicDataStreamChannel(byteChannel);
            producer.produce((DataStreamChannel)streamChannel);
            Assertions.assertFalse((boolean)byteChannel.isOpen());
            Assertions.assertEquals((Object)"<testtag></testtag>", (Object)byteChannel.dump(StandardCharsets.UTF_8));
            producer.releaseResources();
        }
    }
}

