/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.eviction.lru;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicy;
import org.apache.ignite.cache.eviction.EvictableEntry;
import org.apache.ignite.cache.eviction.lru.LruEvictionPolicyMBean;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.mxbean.IgniteMBeanAware;
import org.jsr166.ConcurrentLinkedDeque8;

public class LruEvictionPolicy<K, V>
extends AbstractEvictionPolicy<K, V>
implements IgniteMBeanAware {
    private static final long serialVersionUID = 0L;
    private final ConcurrentLinkedDeque8<EvictableEntry<K, V>> queue = new ConcurrentLinkedDeque8();

    public LruEvictionPolicy() {
    }

    public LruEvictionPolicy(int max) {
        this.setMaxSize(max);
    }

    @Override
    public int getCurrentSize() {
        return this.queue.sizex();
    }

    @Override
    public LruEvictionPolicy<K, V> setMaxMemorySize(long maxMemSize) {
        super.setMaxMemorySize(maxMemSize);
        return this;
    }

    @Override
    public LruEvictionPolicy<K, V> setMaxSize(int max) {
        super.setMaxSize(max);
        return this;
    }

    @Override
    public LruEvictionPolicy<K, V> setBatchSize(int batchSize) {
        super.setBatchSize(batchSize);
        return this;
    }

    public Collection<EvictableEntry<K, V>> queue() {
        return Collections.unmodifiableCollection(this.queue);
    }

    @Override
    protected boolean removeMeta(Object meta) {
        return this.queue.unlinkx((ConcurrentLinkedDeque8.Node)meta);
    }

    @Override
    protected boolean touch(EvictableEntry<K, V> entry) {
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> newNode;
        ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>> node = (ConcurrentLinkedDeque8.Node<EvictableEntry<K, V>>)entry.meta();
        if (node == null) {
            do {
                if (entry.putMetaIfAbsent(node = this.queue.offerLastx(entry)) != null) {
                    this.removeMeta(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry.isCached()) {
                    this.removeMeta(node);
                    return false;
                }
                this.memSize.add(entry.size());
                return true;
            } while (entry.removeMeta(node));
            return false;
        }
        if (this.removeMeta(node) && !entry.replaceMeta(node, newNode = this.queue.offerLastx(entry))) {
            this.removeMeta(newNode);
        }
        return false;
    }

    @Override
    protected int shrink0() {
        EvictableEntry<K, V> entry = this.queue.poll();
        if (entry == null) {
            return -1;
        }
        int size = 0;
        ConcurrentLinkedDeque8.Node meta = (ConcurrentLinkedDeque8.Node)entry.removeMeta();
        if (meta != null) {
            size = entry.size();
            this.memSize.add(-size);
            if (!entry.evict()) {
                this.touch(entry);
            }
        }
        return size;
    }

    @Override
    public Object getMBean() {
        return new LruEvictionPolicyMBeanImpl();
    }

    public String toString() {
        return S.toString(LruEvictionPolicy.class, this, "size", (Object)this.getCurrentSize());
    }

    private class LruEvictionPolicyMBeanImpl
    implements LruEvictionPolicyMBean {
        private LruEvictionPolicyMBeanImpl() {
        }

        @Override
        public long getCurrentMemorySize() {
            return LruEvictionPolicy.this.getCurrentMemorySize();
        }

        @Override
        public int getCurrentSize() {
            return LruEvictionPolicy.this.getCurrentSize();
        }

        @Override
        public int getMaxSize() {
            return LruEvictionPolicy.this.getMaxSize();
        }

        @Override
        public void setMaxSize(int max) {
            LruEvictionPolicy.this.setMaxSize(max);
        }

        @Override
        public int getBatchSize() {
            return LruEvictionPolicy.this.getBatchSize();
        }

        @Override
        public void setBatchSize(int batchSize) {
            LruEvictionPolicy.this.setBatchSize(batchSize);
        }

        @Override
        public long getMaxMemorySize() {
            return LruEvictionPolicy.this.getMaxMemorySize();
        }

        @Override
        public void setMaxMemorySize(long maxMemSize) {
            LruEvictionPolicy.this.setMaxMemorySize(maxMemSize);
        }
    }
}

