/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheIndexesListCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(example="nodeId", optional=true, description="Specify node for job execution. If not specified explicitly, node will be chosen by grid")
    private UUID nodeId;
    @Argument(example="grpRegExp", optional=true, description="Regular expression allowing filtering by cache group name")
    private String groupName;
    @Argument(example="cacheRegExp", optional=true, description="Regular expression allowing filtering by cache name")
    private String cacheName;
    @Argument(example="idxNameRegExp", optional=true, description="Regular expression allowing filtering by index name")
    private String indexName;

    private boolean validateRegEx(String name, String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid " + name + " name regex: " + regex);
        }
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        U.writeString(out, this.groupName);
        U.writeString(out, this.cacheName);
        U.writeString(out, this.indexName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.groupName = U.readString(in);
        this.cacheName = U.readString(in);
        this.indexName = U.readString(in);
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public String groupName() {
        return this.groupName;
    }

    public void groupName(String groupName) {
        this.validateRegEx("group", groupName);
        this.groupName = groupName;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public void cacheName(String cacheName) {
        this.validateRegEx("cache", cacheName);
        this.cacheName = cacheName;
    }

    public String indexName() {
        return this.indexName;
    }

    public void indexName(String indexName) {
        this.validateRegEx("index", indexName);
        this.indexName = indexName;
    }
}

