/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisTypeException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.DataStructuresRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisIncrDecrCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.INCR, GridRedisCommand.DECR, GridRedisCommand.INCRBY, GridRedisCommand.DECRBY);
    private static final int DELTA_POS = 2;

    public GridRedisIncrDecrCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd, ctx);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        DataStructuresRequest restReq = new DataStructuresRequest();
        GridRestCacheRequest getReq = new GridRestCacheRequest();
        getReq.clientId(msg.clientId());
        getReq.key(msg.key());
        getReq.command(GridRestCommand.CACHE_GET);
        getReq.cacheName(msg.cacheName());
        GridRestResponse getResp = this.hnd.handle(getReq);
        if (getResp.getResponse() == null) {
            restReq.initial(0L);
        } else {
            if (getResp.getResponse() instanceof String) {
                long init;
                try {
                    init = Long.parseLong((String)getResp.getResponse());
                    restReq.initial(init);
                }
                catch (Exception e) {
                    U.error(this.log, "An initial value must be numeric and in range", e);
                    throw new GridRedisGenericException("An initial value must be numeric and in range");
                }
                if (init == Long.MAX_VALUE && (msg.command() == GridRedisCommand.INCR || msg.command() == GridRedisCommand.INCRBY) || init == Long.MIN_VALUE && (msg.command() == GridRedisCommand.DECR || msg.command() == GridRedisCommand.DECRBY)) {
                    throw new GridRedisGenericException("Increment or decrement would overflow");
                }
            } else {
                throw new GridRedisTypeException("Operation against a key holding the wrong kind of value");
            }
            GridRestCacheRequest rmReq = new GridRestCacheRequest();
            rmReq.clientId(msg.clientId());
            rmReq.key(msg.key());
            rmReq.command(GridRestCommand.CACHE_REMOVE);
            rmReq.cacheName(msg.cacheName());
            Object rmResp = this.hnd.handle(rmReq).getResponse();
            if (rmResp == null || !((Boolean)rmResp).booleanValue()) {
                throw new GridRedisGenericException("Cannot incr/decr on the non-atomiclong key");
            }
        }
        restReq.clientId(msg.clientId());
        restReq.key(msg.key());
        restReq.delta(1L);
        if (msg.messageSize() > 2) {
            try {
                Long delta = Long.valueOf(msg.aux(2));
                GridRedisIncrDecrCommandHandler.safeAdd(restReq.initial(), delta);
                restReq.delta(delta);
            }
            catch (ArithmeticException | NumberFormatException e) {
                U.error(this.log, "An increment value must be numeric and in range", e);
                throw new GridRedisGenericException("An increment value must be numeric and in range");
            }
        }
        switch (msg.command()) {
            case INCR: 
            case INCRBY: {
                restReq.command(GridRestCommand.ATOMIC_INCREMENT);
                break;
            }
            case DECR: 
            case DECRBY: {
                restReq.command(GridRestCommand.ATOMIC_DECREMENT);
                break;
            }
            default: {
                assert (false) : "Unexpected command received";
                break;
            }
        }
        return restReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            return GridRedisProtocolParser.toGenericError("Failed to increment");
        }
        if (restRes.getResponse() instanceof Long && (Long)restRes.getResponse() <= Long.MAX_VALUE) {
            return GridRedisProtocolParser.toInteger(String.valueOf(restRes.getResponse()));
        }
        return GridRedisProtocolParser.toTypeError("Value is non-numeric or out of range");
    }

    private static long safeAdd(long left, long right) {
        if (right > 0L ? left > Long.MAX_VALUE - right : left < Long.MIN_VALUE - right) {
            throw new ArithmeticException("Long overflow");
        }
        return left + right;
    }
}

