/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNode;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ExecutionPlan {
    private final AffinityTopologyVersion ver;
    private final ImmutableList<Fragment> fragments;
    private final ImmutableList<PartitionNode> partNodes;

    ExecutionPlan(AffinityTopologyVersion ver, List<Fragment> fragments, List<PartitionNode> partNodes) {
        this.ver = ver;
        this.fragments = ImmutableList.copyOf(fragments);
        this.partNodes = ImmutableList.copyOf(partNodes);
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.ver;
    }

    public List<Fragment> fragments() {
        return this.fragments;
    }

    public List<PartitionNode> partitionNodes() {
        return this.partNodes;
    }

    public FragmentMapping mapping(Fragment fragment) {
        return fragment.mapping();
    }

    public ColocationGroup target(Fragment fragment) {
        if (fragment.rootFragment()) {
            return null;
        }
        IgniteSender snd = (IgniteSender)fragment.root();
        return this.mapping(snd.targetFragmentId()).findGroup(snd.exchangeId());
    }

    public Map<Long, List<UUID>> remotes(Fragment fragment) {
        List<IgniteReceiver> remotes = fragment.remotes();
        if (F.isEmpty(remotes)) {
            return null;
        }
        HashMap res = U.newHashMap((int)remotes.size());
        for (IgniteReceiver remote : remotes) {
            res.put(remote.exchangeId(), this.mapping(remote.sourceFragmentId()).nodeIds());
        }
        return res;
    }

    private FragmentMapping mapping(long fragmentId) {
        return this.fragments().stream().filter(f -> f.fragmentId() == fragmentId).findAny().orElseThrow(() -> new IllegalStateException("Cannot find fragment with given ID. [fragmentId=" + fragmentId + ", fragments=" + this.fragments() + "]")).mapping();
    }
}

