/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.IgniteIntIterator;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public class IgniteIntList
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private int[] arr;
    private int idx;

    public IgniteIntList() {
    }

    public IgniteIntList(int size) {
        this.arr = new int[size];
    }

    public IgniteIntList(int[] arr) {
        this.arr = arr;
        this.idx = arr.length;
    }

    public static IgniteIntList asList(int ... vals) {
        if (ArrayUtils.nullOrEmpty(vals)) {
            return new IgniteIntList();
        }
        return new IgniteIntList(vals);
    }

    private IgniteIntList(int[] arr, int size) {
        this.arr = arr;
        this.idx = size;
    }

    public IgniteIntList copy() {
        if (this.idx == 0) {
            return new IgniteIntList();
        }
        return new IgniteIntList(Arrays.copyOf(this.arr, this.idx));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteIntList)) {
            return false;
        }
        IgniteIntList that = (IgniteIntList)o;
        if (this.idx != that.idx) {
            return false;
        }
        if (this.idx == 0 || this.arr == that.arr) {
            return true;
        }
        for (int i = 0; i < this.idx; ++i) {
            if (this.arr[i] == that.arr[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int res = 1;
        for (int i = 0; i < this.idx; ++i) {
            int element = this.arr[i];
            res = 31 * res + element;
        }
        return res;
    }

    public void addAll(IgniteIntList l) {
        int len;
        assert (l != null);
        if (l.isEmpty()) {
            return;
        }
        if (this.arr == null) {
            this.arr = new int[4];
        }
        for (len = this.arr.length; len < this.idx + l.size(); len <<= 1) {
        }
        this.arr = Arrays.copyOf(this.arr, len);
        System.arraycopy(l.arr, 0, this.arr, this.idx, l.size());
        this.idx += l.size();
    }

    public static IgniteIntList addAll(@Nullable IgniteIntList to, IgniteIntList from) {
        if (to == null) {
            IgniteIntList res = new IgniteIntList(from.size());
            res.addAll(from);
            return res;
        }
        to.addAll(from);
        return to;
    }

    public void add(int x) {
        if (this.arr == null) {
            this.arr = new int[4];
        } else if (this.arr.length == this.idx) {
            this.arr = Arrays.copyOf(this.arr, this.arr.length << 1);
        }
        this.arr[this.idx++] = x;
    }

    public void clear() {
        this.idx = 0;
    }

    public int last() {
        return this.arr[this.idx - 1];
    }

    public int remove() throws NoSuchElementException {
        if (this.idx == 0) {
            throw new NoSuchElementException();
        }
        return this.arr[--this.idx];
    }

    public IgniteIntList copyWithout(IgniteIntList l) {
        assert (l != null);
        if (this.idx == 0) {
            return new IgniteIntList();
        }
        if (l.idx == 0) {
            return new IgniteIntList(Arrays.copyOf(this.arr, this.idx));
        }
        int[] newArr = Arrays.copyOf(this.arr, this.idx);
        int newIdx = this.idx;
        for (int i = 0; i < l.size(); ++i) {
            int rmVal = l.get(i);
            for (int j = 0; j < newIdx; ++j) {
                if (newArr[j] != rmVal) continue;
                while (newIdx > 0 && newArr[newIdx - 1] == rmVal) {
                    --newIdx;
                }
                if (newIdx <= 0) continue;
                newArr[j] = newArr[newIdx - 1];
                --newIdx;
            }
        }
        return new IgniteIntList(newArr, newIdx);
    }

    public int get(int i) {
        assert (i < this.idx);
        return this.arr[i];
    }

    public int size() {
        return this.idx;
    }

    public boolean isEmpty() {
        return this.idx == 0;
    }

    public boolean contains(int l) {
        for (int i = 0; i < this.idx; ++i) {
            if (this.arr[i] != l) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(IgniteIntList l) {
        for (int i = 0; i < l.size(); ++i) {
            if (this.contains(l.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean distinct() {
        for (int i = 0; i < this.idx; ++i) {
            for (int j = i + 1; j < this.idx; ++j) {
                if (this.arr[i] != this.arr[j]) continue;
                return false;
            }
        }
        return true;
    }

    public void truncate(int size, boolean last) {
        assert (size >= 0 && size <= this.idx);
        if (size == this.idx) {
            return;
        }
        if (!last && this.idx != 0 && size != 0) {
            System.arraycopy(this.arr, this.idx - size, this.arr, 0, size);
        }
        this.idx = size;
    }

    public int removeIndex(int i) {
        assert (i < this.idx) : i;
        int res = this.arr[i];
        if (i == this.idx - 1) {
            this.idx = i;
        } else {
            System.arraycopy(this.arr, i + 1, this.arr, i, this.idx - i - 1);
            --this.idx;
        }
        return res;
    }

    public int removeValue(int startIdx, int val) {
        assert (startIdx >= 0);
        for (int i = startIdx; i < this.idx; ++i) {
            if (this.arr[i] != val) continue;
            this.removeIndex(i);
            return i;
        }
        return -1;
    }

    public int replaceValue(int startIdx, int oldVal, int newVal) {
        for (int i = startIdx; i < this.idx; ++i) {
            if (this.arr[i] != oldVal) continue;
            this.arr[i] = newVal;
            return i;
        }
        return -1;
    }

    public int[] array() {
        int[] res = new int[this.idx];
        System.arraycopy(this.arr, 0, res, 0, this.idx);
        return res;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.idx);
        for (int i = 0; i < this.idx; ++i) {
            out.writeInt(this.arr[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.idx = in.readInt();
        this.arr = new int[this.idx];
        for (int i = 0; i < this.idx; ++i) {
            this.arr[i] = in.readInt();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < this.idx; ++i) {
            if (i != 0) {
                b.append(',');
            }
            b.append(this.arr[i]);
        }
        b.append(']');
        return b.toString();
    }

    @Nullable
    public static IgniteIntList readFrom(DataInput in) throws IOException {
        int idx = in.readInt();
        if (idx == -1) {
            return null;
        }
        int[] arr = new int[idx];
        for (int i = 0; i < idx; ++i) {
            arr[i] = in.readInt();
        }
        return new IgniteIntList(arr);
    }

    public static void writeTo(DataOutput out, @Nullable IgniteIntList list) throws IOException {
        out.writeInt(list != null ? list.idx : -1);
        if (list != null) {
            for (int i = 0; i < list.idx; ++i) {
                out.writeInt(list.arr[i]);
            }
        }
    }

    public IgniteIntList sort() {
        if (this.idx > 1) {
            Arrays.sort(this.arr, 0, this.idx);
        }
        return this;
    }

    public void pop(int cnt) {
        assert (cnt >= 0) : cnt;
        this.idx = this.idx < cnt ? 0 : (this.idx -= cnt);
    }

    public IgniteIntIterator iterator() {
        return new IgniteIntIterator(){
            int cur = 0;

            @Override
            public boolean hasNext() {
                return this.cur < IgniteIntList.this.idx;
            }

            @Override
            public int next() {
                return IgniteIntList.this.arr[this.cur++];
            }
        };
    }
}

