/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequest;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequestBuilder;
import org.apache.ignite.internal.tx.message.TxFinishReplicaRequestSerializer;

public class TxFinishReplicaRequestImpl
implements TxFinishReplicaRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final boolean commit;
    @IgniteToStringInclude
    private final TablePartitionIdMessage commitPartitionId;
    @IgniteToStringInclude
    private final HybridTimestamp commitTimestamp;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final Map<TablePartitionIdMessage, String> groups;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private TxFinishReplicaRequestImpl(boolean commit, TablePartitionIdMessage commitPartitionId, HybridTimestamp commitTimestamp, Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, Map<TablePartitionIdMessage, String> groups, HybridTimestamp timestamp, UUID txId) {
        this.commit = commit;
        this.commitPartitionId = commitPartitionId;
        this.commitTimestamp = commitTimestamp;
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.groups = groups;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public boolean commit() {
        return this.commit;
    }

    @Override
    public TablePartitionIdMessage commitPartitionId() {
        return this.commitPartitionId;
    }

    @Override
    public HybridTimestamp commitTimestamp() {
        return this.commitTimestamp;
    }

    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public Map<TablePartitionIdMessage, String> groups() {
        return this.groups;
    }

    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TxFinishReplicaRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxFinishReplicaRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxFinishReplicaRequestImpl otherMessage = (TxFinishReplicaRequestImpl)other;
        return Objects.equals(this.commitPartitionId, otherMessage.commitPartitionId) && Objects.equals(this.commitTimestamp, otherMessage.commitTimestamp) && Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.groups, otherMessage.groups) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId) && this.commit == otherMessage.commit;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.commit, this.commitPartitionId, this.commitTimestamp, this.enlistmentConsistencyToken, this.groupId, this.groups, this.timestamp, this.txId);
        return result;
    }

    public TxFinishReplicaRequestImpl clone() {
        try {
            return (TxFinishReplicaRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxFinishReplicaRequestBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, (Object)marshaller);
        }
        if (this.groups != null) {
            Set<Map.Entry<TablePartitionIdMessage, String>> groupsEntrySet = this.groups.entrySet();
            for (Map.Entry<TablePartitionIdMessage, String> entry : groupsEntrySet) {
                TablePartitionIdMessage key = entry.getKey();
                String value = entry.getValue();
                if (key == null) continue;
                key.prepareMarshal(usedDescriptors, (Object)marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.commitPartitionId != null) {
            this.commitPartitionId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.groupId != null) {
            this.groupId.unmarshal((Object)marshaller, descriptorsObj);
        }
        if (this.groups != null) {
            Set<Map.Entry<TablePartitionIdMessage, String>> groupsEntrySet = this.groups.entrySet();
            for (Map.Entry<TablePartitionIdMessage, String> entry : groupsEntrySet) {
                TablePartitionIdMessage key = entry.getKey();
                String value = entry.getValue();
                if (key == null) continue;
                key.unmarshal((Object)marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements TxFinishReplicaRequestBuilder {
        private boolean commit;
        private TablePartitionIdMessage commitPartitionId;
        private HybridTimestamp commitTimestamp;
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private Map<TablePartitionIdMessage, String> groups;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TxFinishReplicaRequestBuilder commit(boolean commit) {
            this.commit = commit;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder commitPartitionId(TablePartitionIdMessage commitPartitionId) {
            Objects.requireNonNull(commitPartitionId, "commitPartitionId is not marked @Nullable");
            this.commitPartitionId = commitPartitionId;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder commitTimestamp(HybridTimestamp commitTimestamp) {
            this.commitTimestamp = commitTimestamp;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder groups(Map<TablePartitionIdMessage, String> groups) {
            Objects.requireNonNull(groups, "groups is not marked @Nullable");
            this.groups = groups;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TxFinishReplicaRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public boolean commit() {
            return this.commit;
        }

        @Override
        public TablePartitionIdMessage commitPartitionId() {
            return this.commitPartitionId;
        }

        @Override
        public HybridTimestamp commitTimestamp() {
            return this.commitTimestamp;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public Map<TablePartitionIdMessage, String> groups() {
            return this.groups;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TxFinishReplicaRequest build() {
            return new TxFinishReplicaRequestImpl(this.commit, Objects.requireNonNull(this.commitPartitionId, "commitPartitionId is not marked @Nullable"), this.commitTimestamp, Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.groups, "groups is not marked @Nullable"), this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }
    }
}

