/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.schema.BinaryTuple;
import org.apache.ignite.internal.storage.index.StorageSortedIndexDescriptor;
import org.apache.ignite.internal.storage.util.StorageUtils;
import org.rocksdb.AbstractComparator;
import org.rocksdb.ComparatorOptions;

public class RocksDbBinaryTupleComparator
extends AbstractComparator {
    private final Comparator<ByteBuffer> comparator;
    private final ComparatorOptions options;

    public RocksDbBinaryTupleComparator(List<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns) {
        this(columns, new ComparatorOptions());
    }

    private RocksDbBinaryTupleComparator(List<StorageSortedIndexDescriptor.StorageSortedIndexColumnDescriptor> columns, ComparatorOptions options) {
        super(options);
        this.options = options;
        this.comparator = StorageUtils.binaryTupleComparator(columns);
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public int compare(ByteBuffer a, ByteBuffer b) {
        ByteBuffer secondBinaryTupleBuffer;
        int compareTableIds = Integer.compareUnsigned(a.getInt(), b.getInt());
        if (compareTableIds != 0) {
            return compareTableIds;
        }
        if (!RocksDbBinaryTupleComparator.bothHasRemaining(a, b)) {
            return Boolean.compare(a.hasRemaining(), b.hasRemaining());
        }
        int compareIndexIds = Integer.compareUnsigned(a.getInt(), b.getInt());
        if (compareIndexIds != 0) {
            return compareIndexIds;
        }
        if (!RocksDbBinaryTupleComparator.bothHasRemaining(a, b)) {
            return Boolean.compare(a.hasRemaining(), b.hasRemaining());
        }
        int comparePartitionIds = Short.compareUnsigned(a.getShort(), b.getShort());
        if (comparePartitionIds != 0) {
            return comparePartitionIds;
        }
        if (!RocksDbBinaryTupleComparator.bothHasRemaining(a, b)) {
            return Boolean.compare(a.hasRemaining(), b.hasRemaining());
        }
        ByteBuffer firstBinaryTupleBuffer = a.slice().order(BinaryTuple.ORDER);
        int compareTuples = this.comparator.compare(firstBinaryTupleBuffer, secondBinaryTupleBuffer = b.slice().order(BinaryTuple.ORDER));
        return compareTuples == 0 ? RocksDbBinaryTupleComparator.compareRowIds(a, b) : compareTuples;
    }

    private static boolean bothHasRemaining(ByteBuffer a, ByteBuffer b) {
        return a.hasRemaining() && b.hasRemaining();
    }

    private static int compareRowIds(ByteBuffer a, ByteBuffer b) {
        long secondMostSignBits;
        long firstMostSignBits = a.getLong(a.limit() - 16);
        int compare = Long.compare(firstMostSignBits, secondMostSignBits = b.getLong(b.limit() - 16));
        if (compare != 0) {
            return compare;
        }
        long firstLeastSignBits = a.getLong(a.limit() - 8);
        long secondLeastSignBits = b.getLong(b.limit() - 8);
        return Long.compare(firstLeastSignBits, secondLeastSignBits);
    }

    public void close() {
        super.close();
        this.options.close();
    }
}

