/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rex;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.ignite.internal.sql.engine.type.IgniteCustomType;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.jetbrains.annotations.Nullable;

public class IgniteRexBuilder
extends RexBuilder {
    public static final IgniteRexBuilder INSTANCE = new IgniteRexBuilder((RelDataTypeFactory)IgniteTypeFactory.INSTANCE);

    private IgniteRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    public RexNode makeLiteral(@Nullable Object value, RelDataType type, boolean allowCast, boolean trim) {
        if (value != null && type instanceof IgniteCustomType) {
            assert (value instanceof Comparable) : "Not comparable IgniteCustomType:" + String.valueOf(type) + ". value: " + String.valueOf(value);
            return this.makeLiteral((Comparable)value, type, type.getSqlTypeName());
        }
        if (value != null) {
            if (type.getSqlTypeName() == SqlTypeName.CHAR) {
                NlsString string;
                if (type.isNullable()) {
                    RelDataType typeNotNull = this.typeFactory.createTypeWithNullability(type, false);
                    if (allowCast) {
                        RexNode literalNotNull = this.makeLiteral(value, typeNotNull, allowCast);
                        return this.makeAbstractCast(type, literalNotNull, false);
                    }
                }
                if (value instanceof NlsString) {
                    string = (NlsString)value;
                } else {
                    assert (type.getCharset() != null) : String.valueOf(type) + ".getCharset() must not be null";
                    string = new NlsString((String)value, type.getCharset().name(), type.getCollation());
                }
                return this.makeCharLiteral(string);
            }
            if (value instanceof String) {
                if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
                    value = Double.parseDouble((String)value);
                } else if (type.getSqlTypeName() == SqlTypeName.REAL || type.getSqlTypeName() == SqlTypeName.FLOAT) {
                    value = Float.valueOf(Float.parseFloat((String)value));
                }
            }
        }
        return super.makeLiteral(value, type, allowCast, trim);
    }
}

