/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteSingleRowReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;

class ReadWriteSingleRowReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteSingleRowReplicaRequest> {
    private final ReadWriteSingleRowReplicaRequestBuilder msg;

    ReadWriteSingleRowReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteSingleRowReplicaRequest();
    }

    public Class<ReadWriteSingleRowReplicaRequest> klass() {
        return ReadWriteSingleRowReplicaRequest.class;
    }

    public ReadWriteSingleRowReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<ByteBuffer> tmp = reader.readByteBuffer("binaryTuple");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.binaryTuple((ByteBuffer)tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<ByteBuffer> tmp = (TablePartitionIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((TablePartitionIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<ByteBuffer> tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.coordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<ByteBuffer> tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 4: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 5: {
                ReplicationGroupIdMessage tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId(tmp);
                reader.incrementState();
            }
            case 6: {
                int ordinalShifted = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType tmp = ordinalShifted == 0 ? null : RequestType.fromOrdinal(ordinalShifted - 1);
                this.msg.requestType(tmp);
                reader.incrementState();
            }
            case 7: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 8: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 9: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteSingleRowReplicaRequest.class);
    }
}

