/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.queue;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.util.IgniteUtils;

public class ComputeThreadPoolExecutor {
    private final BlockingQueue<Runnable> workQueue;
    private final ThreadPoolExecutor executor;

    ComputeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this.workQueue = workQueue;
        this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public boolean remove(Runnable task) {
        return this.executor.remove(task);
    }

    public boolean removeFromQueue(Runnable task) {
        return this.workQueue.remove(task);
    }

    public void shutdown(long stopTimeout) {
        IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.executor, (long)stopTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

