/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.storage.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.raft.configuration.LogStorageBudgetView;
import org.apache.ignite.internal.raft.storage.LogStorageFactory;
import org.apache.ignite.internal.raft.storage.impl.LogStorageBudget;
import org.apache.ignite.internal.raft.storage.impl.LogStorageException;
import org.apache.ignite.internal.raft.storage.impl.OnHeapLogs;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSharedLogStorageUtils;
import org.apache.ignite.internal.raft.storage.impl.RocksDbSpillout;
import org.apache.ignite.internal.raft.storage.impl.VolatileLogStorage;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.raft.jraft.core.LogStorageBudgetFactory;
import org.apache.ignite.raft.jraft.core.LogStorageBudgetsModule;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.LogStorage;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class VolatileLogStorageFactory
implements LogStorageFactory {
    private final LogStorageBudgetView logStorageBudgetConfig;
    private final RocksDB db;
    private final ColumnFamilyHandle columnFamily;
    private final Executor executor;
    private final Map<String, LogStorageBudgetFactory> budgetFactories;

    public VolatileLogStorageFactory(LogStorageBudgetView logStorageBudgetConfig, RocksDB db, ColumnFamilyHandle columnFamily, Executor executor) {
        this.logStorageBudgetConfig = logStorageBudgetConfig;
        this.db = db;
        this.columnFamily = columnFamily;
        this.executor = executor;
        HashMap<String, LogStorageBudgetFactory> factories = new HashMap<String, LogStorageBudgetFactory>();
        ClassLoader serviceClassLoader = Thread.currentThread().getContextClassLoader();
        for (LogStorageBudgetsModule module : ServiceLoader.load(LogStorageBudgetsModule.class, serviceClassLoader)) {
            Map<String, LogStorageBudgetFactory> factoriesFromModule = module.budgetFactories();
            this.checkForBudgetNameClashes(factories.keySet(), factoriesFromModule.keySet());
            factories.putAll(factoriesFromModule);
        }
        this.budgetFactories = Map.copyOf(factories);
    }

    private void checkForBudgetNameClashes(Set<String> names1, Set<String> names2) {
        HashSet<String> intersection = new HashSet<String>(names1);
        intersection.retainAll(names2);
        if (!intersection.isEmpty()) {
            throw new IgniteInternalException(String.format("Storage budget '%s' is provided by more than one module", intersection.iterator().next()));
        }
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public LogStorage createLogStorage(String raftNodeStorageId, RaftOptions raftOptions) {
        RocksDbSpillout spiltOnDisk = new RocksDbSpillout(this.db, this.columnFamily, raftNodeStorageId, this.executor);
        return new VolatileLogStorage(this.createLogStorageBudget(), new OnHeapLogs(), spiltOnDisk);
    }

    @Override
    public void destroyLogStorage(String uri) {
        try {
            RocksDbSpillout.deleteAllEntriesBetween(this.db, this.columnFamily, RocksDbSharedLogStorageUtils.raftNodeStorageStartPrefix(uri), RocksDbSharedLogStorageUtils.raftNodeStorageEndPrefix(uri));
        }
        catch (RocksDBException e) {
            throw new LogStorageException("Fail to destroy the log storage spillout for " + uri, e);
        }
    }

    @Override
    public Set<String> raftNodeStorageIdsOnDisk() {
        return Set.of();
    }

    private LogStorageBudget createLogStorageBudget() {
        return this.newBudget(this.logStorageBudgetConfig);
    }

    private LogStorageBudget newBudget(LogStorageBudgetView logStorageBudgetConfig) {
        LogStorageBudgetFactory factory = this.budgetFactories.get(logStorageBudgetConfig.name());
        if (factory == null) {
            throw new IgniteInternalException("Cannot find a log storage budget by name '" + logStorageBudgetConfig.name() + "'");
        }
        return factory.create(logStorageBudgetConfig);
    }

    public void sync() {
    }
}

