/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.cli.exceptions;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite3.internal.cli.core.exception.ExceptionHandlers;
import org.apache.ignite3.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite3.internal.cli.core.style.component.ErrorUiComponent;
import org.apache.ignite3.internal.cli.core.style.element.UiElement;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanInitializationException;

public class ErrorLoadingInputConfigurationHandlers {
    public static ExceptionHandlers create() {
        ExceptionHandlers handlers = new ExceptionHandlers();
        handlers.addExceptionHandler(new Base<BeanInitializationException>(BeanInitializationException.class));
        handlers.addExceptionHandler(new Base<BeanDefinitionStoreException>(BeanDefinitionStoreException.class));
        return handlers;
    }

    private static class Base<T extends Throwable>
    implements ExceptionHandler<T> {
        private final Class<T> klass;

        Base(Class<T> klass) {
            this.klass = klass;
        }

        public int handle(ExceptionWriter writer, T e) {
            Throwable rootCause = ExceptionUtils.getRootCause(e);
            ErrorUiComponent.ErrorComponentBuilder errorUiBuilder = ErrorUiComponent.builder().header("Error loading input configurations", new UiElement[0]).details(rootCause.getMessage(), new UiElement[0]);
            writer.write(errorUiBuilder.build().render());
            return 1;
        }

        public Class<T> applicableException() {
            return this.klass;
        }
    }
}

