/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.storage.serialization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite3.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite3.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite3.internal.util.io.IgniteUnsafeDataInput;

public class CatalogObjectDataInput
extends IgniteUnsafeDataInput {
    private final CatalogEntrySerializerProvider serializers;

    public CatalogObjectDataInput(CatalogEntrySerializerProvider serializers, byte[] bytes) {
        super(bytes);
        this.serializers = serializers;
    }

    public MarshallableEntry readEntry() throws IOException {
        short typeId = this.readShort();
        int entryVersion = this.readVarIntAsInt();
        return (MarshallableEntry)this.serializers.get(entryVersion, typeId).readFrom(this);
    }

    public <T extends MarshallableEntry> T readEntry(Class<T> type) throws IOException {
        short typeId = this.readShort();
        int entryVersion = this.readVarIntAsInt();
        MarshallableEntry entry = (MarshallableEntry)this.serializers.get(entryVersion, typeId).readFrom(this);
        return (T)((MarshallableEntry)type.cast(entry));
    }

    public <T extends MarshallableEntry> List<T> readEntryList(Class<T> type) throws IOException {
        int size = this.readVarIntAsInt();
        ArrayList<MarshallableEntry> list = new ArrayList<MarshallableEntry>(size);
        for (int i = 0; i < size; ++i) {
            short typeId = this.readShort();
            int entryVersion = this.readVarIntAsInt();
            MarshallableEntry entry = (MarshallableEntry)this.serializers.get(entryVersion, typeId).readFrom(this);
            list.add((MarshallableEntry)type.cast(entry));
        }
        return list;
    }

    public <T extends MarshallableEntry> List<T> readCompactEntryList(Class<T> type) throws IOException {
        int size = this.readVarIntAsInt();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<MarshallableEntry> list = new ArrayList<MarshallableEntry>(size);
        short typeId = this.readShort();
        int entryVersion = this.readVarIntAsInt();
        CatalogObjectSerializer serializer = this.serializers.get(entryVersion, typeId);
        for (int i = 0; i < size; ++i) {
            MarshallableEntry entry = (MarshallableEntry)serializer.readFrom(this);
            list.add((MarshallableEntry)type.cast(entry));
        }
        return list;
    }

    public <C extends Collection<T>, T> C readObjectCollection(ElementReader<T> reader, IntFunction<C> newCollection) throws IOException {
        int size = this.readVarIntAsInt();
        Collection col = (Collection)newCollection.apply(size);
        for (int i = 0; i < size; ++i) {
            T element = reader.read(this);
            col.add(element);
        }
        return (C)col;
    }

    @FunctionalInterface
    public static interface ElementReader<T> {
        public T read(CatalogObjectDataInput var1) throws IOException;
    }
}

