/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.pagememory.persistence;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CompletableFuture;

class PartitionProcessingCounter {
    private static final VarHandle COUNTER;
    private volatile int counter;
    private final CompletableFuture<Void> future = new CompletableFuture();

    PartitionProcessingCounter() {
    }

    void incrementPartitionProcessingCounter() {
        assert (!this.future.isDone());
        int updatedValue = COUNTER.getAndAdd(this, 1) + 1;
        assert (updatedValue > 0) : updatedValue;
    }

    void decrementPartitionProcessingCounter() {
        assert (!this.future.isDone());
        int updatedValue = COUNTER.getAndAdd(this, -1) - 1;
        assert (updatedValue >= 0) : updatedValue;
        if (updatedValue == 0) {
            this.future.complete(null);
        }
    }

    CompletableFuture<Void> future() {
        return this.future;
    }

    static {
        try {
            COUNTER = MethodHandles.lookup().findVarHandle(PartitionProcessingCounter.class, "counter", Integer.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

