/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.MutableInteger;
import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Projections;
import java.util.List;
import java.util.Locale;

public strictfp final class S2CellId
implements Comparable<S2CellId> {
    public static final int FACE_BITS = 3;
    public static final int NUM_FACES = 6;
    public static final int MAX_LEVEL = 30;
    public static final int POS_BITS = 61;
    public static final int MAX_SIZE = 0x40000000;
    public static final long MAX_UNSIGNED = -1L;
    private static final int LOOKUP_BITS = 4;
    private static final int SWAP_MASK = 1;
    private static final int INVERT_MASK = 2;
    private static final int[] LOOKUP_POS = new int[1024];
    private static final int[] LOOKUP_IJ = new int[1024];
    private static final long WRAP_OFFSET = -4611686018427387904L;
    private final long id;
    private static final long[] maxValueDivs;
    private static final int[] maxValueMods;

    public S2CellId(long id) {
        this.id = id;
    }

    public S2CellId() {
        this.id = 0L;
    }

    public static S2CellId none() {
        return new S2CellId();
    }

    public static S2CellId sentinel() {
        return new S2CellId(-1L);
    }

    public static S2CellId fromFacePosLevel(int face, long pos, int level) {
        return new S2CellId(((long)face << 61) + (pos | 1L)).parent(level);
    }

    public static S2CellId fromPoint(S2Point p) {
        int face = S2Projections.xyzToFace(p);
        R2Vector uv = S2Projections.validFaceXyzToUv(face, p);
        int i = S2CellId.stToIJ(S2Projections.uvToST(uv.x()));
        int j = S2CellId.stToIJ(S2Projections.uvToST(uv.y()));
        return S2CellId.fromFaceIJ(face, i, j);
    }

    public static S2CellId fromLatLng(S2LatLng ll) {
        return S2CellId.fromPoint(ll.toPoint());
    }

    public S2Point toPoint() {
        return S2Point.normalize(this.toPointRaw());
    }

    public S2Point toPointRaw() {
        MutableInteger i = new MutableInteger(0);
        MutableInteger j = new MutableInteger(0);
        int face = this.toFaceIJOrientation(i, j, null);
        int delta = this.isLeaf() ? 1 : (((i.intValue() ^ (int)this.id >>> 2) & 1) != 0 ? 2 : 0);
        int si = (i.intValue() << 1) + delta - 0x40000000;
        int ti = (j.intValue() << 1) + delta - 0x40000000;
        return S2CellId.faceSiTiToXYZ(face, si, ti);
    }

    public S2LatLng toLatLng() {
        return new S2LatLng(this.toPointRaw());
    }

    public long id() {
        return this.id;
    }

    public boolean isValid() {
        return this.face() < 6 && (this.lowestOnBit() & 0x1555555555555555L) != 0L;
    }

    public int face() {
        return (int)(this.id >>> 61);
    }

    public long pos() {
        return this.id & 0x1FFFFFFFFFFFFFFFL;
    }

    public int level() {
        if (this.isLeaf()) {
            return 30;
        }
        int x = (int)this.id;
        int level = -1;
        if (x != 0) {
            level += 16;
        } else {
            x = (int)(this.id >>> 32);
        }
        x &= -x;
        if ((x & 0x5555) != 0) {
            level += 8;
        }
        if ((x & 0x550055) != 0) {
            level += 4;
        }
        if ((x & 0x5050505) != 0) {
            level += 2;
        }
        if ((x & 0x11111111) != 0) {
            ++level;
        }
        return level;
    }

    public boolean isLeaf() {
        return ((int)this.id & 1) != 0;
    }

    public boolean isFace() {
        return (this.id & S2CellId.lowestOnBitForLevel(0) - 1L) == 0L;
    }

    public int childPosition(int level) {
        return (int)(this.id >>> 2 * (30 - level) + 1) & 3;
    }

    public S2CellId rangeMin() {
        return new S2CellId(this.id - (this.lowestOnBit() - 1L));
    }

    public S2CellId rangeMax() {
        return new S2CellId(this.id + (this.lowestOnBit() - 1L));
    }

    public boolean contains(S2CellId other) {
        return other.greaterOrEquals(this.rangeMin()) && other.lessOrEquals(this.rangeMax());
    }

    public boolean intersects(S2CellId other) {
        return other.rangeMin().lessOrEquals(this.rangeMax()) && other.rangeMax().greaterOrEquals(this.rangeMin());
    }

    public S2CellId parent() {
        long newLsb = this.lowestOnBit() << 2;
        return new S2CellId(this.id & -newLsb | newLsb);
    }

    public S2CellId parent(int level) {
        long newLsb = S2CellId.lowestOnBitForLevel(level);
        return new S2CellId(this.id & -newLsb | newLsb);
    }

    public S2CellId childBegin() {
        long oldLsb = this.lowestOnBit();
        return new S2CellId(this.id - oldLsb + (oldLsb >>> 2));
    }

    public S2CellId childBegin(int level) {
        return new S2CellId(this.id - this.lowestOnBit() + S2CellId.lowestOnBitForLevel(level));
    }

    public S2CellId childEnd() {
        long oldLsb = this.lowestOnBit();
        return new S2CellId(this.id + oldLsb + (oldLsb >>> 2));
    }

    public S2CellId childEnd(int level) {
        return new S2CellId(this.id + this.lowestOnBit() + S2CellId.lowestOnBitForLevel(level));
    }

    public S2CellId next() {
        return new S2CellId(this.id + (this.lowestOnBit() << 1));
    }

    public S2CellId prev() {
        return new S2CellId(this.id - (this.lowestOnBit() << 1));
    }

    public S2CellId nextWrap() {
        S2CellId n = this.next();
        if (S2CellId.unsignedLongLessThan(n.id, -4611686018427387904L)) {
            return n;
        }
        return new S2CellId(n.id - -4611686018427387904L);
    }

    public S2CellId prevWrap() {
        S2CellId p = this.prev();
        if (p.id < -4611686018427387904L) {
            return p;
        }
        return new S2CellId(p.id + -4611686018427387904L);
    }

    public static S2CellId begin(int level) {
        return S2CellId.fromFacePosLevel(0, 0L, 0).childBegin(level);
    }

    public static S2CellId end(int level) {
        return S2CellId.fromFacePosLevel(5, 0L, 0).childEnd(level);
    }

    public static S2CellId fromToken(String token) {
        if (token == null) {
            throw new NumberFormatException("Null string in S2CellId.fromToken");
        }
        if (token.length() == 0) {
            throw new NumberFormatException("Empty string in S2CellId.fromToken");
        }
        if (token.length() > 16 || "X".equals(token)) {
            return S2CellId.none();
        }
        long value = 0L;
        for (int pos = 0; pos < 16; ++pos) {
            int digit = 0;
            if (pos < token.length()) {
                digit = Character.digit(token.charAt(pos), 16);
                if (digit == -1) {
                    throw new NumberFormatException(token);
                }
                if (S2CellId.overflowInParse(value, digit)) {
                    throw new NumberFormatException("Too large for unsigned long: " + token);
                }
            }
            value = value * 16L + (long)digit;
        }
        return new S2CellId(value);
    }

    public String toToken() {
        if (this.id == 0L) {
            return "X";
        }
        String hex = Long.toHexString(this.id).toLowerCase(Locale.ENGLISH);
        StringBuilder sb = new StringBuilder(16);
        for (int i = hex.length(); i < 16; ++i) {
            sb.append('0');
        }
        sb.append(hex);
        for (int len = 16; len > 0; --len) {
            if (sb.charAt(len - 1) == '0') continue;
            return sb.substring(0, len);
        }
        throw new RuntimeException("Shouldn't make it here");
    }

    private static boolean overflowInParse(long current, int digit) {
        return S2CellId.overflowInParse(current, digit, 10);
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    public void getEdgeNeighbors(S2CellId[] neighbors) {
        MutableInteger i = new MutableInteger(0);
        MutableInteger j = new MutableInteger(0);
        int level = this.level();
        int size = 1 << 30 - level;
        int face = this.toFaceIJOrientation(i, j, null);
        neighbors[0] = S2CellId.fromFaceIJSame(face, i.intValue(), j.intValue() - size, j.intValue() - size >= 0).parent(level);
        neighbors[1] = S2CellId.fromFaceIJSame(face, i.intValue() + size, j.intValue(), i.intValue() + size < 0x40000000).parent(level);
        neighbors[2] = S2CellId.fromFaceIJSame(face, i.intValue(), j.intValue() + size, j.intValue() + size < 0x40000000).parent(level);
        neighbors[3] = S2CellId.fromFaceIJSame(face, i.intValue() - size, j.intValue(), i.intValue() - size >= 0).parent(level);
    }

    public void getVertexNeighbors(int level, List<S2CellId> output) {
        boolean jsame;
        int joffset;
        boolean isame;
        int ioffset;
        MutableInteger i = new MutableInteger(0);
        MutableInteger j = new MutableInteger(0);
        int face = this.toFaceIJOrientation(i, j, null);
        int halfsize = 1 << 30 - (level + 1);
        int size = halfsize << 1;
        if ((i.intValue() & halfsize) != 0) {
            ioffset = size;
            isame = i.intValue() + size < 0x40000000;
        } else {
            ioffset = -size;
            boolean bl = isame = i.intValue() - size >= 0;
        }
        if ((j.intValue() & halfsize) != 0) {
            joffset = size;
            jsame = j.intValue() + size < 0x40000000;
        } else {
            joffset = -size;
            jsame = j.intValue() - size >= 0;
        }
        output.add(this.parent(level));
        output.add(S2CellId.fromFaceIJSame(face, i.intValue() + ioffset, j.intValue(), isame).parent(level));
        output.add(S2CellId.fromFaceIJSame(face, i.intValue(), j.intValue() + joffset, jsame).parent(level));
        if (isame || jsame) {
            output.add(S2CellId.fromFaceIJSame(face, i.intValue() + ioffset, j.intValue() + joffset, isame && jsame).parent(level));
        }
    }

    public void getAllNeighbors(int nbrLevel, List<S2CellId> output) {
        MutableInteger i = new MutableInteger(0);
        MutableInteger j = new MutableInteger(0);
        int face = this.toFaceIJOrientation(i, j, null);
        int size = 1 << 30 - this.level();
        i.setValue(i.intValue() & -size);
        j.setValue(j.intValue() & -size);
        int nbrSize = 1 << 30 - nbrLevel;
        int k = -nbrSize;
        while (true) {
            boolean sameFace;
            if (k < 0) {
                sameFace = j.intValue() + k >= 0;
            } else if (k >= size) {
                sameFace = j.intValue() + k < 0x40000000;
            } else {
                sameFace = true;
                output.add(S2CellId.fromFaceIJSame(face, i.intValue() + k, j.intValue() - nbrSize, j.intValue() - size >= 0).parent(nbrLevel));
                output.add(S2CellId.fromFaceIJSame(face, i.intValue() + k, j.intValue() + size, j.intValue() + size < 0x40000000).parent(nbrLevel));
            }
            output.add(S2CellId.fromFaceIJSame(face, i.intValue() - nbrSize, j.intValue() + k, sameFace && i.intValue() - size >= 0).parent(nbrLevel));
            output.add(S2CellId.fromFaceIJSame(face, i.intValue() + size, j.intValue() + k, sameFace && i.intValue() + size < 0x40000000).parent(nbrLevel));
            if (k >= size) break;
            k += nbrSize;
        }
    }

    public static S2CellId fromFaceIJ(int face, int i, int j) {
        long[] n = new long[]{0L, face << 28};
        int bits = face & 1;
        for (int k = 7; k >= 0; --k) {
            bits = S2CellId.getBits(n, i, j, k, bits);
        }
        S2CellId s = new S2CellId(((n[1] << 32) + n[0] << 1) + 1L);
        return s;
    }

    private static int getBits(long[] n, int i, int j, int k, int bits) {
        int mask = 15;
        bits += (i >> k * 4 & 0xF) << 6;
        bits += (j >> k * 4 & 0xF) << 2;
        bits = LOOKUP_POS[bits];
        int n2 = k >> 2;
        n[n2] = n[n2] | (long)bits >> 2 << (k & 3) * 2 * 4;
        return bits &= 3;
    }

    public int toFaceIJOrientation(MutableInteger pi, MutableInteger pj, MutableInteger orientation) {
        int face = this.face();
        int bits = face & 1;
        for (int k = 7; k >= 0; --k) {
            bits = this.getBits1(pi, pj, k, bits);
        }
        if (orientation != null) {
            if ((this.lowestOnBit() & 0x1111111111111110L) != 0L) {
                bits ^= 1;
            }
            orientation.setValue(bits);
        }
        return face;
    }

    private int getBits1(MutableInteger i, MutableInteger j, int k, int bits) {
        int nbits = k == 7 ? 2 : 4;
        bits += ((int)(this.id >>> k * 2 * 4 + 1) & (1 << 2 * nbits) - 1) << 2;
        bits = LOOKUP_IJ[bits];
        i.setValue(i.intValue() + (bits >> 6 << k * 4));
        j.setValue(j.intValue() + ((bits >> 2 & 0xF) << k * 4));
        return bits &= 3;
    }

    public long lowestOnBit() {
        return this.id & -this.id;
    }

    public static long lowestOnBitForLevel(int level) {
        return 1L << 2 * (30 - level);
    }

    private static int stToIJ(double s) {
        int m = 0x20000000;
        return (int)Math.max(0L, Math.min(0x3FFFFFFFL, Math.round(5.36870912E8 * s + 5.368709115E8)));
    }

    private static S2Point faceSiTiToXYZ(int face, int si, int ti) {
        double kScale = 9.313225746154785E-10;
        double u = S2Projections.stToUV(9.313225746154785E-10 * (double)si);
        double v = S2Projections.stToUV(9.313225746154785E-10 * (double)ti);
        return S2Projections.faceUvToXyz(face, u, v);
    }

    private static S2CellId fromFaceIJWrap(int face, int i, int j) {
        i = Math.max(-1, Math.min(0x40000000, i));
        j = Math.max(-1, Math.min(0x40000000, j));
        double kScale = 9.313225746154785E-10;
        double s = 9.313225746154785E-10 * (double)((i << 1) + 1 - 0x40000000);
        double t = 9.313225746154785E-10 * (double)((j << 1) + 1 - 0x40000000);
        S2Point p = S2Projections.faceUvToXyz(face, s, t);
        face = S2Projections.xyzToFace(p);
        R2Vector st = S2Projections.validFaceXyzToUv(face, p);
        return S2CellId.fromFaceIJ(face, S2CellId.stToIJ(st.x()), S2CellId.stToIJ(st.y()));
    }

    public static S2CellId fromFaceIJSame(int face, int i, int j, boolean sameFace) {
        if (sameFace) {
            return S2CellId.fromFaceIJ(face, i, j);
        }
        return S2CellId.fromFaceIJWrap(face, i, j);
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2CellId)) {
            return false;
        }
        S2CellId x = (S2CellId)that;
        return this.id() == x.id();
    }

    public static boolean unsignedLongLessThan(long x1, long x2) {
        return x1 + Long.MIN_VALUE < x2 + Long.MIN_VALUE;
    }

    public static boolean unsignedLongGreaterThan(long x1, long x2) {
        return x1 + Long.MIN_VALUE > x2 + Long.MIN_VALUE;
    }

    public boolean lessThan(S2CellId x) {
        return S2CellId.unsignedLongLessThan(this.id, x.id);
    }

    public boolean greaterThan(S2CellId x) {
        return S2CellId.unsignedLongGreaterThan(this.id, x.id);
    }

    public boolean lessOrEquals(S2CellId x) {
        return S2CellId.unsignedLongLessThan(this.id, x.id) || this.id == x.id;
    }

    public boolean greaterOrEquals(S2CellId x) {
        return S2CellId.unsignedLongGreaterThan(this.id, x.id) || this.id == x.id;
    }

    public int hashCode() {
        return (int)((this.id >>> 32) + this.id);
    }

    public String toString() {
        return "(face=" + this.face() + ", pos=" + Long.toHexString(this.pos()) + ", level=" + this.level() + ")";
    }

    private static void initLookupCell(int level, int i, int j, int origOrientation, int pos, int orientation) {
        if (level == 4) {
            int ij = (i << 4) + j;
            S2CellId.LOOKUP_POS[(ij << 2) + origOrientation] = (pos << 2) + orientation;
            S2CellId.LOOKUP_IJ[(pos << 2) + origOrientation] = (ij << 2) + orientation;
        } else {
            ++level;
            i <<= 1;
            j <<= 1;
            pos <<= 2;
            for (int subPos = 0; subPos < 4; ++subPos) {
                int ij = S2.posToIJ(orientation, subPos);
                int orientationMask = S2.posToOrientation(subPos);
                S2CellId.initLookupCell(level, i + (ij >>> 1), j + (ij & 1), origOrientation, pos + subPos, orientation ^ orientationMask);
            }
        }
    }

    @Override
    public int compareTo(S2CellId that) {
        return S2CellId.unsignedLongLessThan(this.id, that.id) ? -1 : (S2CellId.unsignedLongGreaterThan(this.id, that.id) ? 1 : 0);
    }

    static {
        S2CellId.initLookupCell(0, 0, 0, 0, 0, 0);
        S2CellId.initLookupCell(0, 0, 0, 1, 0, 1);
        S2CellId.initLookupCell(0, 0, 0, 2, 0, 2);
        S2CellId.initLookupCell(0, 0, 0, 3, 0, 3);
        maxValueDivs = new long[]{0L, 0L, Long.MAX_VALUE, 0x5555555555555555L, 0x3FFFFFFFFFFFFFFFL, 0x3333333333333333L, 0x2AAAAAAAAAAAAAAAL, 0x2492492492492492L, 0x1FFFFFFFFFFFFFFFL, 0x1C71C71C71C71C71L, 0x1999999999999999L, 1676976733973595601L, 0x1555555555555555L, 0x13B13B13B13B13B1L, 1317624576693539401L, 0x1111111111111111L, 0xFFFFFFFFFFFFFFFL, 0xF0F0F0F0F0F0F0FL, 0xE38E38E38E38E38L, 970881267037344821L, 0xCCCCCCCCCCCCCCCL, 0xC30C30C30C30C30L, 838488366986797800L, 802032351030850070L, 0xAAAAAAAAAAAAAAAL, 737869762948382064L, 0x9D89D89D89D89D8L, 683212743470724133L, 0x924924924924924L, 636094623231363848L, 0x888888888888888L, 595056260442243600L, 0x7FFFFFFFFFFFFFFL, 558992244657865200L, 0x787878787878787L, 0x750750750750750L, 0x71C71C71C71C71CL};
        maxValueMods = new int[]{0, 0, 1, 0, 3, 0, 3, 1, 7, 6, 5, 4, 3, 2, 1, 0, 15, 0, 15, 16, 15, 15, 15, 5, 15, 15, 15, 24, 15, 23, 15, 15, 31, 15, 17, 15, 15};
    }
}

