/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.router.jersey.DefaultJerseyStreamingHttpRouter;
import io.servicetalk.http.utils.HttpRequestUriUtils;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.router.utils.internal.DefaultRouteExecutionStrategyFactory;
import io.servicetalk.transport.api.ConnectionContext;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.ws.rs.core.Application;

public final class HttpJerseyRouterBuilder {
    private int publisherInputStreamQueueCapacity = 16;
    private BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction = (ctx, req) -> HttpRequestUriUtils.getBaseRequestUri((ConnectionContext)ctx, (HttpRequestMetaData)req, (boolean)false);
    private RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory = DefaultRouteExecutionStrategyFactory.defaultStrategyFactory();

    public HttpJerseyRouterBuilder publisherInputStreamQueueCapacity(int publisherInputStreamQueueCapacity) {
        if (publisherInputStreamQueueCapacity <= 0) {
            throw new IllegalArgumentException("Invalid queue capacity: " + publisherInputStreamQueueCapacity + " (expected > 0).");
        }
        this.publisherInputStreamQueueCapacity = publisherInputStreamQueueCapacity;
        return this;
    }

    public HttpJerseyRouterBuilder baseUriFunction(BiFunction<ConnectionContext, HttpRequestMetaData, String> baseUriFunction) {
        this.baseUriFunction = Objects.requireNonNull(baseUriFunction);
        return this;
    }

    public HttpJerseyRouterBuilder routeExecutionStrategyFactory(RouteExecutionStrategyFactory<HttpExecutionStrategy> strategyFactory) {
        this.strategyFactory = Objects.requireNonNull(strategyFactory);
        return this;
    }

    public HttpService build(Application application) {
        return HttpJerseyRouterBuilder.toAggregated(this.from(application));
    }

    public HttpService build(Class<? extends Application> applicationClass) {
        return HttpJerseyRouterBuilder.toAggregated(this.from(applicationClass));
    }

    public StreamingHttpService buildStreaming(Application application) {
        return this.from(application);
    }

    public StreamingHttpService buildStreaming(Class<? extends Application> applicationClass) {
        return this.from(applicationClass);
    }

    public BlockingHttpService buildBlocking(Application application) {
        return HttpJerseyRouterBuilder.toBlocking(this.from(application));
    }

    public BlockingHttpService buildBlocking(Class<? extends Application> applicationClass) {
        return HttpJerseyRouterBuilder.toBlocking(this.from(applicationClass));
    }

    public BlockingStreamingHttpService buildBlockingStreaming(Application application) {
        return HttpJerseyRouterBuilder.toBlockingStreaming(this.from(application));
    }

    public BlockingStreamingHttpService buildBlockingStreaming(Class<? extends Application> applicationClass) {
        return HttpJerseyRouterBuilder.toBlockingStreaming(this.from(applicationClass));
    }

    DefaultJerseyStreamingHttpRouter from(Class<? extends Application> applicationClass) {
        return new DefaultJerseyStreamingHttpRouter(applicationClass, this.publisherInputStreamQueueCapacity, this.baseUriFunction, this.strategyFactory);
    }

    DefaultJerseyStreamingHttpRouter from(Application application) {
        return new DefaultJerseyStreamingHttpRouter(application, this.publisherInputStreamQueueCapacity, this.baseUriFunction, this.strategyFactory);
    }

    static HttpService toAggregated(DefaultJerseyStreamingHttpRouter router) {
        return HttpApiConversions.toHttpService((StreamingHttpService)router);
    }

    static BlockingHttpService toBlocking(DefaultJerseyStreamingHttpRouter router) {
        return HttpApiConversions.toBlockingHttpService((StreamingHttpService)router);
    }

    static BlockingStreamingHttpService toBlockingStreaming(DefaultJerseyStreamingHttpRouter router) {
        return HttpApiConversions.toBlockingStreamingHttpService((StreamingHttpService)router);
    }
}

