/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.Uri;
import io.servicetalk.http.api.Uri3986;
import io.servicetalk.http.api.UriComponentType;
import io.servicetalk.http.api.UriUtils;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

final class HttpAuthorityFormUri
implements Uri {
    private final String uri;
    private final String host;
    private final int port;

    HttpAuthorityFormUri(String uri) {
        int i = 0;
        int begin = 0;
        String parsedHost = null;
        int parsedPort = -1;
        int parsingIPv6 = 0;
        boolean foundColonForPort = false;
        while (i < uri.length()) {
            char c = uri.charAt(i);
            if (c == '[') {
                if (parsingIPv6 != 0 || parsedHost != null) {
                    throw Uri3986.newUnexpectedOpenBracket(i, begin, parsedHost, uri);
                }
                parsingIPv6 = 1;
                begin = i++;
                continue;
            }
            if (c == ']') {
                if (parsingIPv6 == 0) {
                    throw Uri3986.newUnexpectedCloseBracket(i, parsedHost, uri);
                }
                if (parsingIPv6 == 2) {
                    throw Uri3986.newUnexpectedCloseBracketAfterIPv6(i, parsedHost, uri);
                }
                if (i - 1 <= begin) {
                    throw Uri3986.newEmptyIPv6Literal(begin, uri);
                }
                parsedHost = uri.substring(begin, i + 1);
                foundColonForPort = false;
                parsingIPv6 = 2;
                begin = ++i;
                continue;
            }
            if (c == ':') {
                if (parsingIPv6 == 0) {
                    if (parsedHost != null) {
                        throw Uri3986.newDuplicateHost(i, parsedHost, uri);
                    }
                    parsedHost = uri.substring(begin, i);
                } else if (parsingIPv6 == 2 && begin != i) {
                    throw Uri3986.newInvalidPortNumberPosition(i, begin, parsedHost, uri);
                }
                ++i;
                if (parsingIPv6 == 1) continue;
                begin = i;
                foundColonForPort = true;
                continue;
            }
            if (c == '@' || c == '?' || c == '#' || c == '/') {
                throw new IllegalArgumentException("Invalid URI format: authority-form URI doesn't allow userinfo, path, query, fragment, but found '" + c + "' character at index " + i + (parsedHost != null ? ". Parsed host: " + parsedHost : "") + ". Total URI length: " + uri.length());
            }
            ++i;
        }
        if (parsedHost == null) {
            if (parsingIPv6 == 1) {
                throw Uri3986.newMissingClosingBracket(i, begin, uri);
            }
            parsedHost = uri;
        } else if (foundColonForPort) {
            parsedPort = UriUtils.parsePort(uri, begin, uri.length());
        } else if (parsedHost.length() != uri.length()) {
            throw new IllegalArgumentException("Invalid URI format: Authority-form URI only supports the host component but found more characters. Parsed host: " + parsedHost + ", total URI length to parse: " + uri.length());
        }
        this.host = parsedHost;
        this.port = parsedPort;
        this.uri = uri;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    @Nullable
    public String scheme() {
        return null;
    }

    @Override
    public String authority() {
        StringBuilder sb = new StringBuilder(this.host.length() + 6);
        sb.append(this.host);
        if (this.port >= 0) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public String userInfo() {
        return null;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    public String path() {
        return "";
    }

    @Override
    public String path(Charset charset) {
        return "";
    }

    @Override
    @Nullable
    public String query() {
        return null;
    }

    @Override
    @Nullable
    public String query(Charset charset) {
        return null;
    }

    @Override
    @Nullable
    public String fragment() {
        return null;
    }

    static String encode(String requestTarget, Charset charset) {
        HttpAuthorityFormUri uri = new HttpAuthorityFormUri(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length() + 16);
        if (!uri.host.isEmpty()) {
            sb.append(uri.host.charAt(0) != '[' ? UriUtils.encodeComponent(UriComponentType.HOST_NON_IP, uri.host, charset, true) : uri.host);
        }
        if (uri.port >= 0) {
            sb.append(':').append(uri.port);
        }
        return sb.toString();
    }

    static String decode(String requestTarget, Charset charset) {
        HttpAuthorityFormUri uri = new HttpAuthorityFormUri(requestTarget);
        StringBuilder sb = new StringBuilder(uri.uri.length());
        if (!uri.host.isEmpty()) {
            sb.append(uri.host.charAt(0) != '[' ? UriUtils.decodeComponent(uri.host, charset) : uri.host);
        }
        if (uri.port >= 0) {
            sb.append(':').append(uri.port);
        }
        return sb.toString();
    }
}

