/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.model;

import de.bytefish.pgbulkinsert.util.PostgreSqlUtils;

public class TableDefinition {
    private final String schema;
    private final String tableName;

    public TableDefinition(String tableName) {
        this("", tableName);
    }

    public TableDefinition(String schema, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String GetFullyQualifiedTableName(boolean usePostgresQuoting) {
        return PostgreSqlUtils.getFullyQualifiedTableName(this.schema, this.tableName, usePostgresQuoting);
    }

    public String toString() {
        return String.format("TableDefinition (Schema = {%1$s}, TableName = {%2$s})", this.schema, this.tableName);
    }
}

