/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.baremaps.collection.DataCollectionException;
import org.apache.baremaps.collection.DataList;
import org.apache.baremaps.collection.memory.Memory;
import org.apache.baremaps.collection.memory.OffHeapMemory;
import org.apache.baremaps.collection.type.FixedSizeDataType;

public class MemoryAlignedDataList<E>
extends DataList<E> {
    private final FixedSizeDataType<E> dataType;
    private final Memory memory;
    private final int valueShift;
    private final long segmentShift;
    private final long segmentMask;
    private AtomicLong size;

    public MemoryAlignedDataList(FixedSizeDataType<E> dataType) {
        this(dataType, new OffHeapMemory());
    }

    public MemoryAlignedDataList(FixedSizeDataType<E> dataType, Memory memory) {
        if (dataType.size() > memory.segmentSize()) {
            throw new DataCollectionException("The segment size is too small for the data type");
        }
        if ((dataType.size() & -dataType.size()) != dataType.size()) {
            throw new IllegalArgumentException("The data type size must be a fixed power of 2");
        }
        if (memory.segmentSize() % dataType.size() != 0) {
            throw new DataCollectionException("The segment size and data type size must be aligned");
        }
        this.dataType = dataType;
        this.memory = memory;
        this.valueShift = (int)(Math.log(dataType.size()) / Math.log(2.0));
        this.segmentShift = memory.segmentShift();
        this.segmentMask = memory.segmentMask();
        this.size = new AtomicLong(0L);
    }

    private void write(long index, E value) {
        long position = index << this.valueShift;
        int segmentIndex = (int)(position >>> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        this.dataType.write(segment, segmentOffset, value);
    }

    @Override
    public long addIndexed(E value) {
        long index = this.size.getAndIncrement();
        this.write(index, value);
        return index;
    }

    @Override
    public void set(long index, E value) {
        if (index >= this.size.get()) {
            this.size.set(index + 1L);
        }
        this.write(index, value);
    }

    @Override
    public E get(long index) {
        long position = index << this.valueShift;
        int segmentIndex = (int)(position >> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        return (E)this.dataType.read(segment, segmentOffset);
    }

    @Override
    public long sizeAsLong() {
        return this.size.get();
    }

    @Override
    public void clear() {
        this.size.set(0L);
        try {
            this.memory.clear();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

