/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;

class GeoDegenerateHorizontalLine
extends GeoBaseBBox {
    protected final double latitude;
    protected final double leftLon;
    protected final double rightLon;
    protected final GeoPoint LHC;
    protected final GeoPoint RHC;
    protected final Plane plane;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final GeoPoint[] planePoints;
    protected final GeoPoint centerPoint;
    protected final GeoPoint[] edgePoints;

    public GeoDegenerateHorizontalLine(PlanetModel planetModel, double latitude, double leftLon, double rightLon) {
        super(planetModel);
        if (latitude > 1.5707963267948966 || latitude < -1.5707963267948966) {
            throw new IllegalArgumentException("Latitude out of range");
        }
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent > Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too great");
        }
        this.latitude = latitude;
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        this.LHC = new GeoPoint(planetModel, sinLatitude, sinLeftLon, cosLatitude, cosLeftLon, latitude, leftLon);
        this.RHC = new GeoPoint(planetModel, sinLatitude, sinRightLon, cosLatitude, cosRightLon, latitude, rightLon);
        this.plane = new Plane(planetModel, sinLatitude);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, sinLatitude, sinMiddleLon, cosLatitude, cosMiddleLon);
        this.leftPlane = new SidedPlane((Vector)this.RHC, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.LHC, cosRightLon, sinRightLon);
        assert (this.leftPlane.isWithin(this.centerPoint));
        assert (this.rightPlane.isWithin(this.centerPoint));
        this.planePoints = new GeoPoint[]{this.LHC, this.RHC};
        this.edgePoints = new GeoPoint[]{this.centerPoint};
    }

    public GeoDegenerateHorizontalLine(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.latitude);
        SerializableObject.writeDouble(outputStream, this.leftLon);
        SerializableObject.writeDouble(outputStream, this.rightLon);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.plane.evaluateIsZero(x, y, z) && this.leftPlane.isWithin(x, y, z) && this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double topAngle = this.centerPoint.arcDistance(this.RHC);
        double bottomAngle = this.centerPoint.arcDistance(this.LHC);
        return Math.max(topAngle, bottomAngle);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, this.planePoints, bounds, this.leftPlane, this.rightPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.plane, this.planePoints, this.leftPlane, this.rightPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addHorizontalPlane(this.planetModel, this.latitude, this.plane, this.leftPlane, this.rightPlane).addPoint(this.LHC).addPoint(this.RHC);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (this.intersects(path)) {
            return 2;
        }
        if (path.isWithin(this.centerPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double distance = distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, this.leftPlane, this.rightPlane);
        double LHCDistance = distanceStyle.computeDistance(this.LHC, x, y, z);
        double RHCDistance = distanceStyle.computeDistance(this.RHC, x, y, z);
        return Math.min(distance, Math.min(LHCDistance, RHCDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateHorizontalLine)) {
            return false;
        }
        GeoDegenerateHorizontalLine other = (GeoDegenerateHorizontalLine)o;
        return super.equals(other) && other.LHC.equals(this.LHC) && other.RHC.equals(this.RHC);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.LHC.hashCode();
        result = 31 * result + this.RHC.hashCode();
        return result;
    }

    public String toString() {
        return "GeoDegenerateHorizontalLine: {planetmodel=" + this.planetModel + ", latitude=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + "), leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightLon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

